/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.AnimationComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsContext;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.layers.ParentLayerComponent;
import org.jetbrains.letsPlot.livemap.geometry.WorldGeometryComponent;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.Renderer;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect;", "", "()V", "length", "", "p1", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "p2", "GrowingPathEffectComponent", "GrowingPathEffectSystem", "GrowingPathRenderer", "livemap"})
public final class GrowingPathEffect {
    @NotNull
    public static final GrowingPathEffect INSTANCE = new GrowingPathEffect();

    private GrowingPathEffect() {
    }

    private final double length(Vec<?> p1, Vec<?> p2) {
        double x = p2.getX() - p1.getX();
        double y = p2.getY() - p1.getY();
        return Math.sqrt(x * x + y * y);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathEffectComponent;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponent;", "()V", "animationId", "", "getAnimationId", "()I", "setAnimationId", "(I)V", "endIndex", "getEndIndex", "setEndIndex", "interpolatedPoint", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "getInterpolatedPoint", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "setInterpolatedPoint", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;)V", "length", "", "getLength", "()D", "setLength", "(D)V", "lengthIndex", "", "getLengthIndex", "()Ljava/util/List;", "setLengthIndex", "(Ljava/util/List;)V", "livemap"})
    public static final class GrowingPathEffectComponent
    implements EcsComponent {
        private int animationId;
        @NotNull
        private List<Double> lengthIndex = CollectionsKt.emptyList();
        private double length;
        private int endIndex;
        @Nullable
        private Vec<? extends Client> interpolatedPoint;

        public final int getAnimationId() {
            return this.animationId;
        }

        public final void setAnimationId(int n) {
            this.animationId = n;
        }

        @NotNull
        public final List<Double> getLengthIndex() {
            return this.lengthIndex;
        }

        public final void setLengthIndex(@NotNull List<Double> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.lengthIndex = list;
        }

        public final double getLength() {
            return this.length;
        }

        public final void setLength(double d) {
            this.length = d;
        }

        public final int getEndIndex() {
            return this.endIndex;
        }

        public final void setEndIndex(int n) {
            this.endIndex = n;
        }

        @Nullable
        public final Vec<Client> getInterpolatedPoint() {
            return this.interpolatedPoint;
        }

        public final void setInterpolatedPoint(@Nullable Vec<? extends Client> vec) {
            this.interpolatedPoint = vec;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\rH\u0014J\u0018\u0010\u0011\u001a\u00020\u0007*\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathEffectSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "calculateEffectState", "", "effectComponent", "Lorg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathEffectComponent;", "path", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/LineString;", "progress", "", "updateImpl", "context", "dt", "init", "Companion", "livemap"})
    @SourceDebugExtension(value={"SMAP\nGrowingPathEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowingPathEffect.kt\norg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathEffectSystem\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,157:1\n24#2,2:158\n24#2,2:160\n24#2,2:162\n*S KotlinDebug\n*F\n+ 1 GrowingPathEffect.kt\norg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathEffectSystem\n*L\n37#1:158,2\n39#1:160,2\n46#1:162,2\n*E\n"})
    public static final class GrowingPathEffectSystem
    extends AbstractSystem<EcsContext> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final List<KClass<? extends EcsComponent>> COMPONENT_TYPES;

        public GrowingPathEffectSystem(@NotNull EcsComponentManager componentManager) {
            Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
            super(componentManager);
        }

        @Override
        protected void updateImpl(@NotNull EcsContext context, double dt) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterator iterator = this.getEntities(COMPONENT_TYPES).iterator();
            while (iterator.hasNext()) {
                EcsEntity animation;
                EcsEntity entity2;
                EcsEntity this_$iv = entity2 = (EcsEntity)iterator.next();
                boolean $i$f$get = false;
                EcsComponent ecsComponent = (WorldGeometryComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class));
                if (ecsComponent == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class).getSimpleName() + " is not found");
                }
                LineString path = (LineString)CollectionsKt.single((List)((List)((WorldGeometryComponent)ecsComponent).getGeometry().getMultiLineString()));
                EcsEntity this_$iv2 = entity2;
                boolean $i$f$get2 = false;
                EcsComponent ecsComponent2 = (GrowingPathEffectComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(GrowingPathEffectComponent.class));
                if (ecsComponent2 == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(GrowingPathEffectComponent.class).getSimpleName() + " is not found");
                }
                GrowingPathEffectComponent effectComponent = (GrowingPathEffectComponent)ecsComponent2;
                if (effectComponent.getLengthIndex().isEmpty()) {
                    this.init(effectComponent, path);
                }
                if (this.getEntityById(effectComponent.getAnimationId()) == null) {
                    return;
                }
                EcsEntity this_$iv3 = animation;
                boolean $i$f$get3 = false;
                EcsComponent ecsComponent3 = (AnimationComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(AnimationComponent.class));
                if (ecsComponent3 == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(AnimationComponent.class).getSimpleName() + " is not found");
                }
                this.calculateEffectState(effectComponent, path, ((AnimationComponent)ecsComponent3).getProgress());
                ParentLayerComponent.Companion.tagDirtyParentLayer(entity2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void init(GrowingPathEffectComponent $this$init, LineString<?> path) {
            void $this$init_u24lambda_u240;
            ArrayList arrayList;
            double l = 0.0;
            ArrayList arrayList2 = arrayList = new ArrayList(path.size());
            GrowingPathEffectComponent growingPathEffectComponent = $this$init;
            boolean bl = false;
            $this$init_u24lambda_u240.add(0.0);
            int n = path.size();
            for (int i = 1; i < n; ++i) {
                $this$init_u24lambda_u240.add(l += INSTANCE.length((Vec)path.get(i - 1), (Vec)path.get(i)));
            }
            growingPathEffectComponent.setLengthIndex(arrayList);
            $this$init.setLength(l);
        }

        private final void calculateEffectState(GrowingPathEffectComponent effectComponent, LineString<?> path, double progress) {
            double length;
            double current;
            List<Double> lengthIndex = effectComponent.getLengthIndex();
            int index = CollectionsKt.binarySearch$default(lengthIndex, (Comparable)Double.valueOf(current = (length = effectComponent.getLength()) * progress), (int)0, (int)0, (int)6, null);
            if (index >= 0) {
                effectComponent.setEndIndex(index);
                effectComponent.setInterpolatedPoint(null);
                return;
            }
            if ((index = ~index - 1) == lengthIndex.size() - 1) {
                effectComponent.setEndIndex(index);
                effectComponent.setInterpolatedPoint(null);
                return;
            }
            double l1 = ((Number)lengthIndex.get(index)).doubleValue();
            double l2 = ((Number)lengthIndex.get(index + 1)).doubleValue();
            double dl = l2 - l1;
            if (dl > 2.0) {
                double dp = dl / length;
                double p1 = l1 / length;
                double p = (progress - p1) / dp;
                Vec v1 = (Vec)path.get(index);
                Vec v2 = (Vec)path.get(index + 1);
                effectComponent.setEndIndex(index);
                effectComponent.setInterpolatedPoint((Vec<? extends Client>)VecKt.explicitVec((double)(v1.getX() + (v2.getX() - v1.getX()) * p), (double)(v1.getY() + (v2.getY() - v1.getY()) * p)));
            } else {
                effectComponent.setEndIndex(index);
                effectComponent.setInterpolatedPoint(null);
            }
        }

        static {
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(GrowingPathEffectComponent.class), Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class), Reflection.getOrCreateKotlinClass(WorldOriginComponent.class), Reflection.getOrCreateKotlinClass(ParentLayerComponent.class)};
            COMPONENT_TYPES = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathEffectSystem$Companion;", "", "()V", "COMPONENT_TYPES", "", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponent;", "livemap"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathRenderer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/Renderer;", "()V", "render", "", "entity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "livemap"})
    @SourceDebugExtension(value={"SMAP\nGrowingPathEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrowingPathEffect.kt\norg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathRenderer\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n24#2,2:158\n24#2,2:160\n24#2,2:162\n1#3:164\n*S KotlinDebug\n*F\n+ 1 GrowingPathEffect.kt\norg/jetbrains/letsPlot/livemap/chart/GrowingPathEffect$GrowingPathRenderer\n*L\n132#1:158,2\n133#1:160,2\n134#1:162,2\n*E\n"})
    public static final class GrowingPathRenderer
    implements Renderer {
        @Override
        public void render(@NotNull EcsEntity entity2, @NotNull Context2d ctx, @NotNull RenderHelper renderHelper) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
            EcsEntity this_$iv = entity2;
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (ChartElementComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
            }
            ChartElementComponent chartElement = (ChartElementComponent)ecsComponent;
            EcsEntity this_$iv2 = entity2;
            boolean $i$f$get2 = false;
            EcsComponent ecsComponent2 = (WorldGeometryComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class).getSimpleName() + " is not found");
            }
            LineString lineString = (LineString)CollectionsKt.single((List)((List)((WorldGeometryComponent)ecsComponent2).getGeometry().getMultiLineString()));
            EcsEntity this_$iv3 = entity2;
            boolean $i$f$get3 = false;
            EcsComponent ecsComponent3 = (GrowingPathEffectComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(GrowingPathEffectComponent.class));
            if (ecsComponent3 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(GrowingPathEffectComponent.class).getSimpleName() + " is not found");
            }
            GrowingPathEffectComponent growingPath = (GrowingPathEffectComponent)ecsComponent3;
            ctx.save();
            ctx.scale(renderHelper.getZoomFactor());
            ctx.beginPath();
            Vec viewCoord = (Vec)lineString.get(0);
            ctx.moveTo(viewCoord.getX(), viewCoord.getY());
            int i = 1;
            int n = growingPath.getEndIndex();
            if (i <= n) {
                while (true) {
                    viewCoord = (Vec)lineString.get(i);
                    ctx.lineTo(viewCoord.getX(), viewCoord.getY());
                    if (i == n) break;
                    ++i;
                }
            }
            Vec<Client> vec = growingPath.getInterpolatedPoint();
            if (vec != null) {
                Vec<Client> it = vec;
                boolean bl = false;
                ctx.lineTo(it.getX(), it.getY());
            }
            ctx.restore();
            ctx.setStrokeStyle(chartElement.getStrokeColor());
            ctx.setLineWidth(chartElement.getStrokeWidth());
            ctx.stroke();
        }
    }
}

