/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.CoordinateKt;
import org.jetbrains.letsPlot.livemap.chart.HoverObject;
import org.jetbrains.letsPlot.livemap.chart.HoverObjectDetectionSystem$updateImpl$lambda$3$;
import org.jetbrains.letsPlot.livemap.chart.LocatorComponent;
import org.jetbrains.letsPlot.livemap.chart.SearchResultComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsContext;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.input.MouseInputComponent;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.ui.UiService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\f\u0010\u000e\u001a\u00020\t*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/HoverObjectDetectionSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "uiService", "Lorg/jetbrains/letsPlot/livemap/ui/UiService;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/ui/UiService;Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "initImpl", "", "context", "updateImpl", "dt", "", "clearResult", "Lorg/jetbrains/letsPlot/livemap/chart/SearchResultComponent;", "livemap"})
@SourceDebugExtension(value={"SMAP\nHoverObjectDetectionSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoverObjectDetectionSystem.kt\norg/jetbrains/letsPlot/livemap/chart/HoverObjectDetectionSystem\n+ 2 Extensions.kt\norg/jetbrains/letsPlot/livemap/core/ecs/ExtensionsKt\n+ 3 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n21#2:88\n35#2,2:89\n9#2:93\n38#2:124\n22#2:125\n24#3,2:91\n988#4:94\n1017#4,3:95\n1020#4,3:105\n372#5,7:98\n766#6:108\n857#6,2:109\n1603#6,9:111\n1855#6:120\n1856#6:122\n1612#6:123\n1#7:121\n*S KotlinDebug\n*F\n+ 1 HoverObjectDetectionSystem.kt\norg/jetbrains/letsPlot/livemap/chart/HoverObjectDetectionSystem\n*L\n30#1:88\n30#1:89,2\n67#1:93\n30#1:124\n30#1:125\n30#1:91,2\n69#1:94\n69#1:95,3\n69#1:105,3\n69#1:98,7\n71#1:108\n71#1:109,2\n72#1:111,9\n72#1:120\n72#1:122\n72#1:123\n72#1:121\n*E\n"})
public final class HoverObjectDetectionSystem
extends AbstractSystem<LiveMapContext> {
    @NotNull
    private final UiService uiService;

    public HoverObjectDetectionSystem(@NotNull UiService uiService, @NotNull EcsComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)uiService, (String)"uiService");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(componentManager);
        this.uiService = uiService;
    }

    @Override
    protected void initImpl(@NotNull LiveMapContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.initImpl((EcsContext)context);
        this.createEntity("hover_object").add(new SearchResultComponent()).add(new MouseInputComponent());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateImpl(@NotNull LiveMapContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AbstractSystem $this$onEachEntity2$iv = this;
        boolean $i$f$onEachEntity2 = false;
        EcsComponentManager $this$onEachEntity2$iv$iv = $this$onEachEntity2$iv.getComponentManager();
        boolean $i$f$onEachEntity22 = false;
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(SearchResultComponent.class), Reflection.getOrCreateKotlinClass(MouseInputComponent.class)};
        Iterator iterator = $this$onEachEntity2$iv$iv.getEntities(CollectionsKt.listOf((Object[])objectArray)).iterator();
        while (iterator.hasNext()) {
            SearchResultComponent searchResultComponent;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object p0;
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv;
            void mouseInputComponent;
            EcsEntity entity$iv$iv;
            EcsEntity this_$iv$iv$iv = entity$iv$iv = (EcsEntity)iterator.next();
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (SearchResultComponent)this_$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(SearchResultComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(SearchResultComponent.class).getSimpleName() + " is not found");
            }
            this_$iv$iv$iv = entity$iv$iv;
            $i$f$get = false;
            EcsComponent ecsComponent2 = (MouseInputComponent)this_$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(MouseInputComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(MouseInputComponent.class).getSimpleName() + " is not found");
            }
            MouseInputComponent mouseInputComponent2 = (MouseInputComponent)ecsComponent2;
            SearchResultComponent hoverObjectComponent = (SearchResultComponent)ecsComponent;
            boolean bl = false;
            if (mouseInputComponent.getDoubleClickEvent() != null) {
                this.clearResult(hoverObjectComponent);
                return;
            }
            if (mouseInputComponent.getDragState() != null) {
                this.clearResult(hoverObjectComponent);
                return;
            }
            Vec<Client> vec = mouseInputComponent.getMoveEvent();
            if (vec == null || (vec = vec.getLocation()) == null || (vec = CoordinateKt.toClientPoint((Vector)vec)) == null) {
                return;
            }
            Vec<Client> mouseLocation = vec;
            if (this.uiService.containsElementAtCoord(mouseLocation)) {
                this.clearResult(hoverObjectComponent);
                return;
            }
            if (context.getCamera().isZoomFractionChanged() && !context.getCamera().isZoomLevelChanged()) {
                this.clearResult(hoverObjectComponent);
                return;
            }
            if (Intrinsics.areEqual(hoverObjectComponent.getCursorPosition(), mouseLocation)) {
                Integer n = hoverObjectComponent.getZoom();
                if (Intrinsics.areEqual((Double)(n != null ? Double.valueOf(n.intValue()) : null), (double)context.getCamera().getZoom())) {
                    return;
                }
            }
            RenderHelper renderHelper = new RenderHelper(context.getMapRenderContext().getViewport());
            AbstractSystem $this$getEntities2$iv = this;
            boolean $i$f$getEntities2 = false;
            $this$getEntities2$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter($this$getEntities2$iv.getComponentManager().getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(LocatorComponent.class)), (Function1)updateImpl$lambda$3$$inlined$getEntities2$1.INSTANCE), (Function1)((Function1)new Function1<EcsEntity, HoverObject>(mouseLocation, renderHelper){
                final /* synthetic */ Vec<Client> $mouseLocation;
                final /* synthetic */ RenderHelper $renderHelper;
                {
                    this.$mouseLocation = $mouseLocation;
                    this.$renderHelper = $renderHelper;
                    super(1);
                }

                @Nullable
                public final HoverObject invoke(@NotNull EcsEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EcsEntity this_$iv = it;
                    boolean $i$f$get = false;
                    EcsComponent ecsComponent = (LocatorComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(LocatorComponent.class));
                    if (ecsComponent == null) {
                        throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(LocatorComponent.class).getSimpleName() + " is not found");
                    }
                    return ((LocatorComponent)ecsComponent).getLocator().search(this.$mouseLocation, it, this.$renderHelper);
                }
            }));
            boolean $i$f$groupBy = false;
            void var19_20 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                p0 = (HoverObject)element$iv$iv;
                boolean bl2 = false;
                Integer key$iv$iv = ((HoverObject)p0).getLayerIndex();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv.values();
            boolean $i$f$filter = false;
            $this$groupByTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (List)element$iv$iv;
                boolean bl4 = false;
                if (!(!((Collection)p0).isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                HoverObject it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl5 = false;
                List hoverObjects = (List)element$iv$iv;
                boolean bl6 = false;
                if (((HoverObject)CollectionsKt.first((List)hoverObjects)).getLocator().reduce(hoverObjects) == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List objects2 = (List)destination$iv$iv;
            SearchResultComponent $this$updateImpl_u24lambda_u243_u24lambda_u242 = searchResultComponent = hoverObjectComponent;
            boolean bl8 = false;
            $this$updateImpl_u24lambda_u243_u24lambda_u242.setCursorPosition(mouseLocation);
            $this$updateImpl_u24lambda_u243_u24lambda_u242.setZoom((int)context.getCamera().getZoom());
            $this$updateImpl_u24lambda_u243_u24lambda_u242.setHoverObjects(objects2);
        }
    }

    private final void clearResult(SearchResultComponent $this$clearResult) {
        $this$clearResult.setCursorPosition(null);
        $this$clearResult.setZoom(null);
        $this$clearResult.setHoverObjects(CollectionsKt.emptyList());
    }
}

