/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.donut;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Scalar;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.HoverObject;
import org.jetbrains.letsPlot.livemap.chart.HoverObjectKind;
import org.jetbrains.letsPlot.livemap.chart.IndexComponent;
import org.jetbrains.letsPlot.livemap.chart.PieSpecComponent;
import org.jetbrains.letsPlot.livemap.chart.donut.Sector;
import org.jetbrains.letsPlot.livemap.chart.donut.SectorKt;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J`\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J(\u0010\u0015\u001a\u0004\u0018\u00010\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/donut/Locator;", "Lorg/jetbrains/letsPlot/livemap/chart/Locator;", "()V", "isCoordinateInPieSector", "", "T", "p", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "pieCenter", "pieRadius", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Scalar;", "holeRadius", "startAngle", "", "endAngle", "isCoordinateInPieSector-6vWS9Qs", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;DDDD)Z", "reduce", "Lorg/jetbrains/letsPlot/livemap/chart/HoverObject;", "hoverObjects", "", "search", "coord", "Lorg/jetbrains/letsPlot/livemap/Client;", "target", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "livemap"})
@SourceDebugExtension(value={"SMAP\nLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Locator.kt\norg/jetbrains/letsPlot/livemap/chart/donut/Locator\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n24#2,2:79\n24#2,2:81\n24#2,2:83\n24#2,2:86\n1855#3:85\n1856#3:88\n*S KotlinDebug\n*F\n+ 1 Locator.kt\norg/jetbrains/letsPlot/livemap/chart/donut/Locator\n*L\n28#1:79,2\n29#1:81,2\n30#1:83,2\n44#1:86,2\n32#1:85\n32#1:88\n*E\n"})
public final class Locator
implements org.jetbrains.letsPlot.livemap.chart.Locator {
    @NotNull
    public static final Locator INSTANCE = new Locator();

    private Locator() {
    }

    @Override
    @Nullable
    public HoverObject search(@NotNull Vec<? extends Client> coord, @NotNull EcsEntity target, @NotNull RenderHelper renderHelper) {
        Intrinsics.checkNotNullParameter(coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        if (!target.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(PieSpecComponent.class))) {
            return null;
        }
        EcsEntity this_$iv = target;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (ChartElementComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
        }
        ChartElementComponent chartElement = (ChartElementComponent)ecsComponent;
        EcsEntity this_$iv2 = target;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (PieSpecComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(PieSpecComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(PieSpecComponent.class).getSimpleName() + " is not found");
        }
        PieSpecComponent pieSpec = (PieSpecComponent)ecsComponent2;
        EcsEntity this_$iv3 = target;
        boolean $i$f$get3 = false;
        EcsComponent ecsComponent3 = (WorldOriginComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(WorldOriginComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldOriginComponent.class).getSimpleName() + " is not found");
        }
        Vec<World> origin = ((WorldOriginComponent)ecsComponent3).getOrigin();
        Iterable $this$forEach$iv = SectorKt.computeSectors(pieSpec, chartElement.getScalingSizeFactor());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sector sector = (Sector)element$iv;
            boolean bl = false;
            if (!INSTANCE.isCoordinateInPieSector-6vWS9Qs(renderHelper.posToWorld(coord), origin, renderHelper.dimToWorld-VvMBhYE(sector.getRadiusWithStroke()), renderHelper.dimToWorld-VvMBhYE(sector.getHoleRadiusWithStroke()), sector.getStartAngle(), sector.getEndAngle())) continue;
            EcsEntity this_$iv4 = target;
            boolean $i$f$get4 = false;
            EcsComponent ecsComponent4 = (IndexComponent)this_$iv4.getComponentManager().getComponents(this_$iv4).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
            if (ecsComponent4 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
            }
            return new HoverObject(HoverObjectKind.POINT, ((IndexComponent)ecsComponent4).getLayerIndex(), sector.getIndex(), 0.0, this, null, null, 96, null);
        }
        return null;
    }

    @Override
    @Nullable
    public HoverObject reduce(@NotNull Collection<HoverObject> hoverObjects) {
        Intrinsics.checkNotNullParameter(hoverObjects, (String)"hoverObjects");
        return (HoverObject)CollectionsKt.firstOrNull((Iterable)hoverObjects);
    }

    private final <T> boolean isCoordinateInPieSector-6vWS9Qs(Vec<? extends T> p, Vec<? extends T> pieCenter, double pieRadius, double holeRadius, double startAngle, double endAngle) {
        Vec d = VecKt.minus(p, pieCenter);
        if (Scalar.compareTo-hZjkWWM((double)VecKt.getLength((Vec)d), (double)holeRadius) < 0) {
            return false;
        }
        if (Scalar.compareTo-hZjkWWM((double)VecKt.getLength((Vec)d), (double)pieRadius) > 0) {
            return false;
        }
        double it = Math.atan2(d.getY(), d.getX());
        boolean bl = false;
        double angle = (-1.5707963267948966 <= it ? it <= Math.PI : false) && Math.abs(startAngle) > Math.PI ? it - Math.PI * 2 : ((-Math.PI <= it ? it <= -1.5707963267948966 : false) && Math.abs(endAngle) > Math.PI ? it + Math.PI * 2 : it);
        return startAngle <= angle && angle < endAngle;
    }
}

