/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.donut;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.PieSpecComponent;
import org.jetbrains.letsPlot.livemap.chart.UtilsKt;
import org.jetbrains.letsPlot.livemap.chart.donut.Sector;
import org.jetbrains.letsPlot.livemap.chart.donut.SectorKt;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.mapengine.Context2dExKt;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/donut/Renderer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/Renderer;", "()V", "render", "", "entity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "livemap"})
@SourceDebugExtension(value={"SMAP\nRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderer.kt\norg/jetbrains/letsPlot/livemap/chart/donut/Renderer\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n24#2,2:115\n24#2,2:117\n24#2,2:119\n1855#3,2:121\n*S KotlinDebug\n*F\n+ 1 Renderer.kt\norg/jetbrains/letsPlot/livemap/chart/donut/Renderer\n*L\n20#1:115,2\n21#1:117,2\n23#1:119,2\n108#1:121,2\n*E\n"})
public final class Renderer
implements org.jetbrains.letsPlot.livemap.mapengine.Renderer {
    @Override
    public void render(@NotNull EcsEntity entity2, @NotNull Context2d ctx, @NotNull RenderHelper renderHelper) {
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        EcsEntity this_$iv = entity2;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (ChartElementComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
        }
        ChartElementComponent chartElement = (ChartElementComponent)ecsComponent;
        EcsEntity this_$iv2 = entity2;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (PieSpecComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(PieSpecComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(PieSpecComponent.class).getSimpleName() + " is not found");
        }
        PieSpecComponent pieSpec = (PieSpecComponent)ecsComponent2;
        this_$iv2 = entity2;
        $i$f$get2 = false;
        EcsComponent ecsComponent3 = (WorldOriginComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(WorldOriginComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldOriginComponent.class).getSimpleName() + " is not found");
        }
        Context2dExKt.translate(ctx, renderHelper.dimToScreen(((WorldOriginComponent)ecsComponent3).getOrigin()));
        Iterable $this$forEach$iv = SectorKt.computeSectors(pieSpec, chartElement.getScalingSizeFactor());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sector sector = (Sector)element$iv;
            boolean bl = false;
            Renderer.render$fillSector(ctx, chartElement, sector);
            Renderer.render$arcs(ctx, sector);
            Renderer.render$spacers(ctx, sector);
        }
    }

    private static final void render$fillSector(Context2d $ctx, ChartElementComponent chartElement, Sector sector) {
        if (sector.getFillColor() == null) {
            return;
        }
        $ctx.setFillStyle(UtilsKt.alphaScaledColor(sector.getFillColor(), chartElement.getScalingAlphaValue()));
        $ctx.beginPath();
        Sector $this$render_u24fillSector_u24lambda_u240 = sector;
        boolean bl = false;
        Context2d.DefaultImpls.arc$default((Context2d)$ctx, (double)$this$render_u24fillSector_u24lambda_u240.getSectorCenter().getX(), (double)$this$render_u24fillSector_u24lambda_u240.getSectorCenter().getY(), (double)$this$render_u24fillSector_u24lambda_u240.getHoleRadius(), (double)$this$render_u24fillSector_u24lambda_u240.getStartAngle(), (double)$this$render_u24fillSector_u24lambda_u240.getEndAngle(), (boolean)false, (int)32, null);
        $ctx.arc($this$render_u24fillSector_u24lambda_u240.getSectorCenter().getX(), $this$render_u24fillSector_u24lambda_u240.getSectorCenter().getY(), $this$render_u24fillSector_u24lambda_u240.getRadius(), $this$render_u24fillSector_u24lambda_u240.getEndAngle(), $this$render_u24fillSector_u24lambda_u240.getStartAngle(), true);
        $ctx.fill();
    }

    private static final void render$arcs(Context2d $ctx, Sector sector) {
        Context2d context2d;
        if (sector.getStrokeColor() == null || sector.getStrokeWidth() == 0.0) {
            return;
        }
        Context2d $this$render_u24arcs_u24lambda_u241 = context2d = $ctx;
        boolean bl = false;
        $this$render_u24arcs_u24lambda_u241.setStrokeStyle(sector.getStrokeColor());
        $this$render_u24arcs_u24lambda_u241.setLineWidth(sector.getStrokeWidth());
        if (sector.getDrawInnerArc()) {
            $this$render_u24arcs_u24lambda_u241.beginPath();
            Context2d.DefaultImpls.arc$default((Context2d)$this$render_u24arcs_u24lambda_u241, (double)sector.getSectorCenter().getX(), (double)sector.getSectorCenter().getY(), (double)Math.max(0.0, sector.getHoleRadius()), (double)sector.getStartAngle(), (double)sector.getEndAngle(), (boolean)false, (int)32, null);
            $this$render_u24arcs_u24lambda_u241.stroke();
        }
        if (sector.getDrawOuterArc()) {
            $this$render_u24arcs_u24lambda_u241.beginPath();
            Context2d.DefaultImpls.arc$default((Context2d)$this$render_u24arcs_u24lambda_u241, (double)sector.getSectorCenter().getX(), (double)sector.getSectorCenter().getY(), (double)sector.getRadius(), (double)sector.getStartAngle(), (double)sector.getEndAngle(), (boolean)false, (int)32, null);
            $this$render_u24arcs_u24lambda_u241.stroke();
        }
    }

    private static final void render$spacers(Context2d $ctx, Sector sector) {
        Context2d context2d;
        if (sector.getSpacerColor() == null || sector.getSpacerWidth() == 0.0) {
            return;
        }
        Context2d $this$render_u24spacers_u24lambda_u242 = context2d = $ctx;
        boolean bl = false;
        $this$render_u24spacers_u24lambda_u242.setStrokeStyle(sector.getSpacerColor());
        $this$render_u24spacers_u24lambda_u242.setLineWidth(sector.getSpacerWidth());
        if (sector.getDrawSpacerAtStart()) {
            $this$render_u24spacers_u24lambda_u242.beginPath();
            $this$render_u24spacers_u24lambda_u242.moveTo(sector.getInnerArcStart().getX(), sector.getInnerArcStart().getY());
            $this$render_u24spacers_u24lambda_u242.lineTo(sector.getOuterArcStart().getX(), sector.getOuterArcStart().getY());
            $this$render_u24spacers_u24lambda_u242.stroke();
        }
        if (sector.getDrawSpacerAtEnd()) {
            $this$render_u24spacers_u24lambda_u242.beginPath();
            $this$render_u24spacers_u24lambda_u242.moveTo(sector.getInnerArcEnd().getX(), sector.getInnerArcEnd().getY());
            $this$render_u24spacers_u24lambda_u242.lineTo(sector.getOuterArcEnd().getX(), sector.getOuterArcEnd().getY());
            $this$render_u24spacers_u24lambda_u242.stroke();
        }
    }
}

