/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.donut;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0000\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u000e\u0012\u0006\u0010\u0013\u001a\u00020\u000e\u0012\u0006\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010:\u001a\u00020'2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010;\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010<\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0011\u0010,\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0011\u0010.\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010)R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001eR\u0011\u00101\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001eR\u0011\u00103\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010)R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010 R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001eR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010 R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001e\u00a8\u0006="}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/donut/Sector;", "", "index", "", "radius", "", "holeRadius", "startAngle", "endAngle", "fillColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "strokeColor", "strokeWidth", "drawInnerArc", "", "drawOuterArc", "spacerColor", "spacerWidth", "drawSpacerAtStart", "drawSpacerAtEnd", "explode", "(IDDDDLorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/commons/values/Color;DZZLorg/jetbrains/letsPlot/commons/values/Color;DZZD)V", "angle", "direction", "getDrawInnerArc", "()Z", "getDrawOuterArc", "getDrawSpacerAtEnd", "getDrawSpacerAtStart", "getEndAngle", "()D", "getFillColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "getHoleRadius", "holeRadiusWithStroke", "getHoleRadiusWithStroke", "getIndex", "()I", "innerArcEnd", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getInnerArcEnd", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "innerArcStart", "getInnerArcStart", "outerArcEnd", "getOuterArcEnd", "outerArcStart", "getOuterArcStart", "getRadius", "radiusWithStroke", "getRadiusWithStroke", "sectorCenter", "getSectorCenter", "getSpacerColor", "getSpacerWidth", "getStartAngle", "getStrokeColor", "getStrokeWidth", "arcPoint", "innerArcPoint", "outerArcPoint", "livemap"})
public final class Sector {
    private final int index;
    private final double radius;
    private final double holeRadius;
    private final double startAngle;
    private final double endAngle;
    @Nullable
    private final Color fillColor;
    @Nullable
    private final Color strokeColor;
    private final double strokeWidth;
    private final boolean drawInnerArc;
    private final boolean drawOuterArc;
    @Nullable
    private final Color spacerColor;
    private final double spacerWidth;
    private final boolean drawSpacerAtStart;
    private final boolean drawSpacerAtEnd;
    private final double angle;
    private final double direction;
    @NotNull
    private final DoubleVector sectorCenter;
    private final double radiusWithStroke;
    private final double holeRadiusWithStroke;
    @NotNull
    private final DoubleVector outerArcStart;
    @NotNull
    private final DoubleVector outerArcEnd;
    @NotNull
    private final DoubleVector innerArcStart;
    @NotNull
    private final DoubleVector innerArcEnd;

    public Sector(int index, double radius, double holeRadius, double startAngle, double endAngle, @Nullable Color fillColor, @Nullable Color strokeColor, double strokeWidth, boolean drawInnerArc, boolean drawOuterArc, @Nullable Color spacerColor, double spacerWidth, boolean drawSpacerAtStart, boolean drawSpacerAtEnd, double explode) {
        double d;
        double d2;
        this.index = index;
        this.radius = radius;
        this.holeRadius = holeRadius;
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.fillColor = fillColor;
        this.strokeColor = strokeColor;
        this.strokeWidth = strokeWidth;
        this.drawInnerArc = drawInnerArc;
        this.drawOuterArc = drawOuterArc;
        this.spacerColor = spacerColor;
        this.spacerWidth = spacerWidth;
        this.drawSpacerAtStart = drawSpacerAtStart;
        this.drawSpacerAtEnd = drawSpacerAtEnd;
        this.angle = this.endAngle - this.startAngle;
        this.direction = this.startAngle + this.angle / (double)2;
        this.sectorCenter = new DoubleVector(explode * Math.cos(this.direction), explode * Math.sin(this.direction));
        boolean bl = this.drawOuterArc;
        if (bl) {
            d2 = this.radius + this.strokeWidth / (double)2;
        } else if (!bl) {
            d2 = this.radius;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.radiusWithStroke = d2;
        bl = this.drawInnerArc;
        if (bl) {
            d = this.holeRadius - this.strokeWidth / (double)2;
        } else if (!bl) {
            d = this.holeRadius;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.holeRadiusWithStroke = d;
        this.outerArcStart = this.outerArcPoint(this.startAngle);
        this.outerArcEnd = this.outerArcPoint(this.endAngle);
        this.innerArcStart = this.innerArcPoint(this.startAngle);
        this.innerArcEnd = this.innerArcPoint(this.endAngle);
    }

    public final int getIndex() {
        return this.index;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final double getHoleRadius() {
        return this.holeRadius;
    }

    public final double getStartAngle() {
        return this.startAngle;
    }

    public final double getEndAngle() {
        return this.endAngle;
    }

    @Nullable
    public final Color getFillColor() {
        return this.fillColor;
    }

    @Nullable
    public final Color getStrokeColor() {
        return this.strokeColor;
    }

    public final double getStrokeWidth() {
        return this.strokeWidth;
    }

    public final boolean getDrawInnerArc() {
        return this.drawInnerArc;
    }

    public final boolean getDrawOuterArc() {
        return this.drawOuterArc;
    }

    @Nullable
    public final Color getSpacerColor() {
        return this.spacerColor;
    }

    public final double getSpacerWidth() {
        return this.spacerWidth;
    }

    public final boolean getDrawSpacerAtStart() {
        return this.drawSpacerAtStart;
    }

    public final boolean getDrawSpacerAtEnd() {
        return this.drawSpacerAtEnd;
    }

    @NotNull
    public final DoubleVector getSectorCenter() {
        return this.sectorCenter;
    }

    public final double getRadiusWithStroke() {
        return this.radiusWithStroke;
    }

    public final double getHoleRadiusWithStroke() {
        return this.holeRadiusWithStroke;
    }

    @NotNull
    public final DoubleVector getOuterArcStart() {
        return this.outerArcStart;
    }

    @NotNull
    public final DoubleVector getOuterArcEnd() {
        return this.outerArcEnd;
    }

    @NotNull
    public final DoubleVector getInnerArcStart() {
        return this.innerArcStart;
    }

    @NotNull
    public final DoubleVector getInnerArcEnd() {
        return this.innerArcEnd;
    }

    private final DoubleVector outerArcPoint(double angle) {
        return this.arcPoint(this.radiusWithStroke, angle);
    }

    private final DoubleVector innerArcPoint(double angle) {
        return this.arcPoint(this.holeRadiusWithStroke, angle);
    }

    private final DoubleVector arcPoint(double radius, double angle) {
        return this.sectorCenter.add(new DoubleVector(radius * Math.cos(angle), radius * Math.sin(angle)));
    }
}

