/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.donut;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.livemap.chart.PieSpecComponent;
import org.jetbrains.letsPlot.livemap.chart.donut.Sector;
import org.jetbrains.letsPlot.livemap.chart.donut.StrokeSide;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"computeSectors", "", "Lorg/jetbrains/letsPlot/livemap/chart/donut/Sector;", "pieSpec", "Lorg/jetbrains/letsPlot/livemap/chart/PieSpecComponent;", "scaleFactor", "", "livemap"})
@SourceDebugExtension(value={"SMAP\nSector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sector.kt\norg/jetbrains/letsPlot/livemap/chart/donut/SectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1#2:139\n1#2:150\n1603#3,9:140\n1855#3:149\n1856#3:151\n1612#3:152\n1549#3:153\n1620#3,3:154\n*S KotlinDebug\n*F\n+ 1 Sector.kt\norg/jetbrains/letsPlot/livemap/chart/donut/SectorKt\n*L\n93#1:150\n93#1:140,9\n93#1:149\n93#1:151\n93#1:152\n111#1:153\n111#1:154,3\n*E\n"})
public final class SectorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Sector> computeSectors(@NotNull PieSpecComponent pieSpec, double scaleFactor) {
        void $this$mapTo$iv$iv;
        int element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Object object;
        double d;
        Intrinsics.checkNotNullParameter((Object)pieSpec, (String)"pieSpec");
        double sum = CollectionsKt.sumOfDouble((Iterable)pieSpec.getSliceValues());
        if (pieSpec.getStartAngle() != null) {
            Double d2 = pieSpec.getStartAngle();
            Intrinsics.checkNotNull((Object)d2);
            d = MathKt.toRadians((double)d2);
        } else {
            d = SectorKt.computeSectors$angle(sum, pieSpec, ((Number)CollectionsKt.first(pieSpec.getSliceValues())).doubleValue()) * (double)(pieSpec.getClockwise() ? -1 : 1);
        }
        double startAngle = d;
        double currentAngle = 0.0;
        currentAngle = -1.5707963267948966 + startAngle;
        double radius = pieSpec.getRadius() * scaleFactor;
        IntRange it = CollectionsKt.getIndices((Collection)pieSpec.getSliceValues());
        boolean bl = false;
        IntRange it2 = object = it;
        boolean bl2 = false;
        Object object2 = pieSpec.getClockwise() ? object : null;
        IntProgression pieIndices = object2 != null ? (IntProgression)object2 : RangesKt.reversed((IntProgression)((IntProgression)it));
        Iterable $this$mapNotNull$iv = (Iterable)pieIndices;
        boolean $i$f$mapNotNull = false;
        object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            int element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl3 = false;
            int index = element$iv$iv;
            boolean bl4 = false;
            List<Double> list = pieSpec.getExplodeValues();
            Double explode = list != null ? list.get(index) : null;
            Integer n = index;
            int it3 = ((Number)n).intValue();
            boolean bl5 = false;
            if ((explode != null && !Intrinsics.areEqual((Double)explode, (double)0.0) ? n : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List explodedSectors = (List)destination$iv$iv;
        StrokeSide strokeSide = pieSpec.getStrokeSide();
        boolean hasInnerArc = strokeSide != null ? strokeSide.getHasInner() : false;
        StrokeSide strokeSide2 = pieSpec.getStrokeSide();
        boolean hasOuterArc = strokeSide2 != null ? strokeSide2.getHasOuter() : false;
        Iterable $this$map$iv = (Iterable)pieIndices;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Sector sector;
            double d3;
            Double d4;
            void index;
            int item$iv$iv;
            element$iv$iv = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv2;
            boolean bl7 = false;
            Color strokeColor = (Color)CollectionsKt.getOrNull(pieSpec.getStrokeColors(), (int)index);
            Color fillColor = (Color)CollectionsKt.getOrNull(pieSpec.getFillColors(), (int)index);
            List<Double> explode = pieSpec.getStrokeWidths();
            if (index >= 0 && index <= CollectionsKt.getLastIndex(explode)) {
                d4 = explode.get((int)index);
            } else {
                void it4 = index;
                boolean bl8 = false;
                d4 = 0.0;
            }
            double strokeWidth = ((Number)d4).doubleValue();
            boolean hasVisibleStroke = strokeWidth > 0.0 && strokeColor != null && strokeColor.getAlpha() != 0;
            double holeRadius = radius * pieSpec.getHoleSize();
            int n = ((Number)pieSpec.getIndices().get((int)index)).intValue();
            double d5 = currentAngle;
            double d6 = currentAngle + SectorKt.computeSectors$angle(sum, pieSpec, ((Number)pieSpec.getSliceValues().get((int)index)).doubleValue());
            List<Double> list = pieSpec.getExplodeValues();
            if (list != null) {
                double it5 = ((Number)list.get((int)index)).doubleValue();
                boolean bl9 = false;
                d3 = radius * it5;
            } else {
                d3 = 0.0;
            }
            double d7 = d3;
            boolean bl10 = hasInnerArc && hasVisibleStroke && holeRadius > 0.0;
            boolean bl11 = hasOuterArc && hasVisibleStroke;
            Color color = pieSpec.getSpacerColor();
            double d8 = pieSpec.getSpacerWidth();
            boolean bl12 = SectorKt.computeSectors$needAddAtStart(explodedSectors, pieIndices, (int)index);
            boolean bl13 = SectorKt.computeSectors$needAddAtEnd(explodedSectors, pieIndices, (int)index);
            Sector sector2 = sector = new Sector(n, radius, holeRadius, d5, d6, fillColor, strokeColor, strokeWidth, bl10, bl11, color, d8, bl12, bl13, d7);
            boolean bl14 = false;
            currentAngle = sector2.getEndAngle();
            collection.add(sector);
        }
        return (List)destination$iv$iv2;
    }

    private static final double computeSectors$angle(double sum, PieSpecComponent $pieSpec, double slice) {
        double it = sum == 0.0 ? 1.0 / (double)$pieSpec.getSliceValues().size() : Math.abs(slice) / sum;
        boolean bl = false;
        return Math.PI * 2 * it;
    }

    private static final boolean computeSectors$needAddAtStart(List<Integer> explodedSectors, IntProgression pieIndices, int index) {
        int n = index;
        return explodedSectors.contains(n) ? false : (n == 0 ? !explodedSectors.contains(pieIndices.getLast()) : !explodedSectors.contains(index - 1));
    }

    private static final boolean computeSectors$needAddAtEnd(List<Integer> explodedSectors, IntProgression pieIndices, int index) {
        int n = index;
        return explodedSectors.contains(n) ? false : (n == pieIndices.getLast() ? !explodedSectors.contains(0) : !explodedSectors.contains(index + 1));
    }
}

