/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.fragment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.async.Asyncs;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.gis.geoprotocol.Fragment;
import org.jetbrains.letsPlot.gis.geoprotocol.GeoRequest;
import org.jetbrains.letsPlot.gis.geoprotocol.GeoRequestBuilder;
import org.jetbrains.letsPlot.gis.geoprotocol.GeoResponse;
import org.jetbrains.letsPlot.gis.geoprotocol.GeocodingService;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentProvider;
import org.jetbrains.letsPlot.livemap.containers.LruCache;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0013B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J<\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\n2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0002JB\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b0\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\n2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider;", "", "fragmentCache", "Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider$FragmentCache;", "geocodingService", "Lorg/jetbrains/letsPlot/gis/geoprotocol/GeocodingService;", "(Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider$FragmentCache;Lorg/jetbrains/letsPlot/gis/geoprotocol/GeocodingService;)V", "getCachedGeometries", "", "", "", "Lorg/jetbrains/letsPlot/gis/geoprotocol/Fragment;", "mapObjectIds", "quads", "", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "getFragments", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "FragmentCache", "livemap"})
@SourceDebugExtension(value={"SMAP\nFragmentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FragmentProvider.kt\norg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1855#2:137\n1855#2:138\n1856#2:140\n1856#2:141\n1#3:139\n*S KotlinDebug\n*F\n+ 1 FragmentProvider.kt\norg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider\n*L\n91#1:137\n93#1:138\n93#1:140\n91#1:141\n*E\n"})
public class FragmentProvider {
    @NotNull
    private final FragmentCache fragmentCache;
    @NotNull
    private final GeocodingService geocodingService;

    public FragmentProvider(@NotNull FragmentCache fragmentCache, @NotNull GeocodingService geocodingService) {
        Intrinsics.checkNotNullParameter((Object)fragmentCache, (String)"fragmentCache");
        Intrinsics.checkNotNullParameter((Object)geocodingService, (String)"geocodingService");
        this.fragmentCache = fragmentCache;
        this.geocodingService = geocodingService;
    }

    @NotNull
    public Async<Map<String, List<Fragment>>> getFragments(@NotNull List<String> mapObjectIds, @NotNull Collection<QuadKey<LonLat>> quads) {
        Intrinsics.checkNotNullParameter(mapObjectIds, (String)"mapObjectIds");
        Intrinsics.checkNotNullParameter(quads, (String)"quads");
        HashMap objectsWithMissingFragments = new HashMap();
        boolean isMissing = false;
        for (String mapObjectId : mapObjectIds) {
            ArrayList<QuadKey<LonLat>> missingFragments = new ArrayList<QuadKey<LonLat>>();
            for (QuadKey<LonLat> quadKey : quads) {
                if (this.fragmentCache.contains(mapObjectId, quadKey)) continue;
                missingFragments.add(quadKey);
                isMissing = true;
            }
            if (missingFragments.isEmpty()) continue;
            ((Map)objectsWithMissingFragments).put(mapObjectId, missingFragments);
        }
        if (!isMissing) {
            return Asyncs.INSTANCE.constant(this.getCachedGeometries(mapObjectIds, quads));
        }
        GeoRequest.ExplicitSearchRequest request = ((GeoRequestBuilder.ExplicitRequestBuilder)((GeoRequestBuilder.ExplicitRequestBuilder)new GeoRequestBuilder.ExplicitRequestBuilder().setIds(mapObjectIds).addFeature(GeoRequest.FeatureOption.FRAGMENTS)).setFragments((Map)objectsWithMissingFragments)).build();
        return this.geocodingService.execute((GeoRequest)request).map((Function1)new Function1<List<? extends GeoResponse.SuccessGeoResponse.GeocodedFeature>, Map<String, ? extends List<? extends Fragment>>>(quads, this, mapObjectIds){
            final /* synthetic */ Collection<QuadKey<LonLat>> $quads;
            final /* synthetic */ FragmentProvider this$0;
            final /* synthetic */ List<String> $mapObjectIds;
            {
                this.$quads = $quads;
                this.this$0 = $receiver;
                this.$mapObjectIds = $mapObjectIds;
                super(1);
            }

            @NotNull
            public final Map<String, List<Fragment>> invoke(@NotNull List<GeoResponse.SuccessGeoResponse.GeocodedFeature> features) {
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter(features, (String)"features");
                Iterable iterable = this.$quads;
                Object object = this.$mapObjectIds;
                FragmentProvider fragmentProvider = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    QuadKey quadKey = (QuadKey)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = (Iterable)object;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String mapObjectId = (String)element$iv2;
                        boolean bl2 = false;
                        if (FragmentProvider.access$getFragmentCache$p(fragmentProvider).contains(mapObjectId, (QuadKey<LonLat>)quadKey)) continue;
                        FragmentProvider.access$getFragmentCache$p(fragmentProvider).putEmpty(mapObjectId, (QuadKey<LonLat>)quadKey);
                    }
                }
                $this$forEach$iv = features;
                object = this.this$0;
                boolean $i$f$forEach3 = false;
                for (T element$iv : $this$forEach$iv) {
                    GeoResponse.SuccessGeoResponse.GeocodedFeature geocodedFeature = (GeoResponse.SuccessGeoResponse.GeocodedFeature)element$iv;
                    boolean bl = false;
                    List list = geocodedFeature.getFragments();
                    if (list == null) continue;
                    Iterable $this$forEach$iv3 = list;
                    boolean $i$f$forEach4 = false;
                    for (T element$iv3 : $this$forEach$iv3) {
                        Fragment it = (Fragment)element$iv3;
                        boolean bl3 = false;
                        FragmentProvider.access$getFragmentCache$p((FragmentProvider)object).put(geocodedFeature.getId(), (QuadKey<LonLat>)it.getKey(), it);
                    }
                }
                return FragmentProvider.access$getCachedGeometries(this.this$0, this.$mapObjectIds, this.$quads);
            }
        });
    }

    private final Map<String, List<Fragment>> getCachedGeometries(List<String> mapObjectIds, Collection<QuadKey<LonLat>> quads) {
        HashMap result = new HashMap();
        Iterable $this$forEach$iv = mapObjectIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String mapObjectId = (String)element$iv;
            boolean bl = false;
            ArrayList<Fragment> fragments = new ArrayList<Fragment>();
            Iterable $this$forEach$iv2 = quads;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Fragment p0;
                QuadKey quadKey = (QuadKey)element$iv2;
                boolean bl2 = false;
                if (this.fragmentCache.get(mapObjectId, (QuadKey<LonLat>)quadKey) == null) continue;
                boolean bl3 = false;
                fragments.add(p0);
            }
            ((Map)result).put(mapObjectId, fragments);
        }
        return result;
    }

    public static final /* synthetic */ Map access$getCachedGeometries(FragmentProvider $this, List mapObjectIds, Collection quads) {
        return $this.getCachedGeometries(mapObjectIds, quads);
    }

    public static final /* synthetic */ FragmentCache access$getFragmentCache$p(FragmentProvider $this) {
        return $this.fragmentCache;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J!\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086\u0002J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bJ\u001c\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R.\u0010\u0005\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider$FragmentCache;", "", "mapSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "cache", "Lorg/jetbrains/letsPlot/livemap/containers/LruCache;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "", "", "Lorg/jetbrains/letsPlot/gis/geoprotocol/Fragment;", "limit", "", "contains", "", "mapObjectId", "quadKey", "get", "put", "", "fragment", "putEmpty", "Companion", "livemap"})
    public static final class FragmentCache {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int limit;
        @NotNull
        private final LruCache<QuadKey<LonLat>, Map<String, Fragment>> cache;
        private static final int CACHED_ZOOM_COUNT = 3;
        private static final int CACHED_VIEW_COUNT = 2;

        public FragmentCache(@NotNull DoubleVector mapSize) {
            Intrinsics.checkNotNullParameter((Object)mapSize, (String)"mapSize");
            this.limit = 3 * FragmentCache.Companion.calculateCachedSideTileCount(mapSize.getX()) * FragmentCache.Companion.calculateCachedSideTileCount(mapSize.getY());
            this.cache = new LruCache(this.limit);
        }

        public final boolean contains(@NotNull String mapObjectId, @NotNull QuadKey<LonLat> quadKey) {
            Intrinsics.checkNotNullParameter((Object)mapObjectId, (String)"mapObjectId");
            Intrinsics.checkNotNullParameter(quadKey, (String)"quadKey");
            Map<String, Fragment> map2 = this.cache.get(quadKey);
            return map2 != null ? map2.containsKey(mapObjectId) : false;
        }

        @Nullable
        public final Fragment get(@NotNull String mapObjectId, @NotNull QuadKey<LonLat> quadKey) {
            Intrinsics.checkNotNullParameter((Object)mapObjectId, (String)"mapObjectId");
            Intrinsics.checkNotNullParameter(quadKey, (String)"quadKey");
            Map<String, Fragment> map2 = this.cache.get(quadKey);
            return map2 != null ? map2.get(mapObjectId) : null;
        }

        public final void putEmpty(@NotNull String mapObjectId, @NotNull QuadKey<LonLat> quadKey) {
            Intrinsics.checkNotNullParameter((Object)mapObjectId, (String)"mapObjectId");
            Intrinsics.checkNotNullParameter(quadKey, (String)"quadKey");
            this.put(mapObjectId, quadKey, null);
        }

        public final void put(@NotNull String mapObjectId, @NotNull QuadKey<LonLat> quadKey, @Nullable Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)mapObjectId, (String)"mapObjectId");
            Intrinsics.checkNotNullParameter(quadKey, (String)"quadKey");
            this.cache.getOrPut(quadKey, (Function0<Map<String, Fragment>>)((Function0)put.1.INSTANCE)).put(mapObjectId, fragment);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentProvider$FragmentCache$Companion;", "", "()V", "CACHED_VIEW_COUNT", "", "CACHED_ZOOM_COUNT", "calculateCachedSideTileCount", "sideLength", "", "livemap"})
        public static final class Companion {
            private Companion() {
            }

            private final int calculateCachedSideTileCount(double sideLength) {
                return (int)((double)2 * sideLength / 256.0 + 1.0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

