/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.fragment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoRectangle;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKeyKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.livemap.chart.fragment.ChangedFragmentsComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.EmptyFragmentsComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.ExistingRegionsComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentKey;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentUpdateSystem;
import org.jetbrains.letsPlot.livemap.chart.fragment.RegionBBoxComponent;
import org.jetbrains.letsPlot.livemap.chart.fragment.RegionFragmentsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntityKt;
import org.jetbrains.letsPlot.livemap.geocoding.RegionIdComponent;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.ViewportGridStateComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentUpdateSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "initImpl", "", "context", "updateImpl", "dt", "", "intersect", "", "Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle;", "quadKey", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "Companion", "livemap"})
@SourceDebugExtension(value={"SMAP\nFragmentUpdateSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FragmentUpdateSystem.kt\norg/jetbrains/letsPlot/livemap/chart/fragment/FragmentUpdateSystem\n+ 2 AbstractSystem.kt\norg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem\n+ 3 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 4 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n70#2:92\n70#2:97\n70#2:102\n70#2:107\n141#3:93\n141#3:98\n141#3:103\n141#3:108\n68#4:94\n24#4,2:95\n68#4:99\n24#4,2:100\n68#4:104\n24#4,2:105\n68#4:109\n24#4,2:110\n24#4,2:112\n24#4,2:114\n1855#5,2:116\n*S KotlinDebug\n*F\n+ 1 FragmentUpdateSystem.kt\norg/jetbrains/letsPlot/livemap/chart/fragment/FragmentUpdateSystem\n*L\n34#1:92\n35#1:97\n36#1:102\n37#1:107\n34#1:93\n35#1:98\n36#1:103\n37#1:108\n34#1:94\n34#1:95,2\n35#1:99\n35#1:100,2\n36#1:104\n36#1:105,2\n37#1:109\n37#1:110,2\n45#1:112,2\n46#1:114,2\n75#1:116,2\n*E\n"})
public final class FragmentUpdateSystem
extends AbstractSystem<LiveMapContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<KClass<? extends EcsComponent>> REGION_ENTITY_COMPONENTS;

    public FragmentUpdateSystem(@NotNull EcsComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(componentManager);
    }

    @Override
    protected void initImpl(@NotNull LiveMapContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EcsEntityKt.addComponents(this.createEntity("FragmentsChange"), (Function1<? super ComponentsList, Unit>)((Function1)initImpl.1.INSTANCE));
    }

    @Override
    protected void updateImpl(@NotNull LiveMapContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AbstractSystem this_$iv = this;
        boolean $i$f$getSingleton = false;
        EcsComponentManager this_$iv$iv = this_$iv.getComponentManager();
        boolean $i$f$getSingleton2 = false;
        EcsEntity this_$iv$iv$iv = this_$iv$iv.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(ViewportGridStateComponent.class));
        boolean $i$f$getComponent = false;
        EcsEntity this_$iv$iv$iv$iv = this_$iv$iv$iv;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (ViewportGridStateComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(ViewportGridStateComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ViewportGridStateComponent.class).getSimpleName() + " is not found");
        }
        ViewportGridStateComponent viewportGridState = (ViewportGridStateComponent)ecsComponent;
        AbstractSystem this_$iv2 = this;
        boolean $i$f$getSingleton3 = false;
        EcsComponentManager this_$iv$iv2 = this_$iv2.getComponentManager();
        boolean $i$f$getSingleton4 = false;
        EcsEntity this_$iv$iv$iv2 = this_$iv$iv2.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(ChangedFragmentsComponent.class));
        boolean $i$f$getComponent2 = false;
        EcsEntity this_$iv$iv$iv$iv2 = this_$iv$iv$iv2;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (ChangedFragmentsComponent)this_$iv$iv$iv$iv2.getComponentManager().getComponents(this_$iv$iv$iv$iv2).get(Reflection.getOrCreateKotlinClass(ChangedFragmentsComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChangedFragmentsComponent.class).getSimpleName() + " is not found");
        }
        ChangedFragmentsComponent changedFragmentsComponent = (ChangedFragmentsComponent)ecsComponent2;
        AbstractSystem this_$iv3 = this;
        $i$f$getSingleton = false;
        EcsComponentManager this_$iv$iv3 = this_$iv3.getComponentManager();
        boolean $i$f$getSingleton5 = false;
        EcsEntity this_$iv$iv$iv3 = this_$iv$iv3.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(EmptyFragmentsComponent.class));
        boolean $i$f$getComponent3 = false;
        EcsEntity this_$iv$iv$iv$iv3 = this_$iv$iv$iv3;
        boolean $i$f$get3 = false;
        EcsComponent ecsComponent3 = (EmptyFragmentsComponent)this_$iv$iv$iv$iv3.getComponentManager().getComponents(this_$iv$iv$iv$iv3).get(Reflection.getOrCreateKotlinClass(EmptyFragmentsComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(EmptyFragmentsComponent.class).getSimpleName() + " is not found");
        }
        EmptyFragmentsComponent emptyFragments = (EmptyFragmentsComponent)ecsComponent3;
        AbstractSystem this_$iv4 = this;
        $i$f$getSingleton = false;
        EcsComponentManager this_$iv$iv4 = this_$iv4.getComponentManager();
        boolean $i$f$getSingleton6 = false;
        EcsEntity this_$iv$iv$iv4 = this_$iv$iv4.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(ExistingRegionsComponent.class));
        boolean $i$f$getComponent4 = false;
        EcsEntity this_$iv$iv$iv$iv4 = this_$iv$iv$iv4;
        boolean $i$f$get4 = false;
        EcsComponent ecsComponent4 = (ExistingRegionsComponent)this_$iv$iv$iv$iv4.getComponentManager().getComponents(this_$iv$iv$iv$iv4).get(Reflection.getOrCreateKotlinClass(ExistingRegionsComponent.class));
        if (ecsComponent4 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ExistingRegionsComponent.class).getSimpleName() + " is not found");
        }
        HashSet<String> existingRegions = ((ExistingRegionsComponent)ecsComponent4).getExistingRegions();
        Set<QuadKey<LonLat>> quadsToRemove = viewportGridState.getQuadsToRemove();
        ArrayList<FragmentKey> fragmentsToAdd = new ArrayList<FragmentKey>();
        ArrayList<FragmentKey> fragmentsToRemove = new ArrayList<FragmentKey>();
        Iterator iterator = this.getEntities(REGION_ENTITY_COMPONENTS).iterator();
        while (iterator.hasNext()) {
            EcsEntity regionEntity;
            EcsEntity this_$iv5 = regionEntity = (EcsEntity)iterator.next();
            $i$f$get4 = false;
            EcsComponent ecsComponent5 = (RegionBBoxComponent)this_$iv5.getComponentManager().getComponents(this_$iv5).get(Reflection.getOrCreateKotlinClass(RegionBBoxComponent.class));
            if (ecsComponent5 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(RegionBBoxComponent.class).getSimpleName() + " is not found");
            }
            GeoRectangle bbox = ((RegionBBoxComponent)ecsComponent5).getBbox();
            EcsEntity this_$iv6 = regionEntity;
            boolean $i$f$get5 = false;
            EcsComponent ecsComponent6 = (RegionIdComponent)this_$iv6.getComponentManager().getComponents(this_$iv6).get(Reflection.getOrCreateKotlinClass(RegionIdComponent.class));
            if (ecsComponent6 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(RegionIdComponent.class).getSimpleName() + " is not found");
            }
            String regionId = ((RegionIdComponent)ecsComponent6).getRegionId();
            Set<QuadKey<LonLat>> quadsToAdd = viewportGridState.getQuadsToLoad();
            if (!existingRegions.contains(regionId)) {
                quadsToAdd = viewportGridState.getVisibleQuads();
                existingRegions.add(regionId);
            }
            for (QuadKey<LonLat> quad : quadsToAdd) {
                if (emptyFragments.contains$livemap(regionId, quad) || !this.intersect(bbox, quad)) continue;
                fragmentsToAdd.add(new FragmentKey(regionId, quad));
            }
            for (QuadKey<LonLat> quad : quadsToRemove) {
                if (emptyFragments.contains$livemap(regionId, quad)) continue;
                fragmentsToRemove.add(new FragmentKey(regionId, quad));
            }
        }
        changedFragmentsComponent.setToAdd((Collection<FragmentKey>)fragmentsToAdd);
        changedFragmentsComponent.setToRemove((Collection<FragmentKey>)fragmentsToRemove);
    }

    private final boolean intersect(GeoRectangle $this$intersect, QuadKey<LonLat> quadKey) {
        Rect quadKeyRect = QuadKeyKt.computeRect(quadKey);
        Iterable $this$forEach$iv = $this$intersect.splitByAntiMeridian();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rect bbox = (Rect)element$iv;
            boolean bl = false;
            if (!RectKt.intersects((Rect)bbox, (Rect)quadKeyRect)) continue;
            return true;
        }
        return false;
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(RegionIdComponent.class), Reflection.getOrCreateKotlinClass(RegionBBoxComponent.class), Reflection.getOrCreateKotlinClass(RegionFragmentsComponent.class)};
        REGION_ENTITY_COMPONENTS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentUpdateSystem$Companion;", "", "()V", "REGION_ENTITY_COMPONENTS", "", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponent;", "getREGION_ENTITY_COMPONENTS", "()Ljava/util/List;", "livemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<? extends EcsComponent>> getREGION_ENTITY_COMPONENTS() {
            return REGION_ENTITY_COMPONENTS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

