/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.fragment;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.livemap.chart.fragment.FragmentKey;
import org.jetbrains.letsPlot.livemap.containers.LruCache;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.geocoding.RegionIdComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/Utils;", "", "()V", "entityName", "", "regionId", "quadKey", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "fragmentKey", "Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentKey;", "RegionsIndex", "SetBuilder", "livemap"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @NotNull
    public final String entityName(@NotNull FragmentKey fragmentKey) {
        Intrinsics.checkNotNullParameter((Object)fragmentKey, (String)"fragmentKey");
        return this.entityName(fragmentKey.getRegionId(), fragmentKey.getQuadKey());
    }

    @NotNull
    public final String entityName(@NotNull String regionId, @NotNull QuadKey<LonLat> quadKey) {
        Intrinsics.checkNotNullParameter((Object)regionId, (String)"regionId");
        Intrinsics.checkNotNullParameter(quadKey, (String)"quadKey");
        return "fragment_" + regionId + '_' + quadKey.getKey();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/Utils$RegionsIndex;", "", "myComponentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "myRegionIndex", "Lorg/jetbrains/letsPlot/livemap/containers/LruCache;", "", "", "find", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "regionId", "livemap"})
    @SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/letsPlot/livemap/chart/fragment/Utils$RegionsIndex\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,62:1\n24#2,2:63\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/letsPlot/livemap/chart/fragment/Utils$RegionsIndex\n*L\n33#1:63,2\n*E\n"})
    public static final class RegionsIndex {
        @NotNull
        private final EcsComponentManager myComponentManager;
        @NotNull
        private final LruCache<String, Integer> myRegionIndex;

        public RegionsIndex(@NotNull EcsComponentManager myComponentManager) {
            Intrinsics.checkNotNullParameter((Object)myComponentManager, (String)"myComponentManager");
            this.myComponentManager = myComponentManager;
            this.myRegionIndex = new LruCache(10000);
        }

        @NotNull
        public final EcsEntity find(@NotNull String regionId) {
            Intrinsics.checkNotNullParameter((Object)regionId, (String)"regionId");
            if (this.myRegionIndex.containsKey(regionId)) {
                Integer n = this.myRegionIndex.get(regionId);
                if (n == null) {
                    throw new IllegalStateException("".toString());
                }
                return this.myComponentManager.getEntityById(n);
            }
            Iterator iterator = this.myComponentManager.getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(RegionIdComponent.class)).iterator();
            while (iterator.hasNext()) {
                EcsEntity entity2;
                EcsEntity this_$iv = entity2 = (EcsEntity)iterator.next();
                boolean $i$f$get = false;
                EcsComponent ecsComponent = (RegionIdComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(RegionIdComponent.class));
                if (ecsComponent == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(RegionIdComponent.class).getSimpleName() + " is not found");
                }
                if (!Intrinsics.areEqual((Object)((RegionIdComponent)ecsComponent).getRegionId(), (Object)regionId)) continue;
                this.myRegionIndex.put(regionId, entity2.getId$livemap());
                return entity2;
            }
            throw new IllegalStateException("".toString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u0000 \n*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\nB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/Utils$SetBuilder;", "T", "", "myValues", "", "(Ljava/util/Set;)V", "exclude", "v", "", "get", "Companion", "livemap"})
    public static final class SetBuilder<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<T> myValues;

        public SetBuilder(@NotNull Set<T> myValues) {
            Intrinsics.checkNotNullParameter(myValues, (String)"myValues");
            this.myValues = myValues;
        }

        @NotNull
        public final SetBuilder<T> exclude(@NotNull Set<? extends T> v) {
            Intrinsics.checkNotNullParameter(v, (String)"v");
            this.myValues.removeAll((Collection)v);
            return this;
        }

        @NotNull
        public final Set<T> get() {
            return this.myValues;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/fragment/Utils$SetBuilder$Companion;", "", "()V", "ofCopy", "Lorg/jetbrains/letsPlot/livemap/chart/fragment/Utils$SetBuilder;", "Lorg/jetbrains/letsPlot/livemap/chart/fragment/FragmentKey;", "requested", "", "livemap"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SetBuilder<FragmentKey> ofCopy(@NotNull Set<FragmentKey> requested) {
                Intrinsics.checkNotNullParameter(requested, (String)"requested");
                return new SetBuilder<FragmentKey>(new HashSet(requested));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

