/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.path;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.FunctionsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.util.ClosestPointChecker;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.chart.HoverObject;
import org.jetbrains.letsPlot.livemap.chart.HoverObjectKind;
import org.jetbrains.letsPlot.livemap.chart.IndexComponent;
import org.jetbrains.letsPlot.livemap.chart.Locator;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.geometry.WorldGeometryComponent;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J(\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J4\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/path/PathLocator;", "Lorg/jetbrains/letsPlot/livemap/chart/Locator;", "()V", "isOnSegment", "", "TypeT", "p", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "l1", "l2", "reduce", "Lorg/jetbrains/letsPlot/livemap/chart/HoverObject;", "hoverObjects", "", "search", "coord", "Lorg/jetbrains/letsPlot/livemap/Client;", "target", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "tooltipPosition", "Lorg/jetbrains/letsPlot/livemap/World;", "multiLineString", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiLineString;", "pointChecker", "Lorg/jetbrains/letsPlot/commons/intern/util/ClosestPointChecker;", "livemap"})
@SourceDebugExtension(value={"SMAP\nPathLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathLocator.kt\norg/jetbrains/letsPlot/livemap/chart/path/PathLocator\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,81:1\n24#2,2:82\n24#2,2:84\n24#2,2:86\n2333#3,14:88\n1313#4,2:102\n*S KotlinDebug\n*F\n+ 1 PathLocator.kt\norg/jetbrains/letsPlot/livemap/chart/path/PathLocator\n*L\n34#1:82,2\n40#1:84,2\n41#1:86,2\n51#1:88,14\n60#1:102,2\n*E\n"})
public final class PathLocator
implements Locator {
    @NotNull
    public static final PathLocator INSTANCE = new PathLocator();

    private PathLocator() {
    }

    @Override
    @Nullable
    public HoverObject search(@NotNull Vec<? extends Client> coord, @NotNull EcsEntity target, @NotNull RenderHelper renderHelper) {
        Intrinsics.checkNotNullParameter(coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        if (!target.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class))) {
            return null;
        }
        Vec<World> cursorCoord = renderHelper.posToWorld(coord);
        ClosestPointChecker pointChecker = new ClosestPointChecker(cursorCoord.getX(), cursorCoord.getY());
        EcsEntity this_$iv = target;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (WorldGeometryComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class).getSimpleName() + " is not found");
        }
        Vec<World> candidate = this.tooltipPosition(cursorCoord, (MultiLineString<World>)((WorldGeometryComponent)ecsComponent).getGeometry().getMultiLineString(), pointChecker);
        if (candidate != null) {
            this_$iv = target;
            $i$f$get = false;
            EcsComponent ecsComponent2 = (IndexComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
            }
            this_$iv = target;
            $i$f$get = false;
            EcsComponent ecsComponent3 = (IndexComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
            if (ecsComponent3 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
            }
            return new HoverObject(HoverObjectKind.PATH, ((IndexComponent)ecsComponent2).getLayerIndex(), ((IndexComponent)ecsComponent3).getIndex(), renderHelper.dimToClient-VvMBhYE(pointChecker.getDistance()), this, FunctionsKt.toDoubleVector(renderHelper.worldToPos(candidate)), null, 64, null);
        }
        return null;
    }

    @Override
    @Nullable
    public HoverObject reduce(@NotNull Collection<HoverObject> hoverObjects) {
        Object v0;
        Intrinsics.checkNotNullParameter(hoverObjects, (String)"hoverObjects");
        Iterable $this$minByOrNull$iv = hoverObjects;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                HoverObject p0 = (HoverObject)minElem$iv;
                boolean bl = false;
                double minValue$iv = p0.getDistance();
                do {
                    Object e$iv = iterator$iv.next();
                    HoverObject p02 = (HoverObject)e$iv;
                    $i$a$-minByOrNull-PathLocator$reduce$1 = false;
                    double v$iv = p02.getDistance();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private final Vec<World> tooltipPosition(Vec<? extends World> coord, MultiLineString<World> multiLineString, ClosestPointChecker pointChecker) {
        Vec candidate = null;
        for (LineString lineString : multiLineString) {
            Sequence $this$forEach$iv = SequencesKt.windowed$default((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.toList((Iterable)((Iterable)lineString))), (int)2, (int)0, (boolean)false, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vec p2;
                List it = (List)element$iv;
                boolean bl = false;
                Vec p1 = (Vec)it.get(0);
                if (INSTANCE.isOnSegment(coord, p1, p2 = (Vec)it.get(1))) {
                    DoubleVector targetPointCoord = MathKt.projection((double)coord.getX(), (double)coord.getY(), (double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
                    if (!ClosestPointChecker.check$default((ClosestPointChecker)pointChecker, (DoubleVector)targetPointCoord, (double)0.0, (int)2, null)) continue;
                    candidate = FunctionsKt.toVec((DoubleVector)targetPointCoord);
                    continue;
                }
                if (!ClosestPointChecker.check$default((ClosestPointChecker)pointChecker, (DoubleVector)FunctionsKt.toDoubleVector((Vec)p1), (double)0.0, (int)2, null)) continue;
                candidate = p1;
            }
        }
        return candidate;
    }

    private final <TypeT> boolean isOnSegment(Vec<? extends TypeT> p, Vec<? extends TypeT> l1, Vec<? extends TypeT> l2) {
        return MathKt.isOnSegment((double)p.getX(), (double)p.getY(), (double)l1.getX(), (double)l1.getY(), (double)l2.getX(), (double)l2.getY());
    }
}

