/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.path;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Scalar;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.ScalarKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.util.ArrowSupport;
import org.jetbrains.letsPlot.commons.intern.util.VecUtil;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.path.ArrowSpec;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.geometry.WorldGeometryComponent;
import org.jetbrains.letsPlot.livemap.mapengine.Context2dExKt;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.Renderer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jn\u0010\u0003\u001a&\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u00042\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0014\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\u00130\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J<\u0010\u0019\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/path/PathRenderer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/Renderer;", "()V", "createArrows", "Lkotlin/Pair;", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/World;", "startSegment", "endSegment", "arrowSpec", "Lorg/jetbrains/letsPlot/livemap/chart/path/ArrowSpec;", "scalingSizeFactor", "", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "drawPath", "", "points", "Lorg/jetbrains/letsPlot/livemap/WorldPoint;", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "render", "entity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "renderArrowHead", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "livemap"})
@SourceDebugExtension(value={"SMAP\nPathRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathRenderer.kt\norg/jetbrains/letsPlot/livemap/chart/path/PathRenderer\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,152:1\n24#2,2:153\n24#2,2:155\n1855#3,2:157\n1#4:159\n1313#5,2:160\n1313#5,2:162\n*S KotlinDebug\n*F\n+ 1 PathRenderer.kt\norg/jetbrains/letsPlot/livemap/chart/path/PathRenderer\n*L\n33#1:153,2\n44#1:155,2\n55#1:157,2\n135#1:160,2\n149#1:162,2\n*E\n"})
public class PathRenderer
implements Renderer {
    @Override
    public void render(@NotNull EcsEntity entity2, @NotNull Context2d ctx, @NotNull RenderHelper renderHelper) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        EcsEntity this_$iv = entity2;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (ChartElementComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
        }
        ChartElementComponent chartElement = (ChartElementComponent)ecsComponent;
        Color color = chartElement.scaledStrokeColor();
        ctx.setStrokeStyle(color);
        ctx.setLineDash(chartElement.scaledLineDash());
        ctx.setLineDashOffset(chartElement.scaledLineDashOffset());
        ctx.setLineWidth(chartElement.scaledStrokeWidth());
        double startPadding = renderHelper.dimToWorld-nwvo2uo(chartElement.scaledStartPadding-b9qgYVc());
        double endPadding = renderHelper.dimToWorld-nwvo2uo(chartElement.scaledEndPadding-b9qgYVc());
        EcsEntity this_$iv2 = entity2;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (WorldGeometryComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class).getSimpleName() + " is not found");
        }
        MultiLineString geometry = ((WorldGeometryComponent)ecsComponent2).getGeometry().getMultiLineString();
        switch (geometry.size()) {
            case 0: {
                return;
            }
            case 1: {
                pair = TuplesKt.to((Object)VecUtil.INSTANCE.padLineString-EJp4Vog((List)geometry.get(0), startPadding, endPadding), null);
                break;
            }
            default: {
                pair = TuplesKt.to((Object)VecUtil.INSTANCE.padLineString-EJp4Vog((List)geometry.get(0), startPadding, Scalar.Companion.getZERO-b9qgYVc()), (Object)VecUtil.INSTANCE.padLineString-EJp4Vog((List)CollectionsKt.last((List)((List)geometry)), Scalar.Companion.getZERO-b9qgYVc(), endPadding));
            }
        }
        Pair pair2 = pair;
        List startSegment = (List)pair2.component1();
        List endSegment = (List)pair2.component2();
        ctx.save();
        ctx.scale(renderHelper.getZoomFactor());
        ctx.beginPath();
        this.drawPath(startSegment, ctx);
        Iterable $this$forEach$iv = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)((Iterable)geometry), (int)1), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LineString it = (LineString)element$iv;
            boolean bl = false;
            this.drawPath((List)it, ctx);
        }
        List list = endSegment;
        if (list != null) {
            List it = list;
            boolean bl = false;
            this.drawPath(it, ctx);
        }
        ctx.restore();
        ctx.stroke();
        ArrowSpec arrowSpec = chartElement.getArrowSpec();
        if (arrowSpec == null) {
            return;
        }
        ArrowSpec arrowSpec2 = arrowSpec;
        Pair<List<Vec<World>>, List<Vec<World>>> arrows = this.createArrows(startSegment, endSegment, arrowSpec2, chartElement.getScalingSizeFactor(), renderHelper);
        double miterLimit = ArrowSupport.INSTANCE.miterLength(arrowSpec2.getAngle(), chartElement.scaledStrokeWidth()) * (double)2;
        ctx.setStrokeMiterLimit(Math.abs(miterLimit));
        this.renderArrowHead((List)arrows.getFirst(), arrowSpec2, color, ctx, renderHelper);
        this.renderArrowHead((List)arrows.getSecond(), arrowSpec2, color, ctx, renderHelper);
    }

    private final Pair<List<Vec<World>>, List<Vec<World>>> createArrows(List<? extends Vec<? extends World>> startSegment, List<? extends Vec<? extends World>> endSegment, ArrowSpec arrowSpec, double scalingSizeFactor, RenderHelper renderHelper) {
        double arrowLength = renderHelper.dimToWorld-nwvo2uo(ScalarKt.times-ZDqpIUE((double)arrowSpec.getLength-b9qgYVc(), (Number)scalingSizeFactor));
        double minTailLength = renderHelper.dimToWorld-nwvo2uo(Client.Companion.getPx-VvMBhYE(10.0));
        double minHeadLength = renderHelper.dimToWorld-nwvo2uo(Client.Companion.getPx-VvMBhYE(5.0));
        if (endSegment == null) {
            return VecUtil.INSTANCE.createArrowHeadGeometry-ycbs7hU(startSegment, arrowSpec.getAngle(), arrowLength, arrowSpec.isOnFirstEnd(), arrowSpec.isOnLastEnd(), arrowSpec.getType() == ArrowSpec.Type.CLOSED, minTailLength, minHeadLength);
        }
        List startHead = (List)VecUtil.INSTANCE.createArrowHeadGeometry-ycbs7hU(startSegment, arrowSpec.getAngle(), arrowLength, arrowSpec.isOnFirstEnd(), false, arrowSpec.getType() == ArrowSpec.Type.CLOSED, minTailLength, minHeadLength).component1();
        List endHead = (List)VecUtil.INSTANCE.createArrowHeadGeometry-ycbs7hU(endSegment, arrowSpec.getAngle(), arrowLength, false, arrowSpec.isOnLastEnd(), arrowSpec.getType() == ArrowSpec.Type.CLOSED, minTailLength, minHeadLength).component2();
        return TuplesKt.to((Object)startHead, (Object)endHead);
    }

    private final void renderArrowHead(List<? extends Vec<? extends World>> points2, ArrowSpec arrowSpec, Color color, Context2d ctx, RenderHelper renderHelper) {
        if (points2.size() < 2) {
            return;
        }
        ctx.save();
        ctx.scale(renderHelper.getZoomFactor());
        ctx.beginPath();
        Context2dExKt.moveTo(ctx, points2.get(0));
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)points2), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vec p0 = (Vec)element$iv;
            boolean bl = false;
            Context2dExKt.lineTo(ctx, p0);
        }
        ctx.restore();
        ctx.setLineDash(new double[0]);
        if (arrowSpec.getType() == ArrowSpec.Type.CLOSED) {
            ctx.closePath();
            ctx.setFillStyle(color);
            ctx.fill();
        }
        ctx.stroke();
    }

    public void drawPath(@NotNull List<? extends Vec<? extends World>> points2, @NotNull Context2d ctx) {
        Intrinsics.checkNotNullParameter(points2, (String)"points");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Vec<? extends World> p0 = points2.get(0);
        boolean bl = false;
        Context2dExKt.moveTo(ctx, p0);
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)points2), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vec p02 = (Vec)element$iv;
            boolean bl2 = false;
            Context2dExKt.lineTo(ctx, p02);
        }
    }
}

