/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.point;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.FunctionsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Scalar;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.ScalarKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.HoverObject;
import org.jetbrains.letsPlot.livemap.chart.HoverObjectKind;
import org.jetbrains.letsPlot.livemap.chart.IndexComponent;
import org.jetbrains.letsPlot.livemap.chart.Locator;
import org.jetbrains.letsPlot.livemap.chart.PointComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J(\u0010\u000f\u001a\u0004\u0018\u00010\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/point/PointLocator;", "Lorg/jetbrains/letsPlot/livemap/chart/Locator;", "()V", "EXTRA_RADIUS", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Scalar;", "Lorg/jetbrains/letsPlot/livemap/Client;", "D", "REQUIRED_COMPONENTS", "", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponent;", "reduce", "Lorg/jetbrains/letsPlot/livemap/chart/HoverObject;", "hoverObjects", "", "search", "coord", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "target", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "livemap"})
@SourceDebugExtension(value={"SMAP\nPointLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointLocator.kt\norg/jetbrains/letsPlot/livemap/chart/point/PointLocator\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n24#2,2:48\n24#2,2:50\n24#2,2:52\n24#2,2:54\n24#2,2:56\n2333#3,14:58\n*S KotlinDebug\n*F\n+ 1 PointLocator.kt\norg/jetbrains/letsPlot/livemap/chart/point/PointLocator\n*L\n23#1:48,2\n24#1:50,2\n25#1:52,2\n32#1:54,2\n33#1:56,2\n43#1:58,14\n*E\n"})
public final class PointLocator
implements Locator {
    @NotNull
    public static final PointLocator INSTANCE = new PointLocator();
    @NotNull
    private static final List<KClass<? extends EcsComponent>> REQUIRED_COMPONENTS;
    private static final double EXTRA_RADIUS;

    private PointLocator() {
    }

    @Override
    @Nullable
    public HoverObject search(@NotNull Vec<? extends Client> coord, @NotNull EcsEntity target, @NotNull RenderHelper renderHelper) {
        Intrinsics.checkNotNullParameter(coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        if (!target.contains((Collection<? extends KClass<? extends EcsComponent>>)REQUIRED_COMPONENTS)) {
            return null;
        }
        EcsEntity this_$iv = target;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (WorldOriginComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(WorldOriginComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldOriginComponent.class).getSimpleName() + " is not found");
        }
        Vec<World> origin = ((WorldOriginComponent)ecsComponent).getOrigin();
        EcsEntity this_$iv2 = target;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (PointComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(PointComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(PointComponent.class).getSimpleName() + " is not found");
        }
        PointComponent pointComponent = (PointComponent)ecsComponent2;
        EcsEntity this_$iv3 = target;
        boolean $i$f$get3 = false;
        EcsComponent ecsComponent3 = (ChartElementComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
        }
        ChartElementComponent chartElementComponent = (ChartElementComponent)ecsComponent3;
        double radius = renderHelper.dimToWorld-nwvo2uo(pointComponent.scaledRadius-VvMBhYE(chartElementComponent.getScalingSizeFactor()));
        double distance = VecKt.getLength((Vec)VecKt.minus(renderHelper.posToWorld(coord), origin));
        if (Scalar.compareTo-hZjkWWM((double)distance, (double)ScalarKt.plus-plX9Htw((double)radius, (double)renderHelper.dimToWorld-nwvo2uo(EXTRA_RADIUS))) <= 0) {
            EcsEntity this_$iv4 = target;
            boolean $i$f$get4 = false;
            EcsComponent ecsComponent4 = (IndexComponent)this_$iv4.getComponentManager().getComponents(this_$iv4).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
            if (ecsComponent4 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
            }
            this_$iv4 = target;
            $i$f$get4 = false;
            EcsComponent ecsComponent5 = (IndexComponent)this_$iv4.getComponentManager().getComponents(this_$iv4).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
            if (ecsComponent5 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
            }
            return new HoverObject(HoverObjectKind.POINT, ((IndexComponent)ecsComponent4).getLayerIndex(), ((IndexComponent)ecsComponent5).getIndex(), 0.0, this, FunctionsKt.toDoubleVector(renderHelper.worldToPos(origin)), renderHelper.dimToClient-nwvo2uo(radius));
        }
        return null;
    }

    @Override
    @Nullable
    public HoverObject reduce(@NotNull Collection<HoverObject> hoverObjects) {
        Object v0;
        Intrinsics.checkNotNullParameter(hoverObjects, (String)"hoverObjects");
        Iterable $this$minByOrNull$iv = hoverObjects;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                HoverObject p0 = (HoverObject)minElem$iv;
                boolean bl = false;
                double minValue$iv = p0.getDistance();
                do {
                    Object e$iv = iterator$iv.next();
                    HoverObject p02 = (HoverObject)e$iv;
                    $i$a$-minByOrNull-PointLocator$reduce$1 = false;
                    double v$iv = p02.getDistance();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(PointComponent.class), Reflection.getOrCreateKotlinClass(ChartElementComponent.class)};
        REQUIRED_COMPONENTS = CollectionsKt.listOf((Object[])objectArray);
        EXTRA_RADIUS = Client.Companion.getPx-VvMBhYE(6.0);
    }
}

