/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.point;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.PointComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.mapengine.Context2dExKt;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.Renderer;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J0\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u001d\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0013J \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J \u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J*\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/point/PointRenderer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/Renderer;", "shape", "", "degreeAngle", "", "(ID)V", "angle", "circle", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "r", "cross", "diamond", "drawMarker", "radius", "stroke", "plus", "plus$livemap", "render", "entity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "square", "squareTriangle", "triangle", "pointingUp", "", "livemap"})
@SourceDebugExtension(value={"SMAP\nPointRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointRenderer.kt\norg/jetbrains/letsPlot/livemap/chart/point/PointRenderer\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,178:1\n24#2,2:179\n24#2,2:181\n24#2,2:183\n*S KotlinDebug\n*F\n+ 1 PointRenderer.kt\norg/jetbrains/letsPlot/livemap/chart/point/PointRenderer\n*L\n27#1:179,2\n28#1:181,2\n30#1:183,2\n*E\n"})
public final class PointRenderer
implements Renderer {
    private final int shape;
    private final double angle;

    public PointRenderer(int shape, double degreeAngle) {
        this.shape = shape;
        this.angle = MathKt.toRadians((double)degreeAngle);
    }

    @Override
    public void render(@NotNull EcsEntity entity2, @NotNull Context2d ctx, @NotNull RenderHelper renderHelper) {
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        EcsEntity this_$iv = entity2;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (ChartElementComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
        }
        ChartElementComponent chartElement = (ChartElementComponent)ecsComponent;
        EcsEntity this_$iv2 = entity2;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (PointComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(PointComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(PointComponent.class).getSimpleName() + " is not found");
        }
        PointComponent pointData = (PointComponent)ecsComponent2;
        this_$iv2 = entity2;
        $i$f$get2 = false;
        EcsComponent ecsComponent3 = (WorldOriginComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(WorldOriginComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldOriginComponent.class).getSimpleName() + " is not found");
        }
        Context2dExKt.translate(ctx, renderHelper.dimToScreen(((WorldOriginComponent)ecsComponent3).getOrigin()));
        ctx.beginPath();
        this.drawMarker(ctx, pointData.scaledRadius-VvMBhYE(chartElement.getScalingSizeFactor()), chartElement.scaledStrokeWidth(), this.shape, this.angle);
        if (chartElement.getFillColor() != null) {
            ctx.setFillStyle(chartElement.scaledFillColor());
            ctx.fill();
        }
        if (chartElement.getStrokeColor() != null && chartElement.scaledStrokeWidth() > 0.0) {
            ctx.setStrokeStyle(chartElement.scaledStrokeColor());
            ctx.setLineWidth(chartElement.scaledStrokeWidth());
            ctx.stroke();
        }
    }

    private final void drawMarker(Context2d ctx, double radius, double stroke, int shape, double angle) {
        boolean needToRotate;
        Object[] objectArray = new Integer[]{1, 10, 16, 19, 20, 21};
        boolean bl = !CollectionsKt.listOf((Object[])objectArray).contains(shape) && !(angle == 0.0) ? true : (needToRotate = false);
        if (needToRotate) {
            ctx.rotate(angle);
        }
        switch (shape) {
            case 0: {
                this.square(ctx, radius);
                break;
            }
            case 1: {
                this.circle(ctx, radius);
                break;
            }
            case 2: {
                PointRenderer.triangle$default(this, ctx, radius, stroke, false, 8, null);
                break;
            }
            case 3: {
                this.plus$livemap(ctx, radius);
                break;
            }
            case 4: {
                this.cross(ctx, radius / Math.sqrt(2.0));
                break;
            }
            case 5: {
                this.diamond(ctx, radius);
                break;
            }
            case 6: {
                this.triangle(ctx, radius, stroke, false);
                break;
            }
            case 7: {
                this.square(ctx, radius);
                this.cross(ctx, radius);
                break;
            }
            case 8: {
                this.plus$livemap(ctx, radius);
                this.cross(ctx, radius / Math.sqrt(2.0));
                break;
            }
            case 9: {
                this.diamond(ctx, radius);
                this.plus$livemap(ctx, radius);
                break;
            }
            case 10: {
                this.circle(ctx, radius);
                this.plus$livemap(ctx, radius);
                break;
            }
            case 11: {
                this.triangle(ctx, radius, stroke, true);
                this.triangle(ctx, radius, stroke, false);
                break;
            }
            case 12: {
                this.square(ctx, radius);
                this.plus$livemap(ctx, radius);
                break;
            }
            case 13: {
                this.circle(ctx, radius);
                this.cross(ctx, radius / Math.sqrt(2.0));
                break;
            }
            case 14: {
                this.squareTriangle(ctx, radius, stroke);
                break;
            }
            case 15: {
                this.square(ctx, radius);
                break;
            }
            case 16: {
                this.circle(ctx, radius);
                break;
            }
            case 17: {
                PointRenderer.triangle$default(this, ctx, radius, 1.0, false, 8, null);
                break;
            }
            case 18: {
                this.diamond(ctx, radius);
                break;
            }
            case 19: {
                this.circle(ctx, radius);
                break;
            }
            case 20: {
                this.circle(ctx, radius);
                break;
            }
            case 21: {
                this.circle(ctx, radius);
                break;
            }
            case 22: {
                this.square(ctx, radius);
                break;
            }
            case 23: {
                this.diamond(ctx, radius);
                break;
            }
            case 24: {
                PointRenderer.triangle$default(this, ctx, radius, stroke, false, 8, null);
                break;
            }
            case 25: {
                this.triangle(ctx, radius, stroke, false);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown point shape");
            }
        }
        if (needToRotate) {
            ctx.rotate(-angle);
        }
    }

    private final void circle(Context2d ctx, double r) {
        Context2d.DefaultImpls.arc$default((Context2d)ctx, (double)0.0, (double)0.0, (double)r, (double)0.0, (double)(Math.PI * 2), (boolean)false, (int)32, null);
    }

    private final void square(Context2d ctx, double r) {
        ctx.moveTo(-r, -r);
        ctx.lineTo(r, -r);
        ctx.lineTo(r, r);
        ctx.lineTo(-r, r);
        ctx.closePath();
    }

    private final void squareTriangle(Context2d ctx, double r, double stroke) {
        double outerSize = (double)2 * r + stroke;
        double triangleHeight = outerSize - stroke / (double)2 - Math.sqrt(5.0) * stroke / (double)2;
        ctx.moveTo(-triangleHeight / (double)2, r);
        ctx.lineTo(0.0, r - triangleHeight);
        ctx.lineTo(triangleHeight / (double)2, r);
        ctx.lineTo(-r, r);
        ctx.lineTo(-r, -r);
        ctx.lineTo(r, -r);
        ctx.lineTo(r, r);
        ctx.closePath();
    }

    private final void triangle(Context2d ctx, double r, double stroke, boolean pointingUp) {
        double outerHeight = (double)2 * r + stroke;
        double height = outerHeight - 3.0 * stroke / 2.0;
        double side = 2.0 * height / Math.sqrt(3.0);
        double distanceToBase = (outerHeight - stroke) / 2.0;
        double distanceToPeak = height - distanceToBase;
        double pointingCoeff = pointingUp ? 1.0 : -1.0;
        double centroidOffset = height / 6.0 + stroke / 4.0;
        ctx.moveTo(0.0, -pointingCoeff * (distanceToPeak + centroidOffset));
        ctx.lineTo(side / 2.0, pointingCoeff * (distanceToBase - centroidOffset));
        ctx.lineTo(-side / 2.0, pointingCoeff * (distanceToBase - centroidOffset));
        ctx.lineTo(0.0, -pointingCoeff * (distanceToPeak + centroidOffset));
        ctx.closePath();
    }

    static /* synthetic */ void triangle$default(PointRenderer pointRenderer, Context2d context2d, double d, double d2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        pointRenderer.triangle(context2d, d, d2, bl);
    }

    public final void plus$livemap(@NotNull Context2d ctx, double r) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.moveTo(0.0, -r);
        ctx.lineTo(0.0, r);
        ctx.moveTo(-r, 0.0);
        ctx.lineTo(r, 0.0);
    }

    private final void cross(Context2d ctx, double r) {
        ctx.moveTo(-r, -r);
        ctx.lineTo(r, r);
        ctx.moveTo(-r, r);
        ctx.lineTo(r, -r);
    }

    private final void diamond(Context2d ctx, double r) {
        ctx.moveTo(0.0, -r);
        ctx.lineTo(r, 0.0);
        ctx.lineTo(0.0, r);
        ctx.lineTo(-r, 0.0);
        ctx.closePath();
    }
}

