/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.polygon;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Polygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Ring;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.chart.HoverObject;
import org.jetbrains.letsPlot.livemap.chart.HoverObjectKind;
import org.jetbrains.letsPlot.livemap.chart.IndexComponent;
import org.jetbrains.letsPlot.livemap.chart.Locator;
import org.jetbrains.letsPlot.livemap.chart.fragment.RegionFragmentsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.geometry.WorldGeometryComponent;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J&\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J0\u0010\u0014\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00060\u00172\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0006H\u0002J(\u0010\u0018\u001a\u0004\u0018\u00010\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/polygon/PolygonLocator;", "Lorg/jetbrains/letsPlot/livemap/chart/Locator;", "()V", "isCoordinateInPolygon", "", "coord", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/World;", "multiPolygon", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "isCoordinateOnEntity", "Lorg/jetbrains/letsPlot/livemap/Client;", "target", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "reduce", "Lorg/jetbrains/letsPlot/livemap/chart/HoverObject;", "hoverObjects", "", "ringContainsCoordinate", "TypeT", "ring", "", "search", "livemap"})
@SourceDebugExtension(value={"SMAP\nPolygonLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonLocator.kt\norg/jetbrains/letsPlot/livemap/chart/polygon/PolygonLocator\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n69#2:105\n24#2,2:106\n24#2,2:109\n24#2,2:111\n24#2,2:114\n24#2,2:116\n24#2,2:132\n1855#3:108\n1856#3:113\n1963#3,14:118\n*S KotlinDebug\n*F\n+ 1 PolygonLocator.kt\norg/jetbrains/letsPlot/livemap/chart/polygon/PolygonLocator\n*L\n25#1:105\n26#1:106,2\n30#1:109,2\n31#1:111,2\n43#1:114,2\n44#1:116,2\n64#1:132,2\n26#1:108\n26#1:113\n56#1:118,14\n*E\n"})
public final class PolygonLocator
implements Locator {
    @NotNull
    public static final PolygonLocator INSTANCE = new PolygonLocator();

    private PolygonLocator() {
    }

    @Override
    @Nullable
    public HoverObject search(@NotNull Vec<? extends Client> coord, @NotNull EcsEntity target, @NotNull RenderHelper renderHelper) {
        HoverObject hoverObject;
        Intrinsics.checkNotNullParameter(coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        EcsEntity this_$iv = target;
        boolean $i$f$contains = false;
        if (this_$iv.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(RegionFragmentsComponent.class))) {
            this_$iv = target;
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (RegionFragmentsComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(RegionFragmentsComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(RegionFragmentsComponent.class).getSimpleName() + " is not found");
            }
            Iterable $this$forEach$iv = ((RegionFragmentsComponent)ecsComponent).getFragments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EcsEntity fragment = (EcsEntity)element$iv;
                boolean bl = false;
                if (!INSTANCE.isCoordinateOnEntity(coord, fragment, renderHelper)) continue;
                EcsEntity this_$iv2 = target;
                boolean $i$f$get2 = false;
                EcsComponent ecsComponent2 = (IndexComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
                if (ecsComponent2 == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
                }
                this_$iv2 = target;
                $i$f$get2 = false;
                EcsComponent ecsComponent3 = (IndexComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
                if (ecsComponent3 == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
                }
                return new HoverObject(HoverObjectKind.POLYGON, ((IndexComponent)ecsComponent2).getLayerIndex(), ((IndexComponent)ecsComponent3).getIndex(), 0.0, this, null, null, 96, null);
            }
            return null;
        }
        boolean bl = this.isCoordinateOnEntity(coord, target, renderHelper);
        if (bl) {
            EcsEntity this_$iv3 = target;
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (IndexComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
            }
            this_$iv3 = target;
            $i$f$get = false;
            EcsComponent ecsComponent4 = (IndexComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(IndexComponent.class));
            if (ecsComponent4 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(IndexComponent.class).getSimpleName() + " is not found");
            }
            hoverObject = new HoverObject(HoverObjectKind.POLYGON, ((IndexComponent)ecsComponent).getLayerIndex(), ((IndexComponent)ecsComponent4).getIndex(), 0.0, this, null, null, 96, null);
        } else if (!bl) {
            hoverObject = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return hoverObject;
    }

    @Override
    @Nullable
    public HoverObject reduce(@NotNull Collection<HoverObject> hoverObjects) {
        Object v0;
        Intrinsics.checkNotNullParameter(hoverObjects, (String)"hoverObjects");
        Iterable $this$maxByOrNull$iv = hoverObjects;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                HoverObject p0 = (HoverObject)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = p0.getIndex();
                do {
                    Object e$iv = iterator$iv.next();
                    HoverObject p02 = (HoverObject)e$iv;
                    $i$a$-maxByOrNull-PolygonLocator$reduce$1 = false;
                    int v$iv = p02.getIndex();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private final boolean isCoordinateOnEntity(Vec<? extends Client> coord, EcsEntity target, RenderHelper renderHelper) {
        if (!target.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class))) {
            return false;
        }
        Vec<World> cursorMapCoord = renderHelper.posToWorld(coord);
        EcsEntity this_$iv = target;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (WorldGeometryComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class).getSimpleName() + " is not found");
        }
        return this.isCoordinateInPolygon(cursorMapCoord, (MultiPolygon<World>)((WorldGeometryComponent)ecsComponent).getGeometry().getMultiPolygon());
    }

    private final boolean isCoordinateInPolygon(Vec<? extends World> coord, MultiPolygon<World> multiPolygon) {
        for (Polygon polygon : multiPolygon) {
            Rect rect2 = polygon.getBbox();
            if (rect2 != null ? !RectKt.contains((Rect)rect2, coord) : false) continue;
            int count = 0;
            for (Ring ring : polygon) {
                if (!this.ringContainsCoordinate((List)ring, coord)) continue;
                ++count;
            }
            if (count % 2 != 1) continue;
            return true;
        }
        return false;
    }

    private final <TypeT> boolean ringContainsCoordinate(List<? extends Vec<? extends TypeT>> ring, Vec<? extends TypeT> coord) {
        int intersectionCount = 0;
        int n = ring.size();
        for (int i = 1; i < n; ++i) {
            double x;
            int start = i - 1;
            if (ring.get(start).getY() >= coord.getY() && ring.get(i).getY() >= coord.getY() || ring.get(start).getY() < coord.getY() && ring.get(i).getY() < coord.getY() || !((x = ring.get(start).getX() + (coord.getY() - ring.get(start).getY()) * (ring.get(i).getX() - ring.get(start).getX()) / (ring.get(i).getY() - ring.get(start).getY())) <= coord.getX())) continue;
            ++intersectionCount;
        }
        return intersectionCount % 2 != 0;
    }
}

