/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.polygon;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.LineJoin;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.polygon.PolygonRenderer;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.geometry.WorldGeometryComponent;
import org.jetbrains.letsPlot.livemap.mapengine.Context2dExKt;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.Renderer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/polygon/PolygonRenderer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/Renderer;", "()V", "render", "", "entity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "livemap"})
@SourceDebugExtension(value={"SMAP\nPolygonRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonRenderer.kt\norg/jetbrains/letsPlot/livemap/chart/polygon/PolygonRenderer\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,43:1\n24#2,2:44\n24#2,2:46\n*S KotlinDebug\n*F\n+ 1 PolygonRenderer.kt\norg/jetbrains/letsPlot/livemap/chart/polygon/PolygonRenderer\n*L\n19#1:44,2\n20#1:46,2\n*E\n"})
public final class PolygonRenderer
implements Renderer {
    @Override
    public void render(@NotNull EcsEntity entity2, @NotNull Context2d ctx, @NotNull RenderHelper renderHelper) {
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        EcsEntity this_$iv = entity2;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (ChartElementComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
        }
        ChartElementComponent chartElement = (ChartElementComponent)ecsComponent;
        EcsEntity this_$iv2 = entity2;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (WorldGeometryComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldGeometryComponent.class).getSimpleName() + " is not found");
        }
        MultiPolygon geometry = ((WorldGeometryComponent)ecsComponent2).getGeometry().getMultiPolygon();
        ctx.setLineJoin(LineJoin.ROUND);
        ctx.beginPath();
        ctx.save();
        ctx.scale(renderHelper.getZoomFactor());
        Context2dExKt.drawMultiPolygon(ctx, geometry, (Function1<? super Context2d, Unit>)((Function1)render.1.INSTANCE));
        ctx.restore();
        if (chartElement.getFillColor() != null) {
            ctx.setFillStyle(chartElement.scaledFillColor());
            ctx.fill();
        }
        if (chartElement.getStrokeColor() != null && !(chartElement.getStrokeWidth() == 0.0)) {
            ctx.setStrokeStyle(chartElement.scaledStrokeColor());
            ctx.setLineDash(chartElement.scaledLineDash());
            ctx.setLineDashOffset(chartElement.scaledLineDashOffset());
            ctx.setLineWidth(chartElement.scaledStrokeWidth());
            ctx.stroke();
        }
    }
}

