/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.text;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.livemap.chart.ChartElementComponent;
import org.jetbrains.letsPlot.livemap.chart.TextSpecComponent;
import org.jetbrains.letsPlot.livemap.chart.text.TextSpec;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.mapengine.Context2dExKt;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.Renderer;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/text/TextRenderer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/Renderer;", "()V", "drawRoundedRectangle", "", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "radius", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "render", "entity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "livemap"})
@SourceDebugExtension(value={"SMAP\nTextRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRenderer.kt\norg/jetbrains/letsPlot/livemap/chart/text/TextRenderer\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n24#2,2:123\n24#2,2:125\n24#2,2:127\n1864#3,3:129\n*S KotlinDebug\n*F\n+ 1 TextRenderer.kt\norg/jetbrains/letsPlot/livemap/chart/text/TextRenderer\n*L\n24#1:123,2\n25#1:125,2\n32#1:127,2\n79#1:129,3\n*E\n"})
public final class TextRenderer
implements Renderer {
    /*
     * WARNING - void declaration
     */
    @Override
    public void render(@NotNull EcsEntity entity2, @NotNull Context2d ctx, @NotNull RenderHelper renderHelper) {
        double padding;
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        EcsEntity this_$iv = entity2;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (ChartElementComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(ChartElementComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ChartElementComponent.class).getSimpleName() + " is not found");
        }
        ChartElementComponent chartElementComponent = (ChartElementComponent)ecsComponent;
        EcsEntity this_$iv2 = entity2;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (TextSpecComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(TextSpecComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(TextSpecComponent.class).getSimpleName() + " is not found");
        }
        TextSpecComponent textSpecComponent = (TextSpecComponent)ecsComponent2;
        TextSpec textSpec = textSpecComponent.getTextSpec();
        Vec textPosition = null;
        Font font = textSpecComponent.scaledFont(chartElementComponent.getScalingSizeFactor());
        EcsEntity this_$iv3 = entity2;
        boolean $i$f$get3 = false;
        EcsComponent ecsComponent3 = (WorldOriginComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(WorldOriginComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldOriginComponent.class).getSimpleName() + " is not found");
        }
        Context2dExKt.translate(ctx, VecKt.plus(renderHelper.dimToScreen(((WorldOriginComponent)ecsComponent3).getOrigin()), chartElementComponent.scaledNudge()));
        ctx.rotate(textSpec.getAngle());
        if (textSpec.getDrawBorder()) {
            DoubleRectangle rectangle = textSpecComponent.scaledRectangle(chartElementComponent.getScalingSizeFactor());
            double labelRadius = textSpec.getLabelRadius();
            this.drawRoundedRectangle(rectangle, labelRadius * rectangle.getHeight(), ctx);
            if (chartElementComponent.getFillColor() != null) {
                ctx.setFillStyle(chartElementComponent.scaledFillColor());
                ctx.fill();
            }
            if (chartElementComponent.getStrokeColor() != null && !(textSpec.getLabelSize() == 0.0)) {
                ctx.setStrokeStyle(chartElementComponent.getStrokeColor());
                ctx.setLineWidth(textSpecComponent.scaledLabelSize(chartElementComponent.getScalingSizeFactor()));
                ctx.stroke();
            }
            padding = textSpecComponent.scaledPadding(chartElementComponent.getScalingSizeFactor());
            double d = textSpec.getHjust();
            double xPosition = d == 0.0 ? padding : (d == 1.0 ? -padding : 0.0);
            textPosition = VecKt.explicitVec((double)xPosition, (double)(rectangle.getOrigin().getY() + padding + font.getFontSize() * 0.8));
        } else {
            DoubleVector textSize = textSpecComponent.scaledTextSize(chartElementComponent.getScalingSizeFactor());
            padding = textSpec.getVjust();
            double yPosition = padding == 0.0 ? font.getFontSize() * 0.7 : (padding == 1.0 ? -textSize.getY() + font.getFontSize() : -textSize.getY() / (double)2 + font.getFontSize() * 0.8);
            textPosition = VecKt.explicitVec((double)0.0, (double)yPosition);
        }
        ctx.setFont(font);
        ctx.setFillStyle(chartElementComponent.getStrokeColor());
        ctx.setTextAlign(textSpec.getTextAlign());
        double lineHeight = textSpecComponent.scaledLineHeight(chartElementComponent.getScalingSizeFactor());
        Iterable $this$forEachIndexed$iv = textSpec.getLines();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            ctx.fillText((String)line, textPosition.getX(), textPosition.getY() + lineHeight * (double)index);
        }
    }

    private final void drawRoundedRectangle(DoubleRectangle rect2, double radius, Context2d ctx) {
        Context2d context2d;
        Context2d $this$drawRoundedRectangle_u24lambda_u242 = context2d = ctx;
        boolean bl = false;
        $this$drawRoundedRectangle_u24lambda_u242.beginPath();
        DoubleRectangle $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241 = rect2;
        boolean bl2 = false;
        double r = Math.min(radius, Math.min($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getWidth() / (double)2, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getHeight() / (double)2));
        $this$drawRoundedRectangle_u24lambda_u242.moveTo($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getRight() - r, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getBottom());
        $this$drawRoundedRectangle_u24lambda_u242.bezierCurveTo($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getRight() - r, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getBottom(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getBottom(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getBottom() - r);
        $this$drawRoundedRectangle_u24lambda_u242.lineTo($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getTop() + r);
        $this$drawRoundedRectangle_u24lambda_u242.bezierCurveTo($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getTop() + r, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getRight(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getTop(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getRight() - r, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getTop());
        $this$drawRoundedRectangle_u24lambda_u242.lineTo($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getLeft() + r, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getTop());
        $this$drawRoundedRectangle_u24lambda_u242.bezierCurveTo($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getLeft() + r, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getTop(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getTop(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getTop() + r);
        $this$drawRoundedRectangle_u24lambda_u242.lineTo($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getBottom() - r);
        $this$drawRoundedRectangle_u24lambda_u242.bezierCurveTo($this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getBottom() - r, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getLeft(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getBottom(), $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getLeft() + r, $this$drawRoundedRectangle_u24lambda_u242_u24lambda_u241.getBottom());
        $this$drawRoundedRectangle_u24lambda_u242.closePath();
    }
}

