/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.chart.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.core.canvas.FontStyle;
import org.jetbrains.letsPlot.core.canvas.FontWeight;
import org.jetbrains.letsPlot.core.canvas.TextAlign;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.core.graphics.TextMeasurer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\f\u0012\u0006\u0010\u0014\u001a\u00020\f\u0012\u0006\u0010\u0015\u001a\u00020\f\u0012\u0006\u0010\u0016\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u00105\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\fH\u0002R\u0011\u0010\u0018\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u0011\u0010\u0014\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001aR\u0011\u0010\u0015\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001aR\u0011\u0010)\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001aR\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001aR\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001a\u00a8\u0006;"}, d2={"Lorg/jetbrains/letsPlot/livemap/chart/text/TextSpec;", "", "label", "", "fontStyle", "Lorg/jetbrains/letsPlot/core/canvas/FontStyle;", "fontWeight", "Lorg/jetbrains/letsPlot/core/canvas/FontWeight;", "size", "", "family", "degreeAngle", "", "hjust", "vjust", "textMeasurer", "Lorg/jetbrains/letsPlot/livemap/core/graphics/TextMeasurer;", "drawBorder", "", "labelPadding", "labelRadius", "labelSize", "lineheight", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/core/canvas/FontStyle;Lorg/jetbrains/letsPlot/core/canvas/FontWeight;ILjava/lang/String;DDDLorg/jetbrains/letsPlot/livemap/core/graphics/TextMeasurer;ZDDDD)V", "angle", "getAngle", "()D", "dimension", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "getDimension", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "getDrawBorder", "()Z", "font", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "getFont", "()Lorg/jetbrains/letsPlot/core/canvas/Font;", "getHjust", "getLabelRadius", "getLabelSize", "lineHeight", "getLineHeight", "lines", "", "getLines", "()Ljava/util/List;", "padding", "getPadding", "textAlign", "Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "getTextAlign", "()Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "textSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getTextSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getVjust", "rotateTextSize", "livemap"})
@SourceDebugExtension(value={"SMAP\nTextSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextSpec.kt\norg/jetbrains/letsPlot/livemap/chart/text/TextSpec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1549#2:70\n1620#2,3:71\n*S KotlinDebug\n*F\n+ 1 TextSpec.kt\norg/jetbrains/letsPlot/livemap/chart/text/TextSpec\n*L\n39#1:70\n39#1:71,3\n*E\n"})
public final class TextSpec {
    private final double hjust;
    private final double vjust;
    private final boolean drawBorder;
    private final double labelRadius;
    private final double labelSize;
    @NotNull
    private final List<String> lines;
    @NotNull
    private final Font font;
    @NotNull
    private final Vec<Client> dimension;
    private final double angle;
    private final double lineHeight;
    @NotNull
    private final DoubleVector textSize;
    @NotNull
    private final TextAlign textAlign;
    private final double padding;

    /*
     * WARNING - void declaration
     */
    public TextSpec(@NotNull String label, @NotNull FontStyle fontStyle, @NotNull FontWeight fontWeight, int size, @NotNull String family, double degreeAngle, double hjust, double vjust, @NotNull TextMeasurer textMeasurer, boolean drawBorder, double labelPadding, double labelRadius, double labelSize, double lineheight) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)fontStyle, (String)"fontStyle");
        Intrinsics.checkNotNullParameter((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkNotNullParameter((Object)family, (String)"family");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        this.hjust = hjust;
        this.vjust = vjust;
        this.drawBorder = drawBorder;
        this.labelRadius = labelRadius;
        this.labelSize = labelSize;
        Object object = new char[]{'\n'};
        object = StringsKt.split$default((CharSequence)label, (char[])object, (boolean)false, (int)0, (int)6, null);
        TextSpec textSpec = this;
        boolean $i$f$map = false;
        void var24_19 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p0))).toString());
        }
        textSpec.lines = (List)destination$iv$iv;
        this.font = new Font(fontStyle, fontWeight, (double)size, family);
        this.angle = MathKt.toRadians((double)(-degreeAngle));
        this.lineHeight = lineheight * (double)size;
        this.textSize = textMeasurer.measure(this.lines, this.font, this.lineHeight);
        double d = this.hjust;
        this.textAlign = d == 0.0 ? TextAlign.START : (d == 1.0 ? TextAlign.END : TextAlign.CENTER);
        this.padding = this.font.getFontSize() * labelPadding;
        this.dimension = this.rotateTextSize(this.textSize.mul(2.0), this.angle);
    }

    public final double getHjust() {
        return this.hjust;
    }

    public final double getVjust() {
        return this.vjust;
    }

    public final boolean getDrawBorder() {
        return this.drawBorder;
    }

    public final double getLabelRadius() {
        return this.labelRadius;
    }

    public final double getLabelSize() {
        return this.labelSize;
    }

    @NotNull
    public final List<String> getLines() {
        return this.lines;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    @NotNull
    public final Vec<Client> getDimension() {
        return this.dimension;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final double getLineHeight() {
        return this.lineHeight;
    }

    @NotNull
    public final DoubleVector getTextSize() {
        return this.textSize;
    }

    @NotNull
    public final TextAlign getTextAlign() {
        return this.textAlign;
    }

    public final double getPadding() {
        return this.padding;
    }

    private final Vec<Client> rotateTextSize(DoubleVector textSize, double angle) {
        DoubleVector p1 = new DoubleVector(textSize.getX() / (double)2, textSize.getY() / (double)2).rotate(angle);
        DoubleVector p2 = new DoubleVector(textSize.getX() / (double)2, -textSize.getY() / (double)2).rotate(angle);
        double maxX = Math.max(Math.abs(p1.getX()), Math.abs(p2.getX()));
        double maxY = Math.max(Math.abs(p1.getY()), Math.abs(p2.getY()));
        return VecKt.explicitVec((double)(maxX * (double)2), (double)(maxY * (double)2));
    }
}

