/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.config;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Transforms;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.GeoProjection;
import org.jetbrains.letsPlot.livemap.core.Geographic;
import org.jetbrains.letsPlot.livemap.core.Transform;
import org.jetbrains.letsPlot.livemap.core.UnsafeTransform;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJN\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u0013\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0016\"\u0004\b\u0002\u0010\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00160\u00132\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00150\u0013H\u0002JN\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u0019\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0016\"\u0004\b\u0002\u0010\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00160\u00192\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00150\u0013H\u0002JN\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u0019\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0016\"\u0004\b\u0002\u0010\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00160\u00192\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00150\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010\u001e\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/livemap/config/MapProjectionBuilder;", "", "geoProjection", "Lorg/jetbrains/letsPlot/livemap/core/GeoProjection;", "mapRect", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/WorldRectangle;", "(Lorg/jetbrains/letsPlot/livemap/core/GeoProjection;Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;)V", "reverseX", "", "getReverseX", "()Z", "setReverseX", "(Z)V", "reverseY", "getReverseY", "setReverseY", "composite", "Lorg/jetbrains/letsPlot/livemap/core/Transform;", "InT", "OutT", "InterT", "t1", "t2", "Lorg/jetbrains/letsPlot/livemap/core/UnsafeTransform;", "create", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "linear", "", "offset", "scale", "livemap"})
public final class MapProjectionBuilder {
    @NotNull
    private final GeoProjection geoProjection;
    @NotNull
    private final Rect<World> mapRect;
    private boolean reverseX;
    private boolean reverseY;

    public MapProjectionBuilder(@NotNull GeoProjection geoProjection, @NotNull Rect<World> mapRect) {
        Intrinsics.checkNotNullParameter((Object)geoProjection, (String)"geoProjection");
        Intrinsics.checkNotNullParameter(mapRect, (String)"mapRect");
        this.geoProjection = geoProjection;
        this.mapRect = mapRect;
    }

    public final boolean getReverseX() {
        return this.reverseX;
    }

    public final void setReverseX(boolean bl) {
        this.reverseX = bl;
    }

    public final boolean getReverseY() {
        return this.reverseY;
    }

    public final void setReverseY(boolean bl) {
        this.reverseY = bl;
    }

    private final Transform<Double, Double> offset(double offset2) {
        return new Transform<Double, Double>(offset2){
            final /* synthetic */ double $offset;
            {
                this.$offset = $offset;
            }

            @NotNull
            public Double apply(double v) {
                return v - this.$offset;
            }

            @NotNull
            public Double invert(double v) {
                return v + this.$offset;
            }
        };
    }

    private final <InT, InterT, OutT> UnsafeTransform<InT, OutT> composite(UnsafeTransform<InT, InterT> t1, UnsafeTransform<InterT, OutT> t2) {
        return new UnsafeTransform<InT, OutT>(t1, t2){
            final /* synthetic */ UnsafeTransform<InT, InterT> $t1;
            final /* synthetic */ UnsafeTransform<InterT, OutT> $t2;
            {
                this.$t1 = $t1;
                this.$t2 = $t2;
            }

            @Nullable
            public OutT apply(InT v) {
                Object object;
                Object object2 = v;
                UnsafeTransform<Object, Object> unsafeTransform = this.$t1;
                InT p0 = object2;
                boolean bl = false;
                InterT InterT = unsafeTransform.apply(p0);
                if (InterT != null) {
                    object2 = InterT;
                    unsafeTransform = this.$t2;
                    p0 = object2;
                    boolean bl2 = false;
                    object = unsafeTransform.apply(p0);
                } else {
                    object = null;
                }
                return (OutT)object;
            }

            @Nullable
            public InT invert(OutT v) {
                Object object;
                Object object2 = v;
                UnsafeTransform<Object, Object> unsafeTransform = this.$t2;
                OutT p0 = object2;
                boolean bl = false;
                InterT InterT = unsafeTransform.invert(p0);
                if (InterT != null) {
                    object2 = InterT;
                    unsafeTransform = this.$t1;
                    p0 = object2;
                    boolean bl2 = false;
                    object = unsafeTransform.invert(p0);
                } else {
                    object = null;
                }
                return (InT)object;
            }
        };
    }

    private final <InT, InterT, OutT> UnsafeTransform<InT, OutT> composite(UnsafeTransform<InT, InterT> t1, Transform<InterT, OutT> t2) {
        return new UnsafeTransform<InT, OutT>(t1, t2){
            final /* synthetic */ UnsafeTransform<InT, InterT> $t1;
            final /* synthetic */ Transform<InterT, OutT> $t2;
            {
                this.$t1 = $t1;
                this.$t2 = $t2;
            }

            @Nullable
            public OutT apply(InT v) {
                OutT OutT;
                Object object = v;
                Object object2 = this.$t1;
                InT p0 = object;
                boolean bl = false;
                InterT InterT = object2.apply(p0);
                if (InterT != null) {
                    object = InterT;
                    object2 = this.$t2;
                    p0 = object;
                    boolean bl2 = false;
                    OutT = object2.apply(p0);
                } else {
                    OutT = null;
                }
                return OutT;
            }

            @Nullable
            public InT invert(OutT v) {
                InT InT;
                Object object = v;
                Object object2 = this.$t2;
                OutT p0 = object;
                boolean bl = false;
                InterT InterT = object2.invert(p0);
                if (InterT != null) {
                    object = InterT;
                    object2 = this.$t1;
                    p0 = object;
                    boolean bl2 = false;
                    InT = object2.invert(p0);
                } else {
                    InT = null;
                }
                return InT;
            }
        };
    }

    private final <InT, InterT, OutT> Transform<InT, OutT> composite(Transform<InT, InterT> t1, Transform<InterT, OutT> t2) {
        return new Transform<InT, OutT>(t1, t2){
            final /* synthetic */ Transform<InT, InterT> $t1;
            final /* synthetic */ Transform<InterT, OutT> $t2;
            {
                this.$t1 = $t1;
                this.$t2 = $t2;
            }

            public OutT apply(InT v) {
                Object object = v;
                Transform<Object, Object> transform2 = this.$t1;
                InT p0 = object;
                boolean bl = false;
                object = transform2.apply(p0);
                transform2 = this.$t2;
                p0 = object;
                boolean bl2 = false;
                return (OutT)transform2.apply(p0);
            }

            public InT invert(OutT v) {
                Object object = v;
                Transform<Object, Object> transform2 = this.$t2;
                OutT p0 = object;
                boolean bl = false;
                object = transform2.invert(p0);
                transform2 = this.$t1;
                p0 = object;
                boolean bl2 = false;
                return (InT)transform2.invert(p0);
            }
        };
    }

    private final Transform<Double, Double> linear(double offset2, double scale2) {
        return this.composite(this.offset(offset2), org.jetbrains.letsPlot.livemap.core.Transforms.INSTANCE.scale$livemap((Function0<Double>)((Function0)new Function0<Double>(scale2){
            final /* synthetic */ double $scale;
            {
                this.$scale = $scale;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return this.$scale;
            }
        })));
    }

    @NotNull
    public final MapProjection create() {
        Rect rect2 = Transforms.transform$default((Transforms)Transforms.INSTANCE, this.geoProjection.validRect(), (Function1)((Function1)new Function1<Vec<? extends LonLat>, Vec<? extends Geographic>>((Object)this.geoProjection){

            @Nullable
            public final Vec<Geographic> invoke(@NotNull Vec<? extends LonLat> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return (Vec)((GeoProjection)this.receiver).apply(p0);
            }
        }), null, (int)4, null);
        if (rect2 == null) {
            throw new IllegalStateException("Unable to transform projection valid rect".toString());
        }
        Rect rect3 = rect2;
        double scale2 = Math.min(RectKt.getWidth(this.mapRect) / RectKt.getWidth((Rect)rect3), RectKt.getHeight(this.mapRect) / RectKt.getHeight((Rect)rect3));
        Vec vec = VecKt.times((Vec)this.mapRect.getDimension(), (double)(1.0 / scale2));
        Intrinsics.checkNotNull((Object)vec, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec<org.jetbrains.letsPlot.livemap.core.Geographic>");
        Vec projSize = vec;
        Rect projRect = new Rect(VecKt.minus((Vec)RectKt.getCenter((Rect)rect3), (Vec)VecKt.times((Vec)projSize, (double)0.5)), projSize);
        double offsetX = this.reverseX ? RectKt.getRight((Rect)projRect) : RectKt.getLeft((Rect)projRect);
        double scaleX = this.reverseX ? -scale2 : scale2;
        double offsetY = this.reverseY ? RectKt.getBottom((Rect)projRect) : RectKt.getTop((Rect)projRect);
        double scaleY = this.reverseY ? -scale2 : scale2;
        Transform linearProjection = org.jetbrains.letsPlot.livemap.core.Transforms.INSTANCE.tuple$livemap(this.linear(offsetX, scaleX), this.linear(offsetY, scaleY));
        UnsafeTransform<Vec<LonLat>, Vec<World>> proj = this.composite((UnsafeTransform)this.geoProjection, linearProjection);
        return new MapProjection(proj, this){
            final /* synthetic */ UnsafeTransform<Vec<LonLat>, Vec<World>> $proj;
            final /* synthetic */ MapProjectionBuilder this$0;
            {
                this.$proj = $proj;
                this.this$0 = $receiver;
            }

            @Nullable
            public Vec<World> apply(@NotNull Vec<? extends LonLat> v) {
                Intrinsics.checkNotNullParameter(v, (String)"v");
                return this.$proj.apply(v);
            }

            @Nullable
            public Vec<LonLat> invert(@NotNull Vec<? extends World> v) {
                Intrinsics.checkNotNullParameter(v, (String)"v");
                return this.$proj.invert(v);
            }

            @NotNull
            public Rect<World> getMapRect() {
                return MapProjectionBuilder.access$getMapRect$p(this.this$0);
            }
        };
    }

    public static final /* synthetic */ Rect access$getMapRect$p(MapProjectionBuilder $this) {
        return $this.mapRect;
    }
}

