/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.SystemTime;
import org.jetbrains.letsPlot.livemap.containers.PriorityQueue;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fJ\u0014\u0010#\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/MetricsService;", "", "mySystemTime", "Lorg/jetbrains/letsPlot/commons/SystemTime;", "(Lorg/jetbrains/letsPlot/commons/SystemTime;)V", "myBeginTime", "", "myMeasures", "Lorg/jetbrains/letsPlot/livemap/containers/PriorityQueue;", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsSystem;", "", "kotlin.jvm.PlatformType", "myValuesMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "myValuesOrder", "", "<set-?>", "totalUpdateTime", "getTotalUpdateTime", "()J", "values", "", "getValues", "()Ljava/util/Collection;", "beginMeasureUpdate", "", "endMeasureUpdate", "system", "reset", "setValue", "key", "value", "setValuesOrder", "keys", "slowestSystem", "livemap"})
@SourceDebugExtension(value={"SMAP\nMetricsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsService.kt\norg/jetbrains/letsPlot/livemap/core/MetricsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class MetricsService {
    @NotNull
    private final SystemTime mySystemTime;
    @NotNull
    private final PriorityQueue<Pair<EcsSystem, Double>> myMeasures;
    private long myBeginTime;
    private long totalUpdateTime;
    @NotNull
    private final HashMap<String, String> myValuesMap;
    @NotNull
    private List<String> myValuesOrder;

    public MetricsService(@NotNull SystemTime mySystemTime) {
        Intrinsics.checkNotNullParameter((Object)mySystemTime, (String)"mySystemTime");
        this.mySystemTime = mySystemTime;
        Comparator comparator = ((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair p0 = (Pair)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(((Number)p0.getSecond()).doubleValue());
                p0 = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(((Number)p0.getSecond()).doubleValue()));
            }
        }).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        this.myMeasures = new PriorityQueue(comparator);
        this.myValuesMap = new HashMap();
        this.myValuesOrder = new ArrayList();
    }

    public final long getTotalUpdateTime() {
        return this.totalUpdateTime;
    }

    @NotNull
    public final Collection<String> getValues() {
        ArrayList<String> arrayList;
        ArrayList<String> $this$_get_values__u24lambda_u241 = arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String key : this.myValuesOrder) {
            String it;
            if (this.myValuesMap.get(key) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(((CharSequence)it).length() > 0)) continue;
            $this$_get_values__u24lambda_u241.add(it);
        }
        return arrayList;
    }

    public final void beginMeasureUpdate() {
        this.myBeginTime = this.mySystemTime.getTimeMs();
    }

    public final void endMeasureUpdate(@NotNull EcsSystem system) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        long time = this.mySystemTime.getTimeMs() - this.myBeginTime;
        this.myMeasures.add((Pair<EcsSystem, Double>)new Pair((Object)system, (Object)time));
        this.totalUpdateTime += time;
    }

    public final void reset() {
        this.myMeasures.clear();
        this.totalUpdateTime = 0L;
    }

    @Nullable
    public final Pair<EcsSystem, Double> slowestSystem() {
        return this.myMeasures.peek();
    }

    public final void setValue(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.myValuesMap).put(key, value);
    }

    public final void setValuesOrder(@NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.myValuesOrder = keys;
    }
}

