/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.FunctionsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.core.GeoProjection;
import org.jetbrains.letsPlot.livemap.core.Geographic;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000e0\nj\u0002`\u000fH\u0016J(\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\nj\u0004\u0018\u0001`\u000f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/ProjectionWrapper;", "Lorg/jetbrains/letsPlot/livemap/core/GeoProjection;", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "(Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;)V", "cylindrical", "", "getCylindrical", "()Z", "apply", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/core/Geographic;", "Lorg/jetbrains/letsPlot/livemap/core/GeographicPoint;", "v", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLatPoint;", "invert", "validRect", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "livemap"})
public final class ProjectionWrapper
implements GeoProjection {
    @NotNull
    private final Projection projection;
    private final boolean cylindrical;

    public ProjectionWrapper(@NotNull Projection projection) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        this.projection = projection;
        this.cylindrical = this.projection.getCylindrical();
    }

    @Override
    @NotNull
    public Rect<LonLat> validRect() {
        return FunctionsKt.toRect((DoubleRectangle)this.projection.validDomain());
    }

    @Override
    public boolean getCylindrical() {
        return this.cylindrical;
    }

    @Override
    @Nullable
    public Vec<Geographic> apply(@NotNull Vec<? extends LonLat> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        DoubleVector doubleVector = this.projection.project(FunctionsKt.toDoubleVector(v));
        return doubleVector != null ? FunctionsKt.toVec((DoubleVector)doubleVector) : null;
    }

    @Override
    @Nullable
    public Vec<LonLat> invert(@NotNull Vec<? extends Geographic> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        DoubleVector doubleVector = this.projection.invert(FunctionsKt.toDoubleVector(v));
        return doubleVector != null ? FunctionsKt.toVec((DoubleVector)doubleVector) : null;
    }
}

