/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.animation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.livemap.core.animation.Animation;
import org.jetbrains.letsPlot.livemap.core.animation.Animator;
import org.jetbrains.letsPlot.livemap.core.animation.TimeState;
import org.jetbrains.letsPlot.livemap.core.util.EasingFunctions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/animation/Animations;", "", "()V", "AnimationBuilder", "DoubleAnimator", "DoubleVectorAnimator", "SimpleAnimation", "livemap"})
public final class Animations {
    @NotNull
    public static final Animations INSTANCE = new Animations();

    private Animations() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0007J\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\tJ\u001e\u0010\u0017\u001a\u00020\u00002\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bj\u0002`\fJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bj\u0002`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/animation/Animations$AnimationBuilder;", "", "duration", "", "(D)V", "animators", "", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animator;", "direction", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animation$Direction;", "easingFunction", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/livemap/core/util/EasingFunction;", "loop", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animation$Loop;", "addAnimator", "v", "build", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animation;", "setAnimator", "setAnimators", "", "setDirection", "setEasingFunction", "setLoop", "livemap"})
    @SourceDebugExtension(value={"SMAP\nAnimations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animations.kt\norg/jetbrains/letsPlot/livemap/core/animation/Animations$AnimationBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class AnimationBuilder {
        private final double duration;
        @NotNull
        private Function1<? super Double, Double> easingFunction;
        @NotNull
        private Animation.Loop loop;
        @NotNull
        private Animation.Direction direction;
        @NotNull
        private List<Animator> animators;

        public AnimationBuilder(double duration) {
            this.duration = duration;
            this.easingFunction = EasingFunctions.INSTANCE.getLINEAR();
            this.loop = Animation.Loop.DISABLED;
            this.direction = Animation.Direction.FORWARD;
            this.animators = new ArrayList();
        }

        @NotNull
        public final AnimationBuilder setEasingFunction(@NotNull Function1<? super Double, Double> v) {
            AnimationBuilder animationBuilder;
            Intrinsics.checkNotNullParameter(v, (String)"v");
            AnimationBuilder $this$setEasingFunction_u24lambda_u240 = animationBuilder = this;
            boolean bl = false;
            $this$setEasingFunction_u24lambda_u240.easingFunction = v;
            return animationBuilder;
        }

        @NotNull
        public final AnimationBuilder setLoop(@NotNull Animation.Loop v) {
            AnimationBuilder animationBuilder;
            Intrinsics.checkNotNullParameter((Object)((Object)v), (String)"v");
            AnimationBuilder $this$setLoop_u24lambda_u241 = animationBuilder = this;
            boolean bl = false;
            $this$setLoop_u24lambda_u241.loop = v;
            return animationBuilder;
        }

        @NotNull
        public final AnimationBuilder setDirection(@NotNull Animation.Direction v) {
            AnimationBuilder animationBuilder;
            Intrinsics.checkNotNullParameter((Object)((Object)v), (String)"v");
            AnimationBuilder $this$setDirection_u24lambda_u242 = animationBuilder = this;
            boolean bl = false;
            $this$setDirection_u24lambda_u242.direction = v;
            return animationBuilder;
        }

        @NotNull
        public final AnimationBuilder setAnimator(@NotNull Animator v) {
            AnimationBuilder animationBuilder;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            AnimationBuilder $this$setAnimator_u24lambda_u243 = animationBuilder = this;
            boolean bl = false;
            Object[] objectArray = new Animator[]{v};
            $this$setAnimator_u24lambda_u243.animators = CollectionsKt.mutableListOf((Object[])objectArray);
            return animationBuilder;
        }

        @NotNull
        public final AnimationBuilder setAnimators(@NotNull Collection<? extends Animator> v) {
            AnimationBuilder animationBuilder;
            Intrinsics.checkNotNullParameter(v, (String)"v");
            AnimationBuilder $this$setAnimators_u24lambda_u244 = animationBuilder = this;
            boolean bl = false;
            $this$setAnimators_u24lambda_u244.animators = new ArrayList<Animator>(v);
            return animationBuilder;
        }

        @NotNull
        public final AnimationBuilder addAnimator(@NotNull Animator v) {
            AnimationBuilder animationBuilder;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            AnimationBuilder $this$addAnimator_u24lambda_u245 = animationBuilder = this;
            boolean bl = false;
            $this$addAnimator_u24lambda_u245.animators.add(v);
            return animationBuilder;
        }

        @NotNull
        public final Animation build() {
            return new SimpleAnimation(new TimeState(this.duration, this.loop, this.direction), this.easingFunction, this.animators);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/animation/Animations$DoubleAnimator;", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animator;", "start", "", "length", "consumer", "Lkotlin/Function1;", "", "(DDLkotlin/jvm/functions/Function1;)V", "doAnimation", "progress", "livemap"})
    public static final class DoubleAnimator
    implements Animator {
        private final double start;
        private final double length;
        @NotNull
        private final Function1<Double, Unit> consumer;

        public DoubleAnimator(double start, double length, @NotNull Function1<? super Double, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.start = start;
            this.length = length;
            this.consumer = consumer;
        }

        @Override
        public void doAnimation(double progress) {
            this.consumer.invoke((Object)(this.start + progress * this.length));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/animation/Animations$DoubleVectorAnimator;", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animator;", "start", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "length", "consumer", "Lkotlin/Function1;", "", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lkotlin/jvm/functions/Function1;)V", "doAnimation", "progress", "", "livemap"})
    public static final class DoubleVectorAnimator
    implements Animator {
        @NotNull
        private final DoubleVector start;
        @NotNull
        private final DoubleVector length;
        @NotNull
        private final Function1<DoubleVector, Unit> consumer;

        public DoubleVectorAnimator(@NotNull DoubleVector start, @NotNull DoubleVector length, @NotNull Function1<? super DoubleVector, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)length, (String)"length");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.start = start;
            this.length = length;
            this.consumer = consumer;
        }

        @Override
        public void doAnimation(double progress) {
            this.consumer.invoke((Object)this.start.add(this.length.mul(progress)));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000eR$\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/animation/Animations$SimpleAnimation;", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animation;", "timeState", "Lorg/jetbrains/letsPlot/livemap/core/animation/TimeState;", "easingFunction", "Lkotlin/Function1;", "", "Lorg/jetbrains/letsPlot/livemap/core/util/EasingFunction;", "animators", "", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animator;", "(Lorg/jetbrains/letsPlot/livemap/core/animation/TimeState;Lkotlin/jvm/functions/Function1;Ljava/util/List;)V", "duration", "getDuration", "()D", "isFinished", "", "()Z", "progress", "getProgress", "time", "getTime", "setTime", "(D)V", "animate", "", "livemap"})
    @SourceDebugExtension(value={"SMAP\nAnimations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animations.kt\norg/jetbrains/letsPlot/livemap/core/animation/Animations$SimpleAnimation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1855#2,2:98\n*S KotlinDebug\n*F\n+ 1 Animations.kt\norg/jetbrains/letsPlot/livemap/core/animation/Animations$SimpleAnimation\n*L\n80#1:98,2\n*E\n"})
    public static final class SimpleAnimation
    implements Animation {
        @NotNull
        private final TimeState timeState;
        @NotNull
        private final Function1<Double, Double> easingFunction;
        @NotNull
        private final List<Animator> animators;
        private double time;

        public SimpleAnimation(@NotNull TimeState timeState, @NotNull Function1<? super Double, Double> easingFunction, @NotNull List<? extends Animator> animators) {
            Intrinsics.checkNotNullParameter((Object)timeState, (String)"timeState");
            Intrinsics.checkNotNullParameter(easingFunction, (String)"easingFunction");
            Intrinsics.checkNotNullParameter(animators, (String)"animators");
            this.timeState = timeState;
            this.easingFunction = easingFunction;
            this.animators = animators;
        }

        @Override
        public boolean isFinished() {
            return this.timeState.isFinished();
        }

        @Override
        public double getDuration() {
            return this.timeState.getDuration();
        }

        @Override
        public double getTime() {
            return this.time;
        }

        @Override
        public void setTime(double time) {
            this.time = this.timeState.calcTime$livemap(time);
        }

        @Override
        public void animate() {
            double progress = this.getProgress();
            Iterable $this$forEach$iv = this.animators;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Animator animator = (Animator)element$iv;
                boolean bl = false;
                animator.doAnimation(progress);
            }
        }

        private final double getProgress() {
            if (this.getDuration() == 0.0) {
                return 1.0;
            }
            double progress = ((Number)this.easingFunction.invoke((Object)(this.getTime() / this.getDuration()))).doubleValue();
            return this.timeState.getDirection() == Animation.Direction.FORWARD ? progress : 1.0 - progress;
        }
    }
}

