/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.animation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.livemap.core.animation.Animation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0015R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/animation/TimeState;", "", "duration", "", "loop", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animation$Loop;", "direction", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animation$Direction;", "(DLorg/jetbrains/letsPlot/livemap/core/animation/Animation$Loop;Lorg/jetbrains/letsPlot/livemap/core/animation/Animation$Direction;)V", "getDirection", "()Lorg/jetbrains/letsPlot/livemap/core/animation/Animation$Direction;", "setDirection", "(Lorg/jetbrains/letsPlot/livemap/core/animation/Animation$Direction;)V", "getDuration", "()D", "<set-?>", "", "isFinished", "()Z", "calcTime", "time", "calcTime$livemap", "livemap"})
public final class TimeState {
    private final double duration;
    @NotNull
    private final Animation.Loop loop;
    @NotNull
    private Animation.Direction direction;
    private boolean isFinished;

    public TimeState(double duration, @NotNull Animation.Loop loop, @NotNull Animation.Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)loop), (String)"loop");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.duration = duration;
        this.loop = loop;
        this.direction = direction;
    }

    public final double getDuration() {
        return this.duration;
    }

    @NotNull
    public final Animation.Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Animation.Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"<set-?>");
        this.direction = direction;
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    public final double calcTime$livemap(double time) {
        double newTime = 0.0;
        if (time > this.duration) {
            if (this.loop == Animation.Loop.DISABLED) {
                newTime = this.duration;
                this.isFinished = true;
            } else {
                newTime = time % this.duration;
                if (this.loop == Animation.Loop.SWITCH_DIRECTION) {
                    int dir = (int)((double)this.direction.ordinal() + time / this.duration) % 2;
                    this.direction = Animation.Direction.values()[dir];
                }
            }
        } else {
            newTime = time;
        }
        return newTime;
    }
}

