/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.ecs;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.livemap.core.animation.Animation;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.AnimationComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.AnimationSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsContext;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000f\u001a\u00020\n*\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/ecs/AnimationSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "updateImpl", "", "context", "dt", "", "updateProgress", "animation", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AnimationComponent;", "updateTime", "progress", "livemap"})
@SourceDebugExtension(value={"SMAP\nAnimationSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationSystem.kt\norg/jetbrains/letsPlot/livemap/core/ecs/AnimationSystem\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,60:1\n24#2,2:61\n*S KotlinDebug\n*F\n+ 1 AnimationSystem.kt\norg/jetbrains/letsPlot/livemap/core/ecs/AnimationSystem\n*L\n50#1:61,2\n*E\n"})
public final class AnimationSystem
extends AbstractSystem<EcsContext> {
    public AnimationSystem(@NotNull EcsComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(componentManager);
    }

    private final void updateProgress(AnimationComponent animation) {
        double d;
        AnimationComponent $this$updateProgress_u24lambda_u240 = animation;
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$updateProgress_u24lambda_u240.getDirection().ordinal()]) {
            case 1: {
                d = this.progress($this$updateProgress_u24lambda_u240);
                break;
            }
            case 2: {
                d = 1.0 - this.progress($this$updateProgress_u24lambda_u240);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$updateProgress_u24lambda_u240.setProgress(d);
    }

    private final double progress(AnimationComponent $this$progress) {
        return ((Number)$this$progress.getEasingFunction().invoke((Object)($this$progress.getTime() / $this$progress.getDuration()))).doubleValue();
    }

    private final void updateTime(AnimationComponent animation, double dt) {
        double newTime = 0.0;
        double time = animation.getTime() + dt;
        double duration = animation.getDuration();
        Animation.Loop loop = animation.getLoop();
        if (time > duration) {
            if (loop == Animation.Loop.DISABLED) {
                newTime = duration;
                animation.setFinished(true);
            } else {
                newTime = time % duration;
                if (loop == Animation.Loop.SWITCH_DIRECTION) {
                    int dir = (int)((double)animation.getDirection().ordinal() + time / duration) % 2;
                    animation.setDirection(Animation.Direction.values()[dir]);
                }
            }
        } else {
            newTime = time;
        }
        animation.setTime(newTime);
    }

    @Override
    protected void updateImpl(@NotNull EcsContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterator iterator = this.getEntities((KClass<EcsComponent>)Reflection.getOrCreateKotlinClass(AnimationComponent.class)).iterator();
        while (iterator.hasNext()) {
            EcsEntity entity2;
            EcsEntity this_$iv = entity2 = (EcsEntity)iterator.next();
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (AnimationComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(AnimationComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(AnimationComponent.class).getSimpleName() + " is not found");
            }
            AnimationComponent animationComponent = (AnimationComponent)ecsComponent;
            this.updateTime(animationComponent, dt);
            this.updateProgress(animationComponent);
            if (!animationComponent.getFinished()) continue;
            this.runLaterBySystem(entity2, (Function1<EcsEntity, Unit>)((Function1)updateImpl.1.INSTANCE));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Animation.Direction.values().length];
            try {
                nArray[Animation.Direction.FORWARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Animation.Direction.BACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

