/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.ecs;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.SystemTime;
import org.jetbrains.letsPlot.commons.event.MouseEventSource;
import org.jetbrains.letsPlot.livemap.core.MetricsService;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsClock;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsContext;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsClock;", "eventSource", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;", "(Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;)V", "getEventSource", "()Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;", "frameDurationMs", "", "getFrameDurationMs", "()J", "frameStartTimeMs", "getFrameStartTimeMs", "setFrameStartTimeMs", "(J)V", "metricsService", "Lorg/jetbrains/letsPlot/livemap/core/MetricsService;", "getMetricsService", "()Lorg/jetbrains/letsPlot/livemap/core/MetricsService;", "systemTime", "Lorg/jetbrains/letsPlot/commons/SystemTime;", "getSystemTime", "()Lorg/jetbrains/letsPlot/commons/SystemTime;", "tick", "getTick", "setTick", "startFrame", "", "startFrame$livemap", "livemap"})
public class EcsContext
implements EcsClock {
    @NotNull
    private final MouseEventSource eventSource;
    @NotNull
    private final SystemTime systemTime;
    private long frameStartTimeMs;
    @NotNull
    private final MetricsService metricsService;
    private long tick;

    public EcsContext(@NotNull MouseEventSource eventSource) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        this.eventSource = eventSource;
        this.systemTime = new SystemTime();
        this.metricsService = new MetricsService(this.getSystemTime());
    }

    @NotNull
    public final MouseEventSource getEventSource() {
        return this.eventSource;
    }

    @Override
    @NotNull
    public SystemTime getSystemTime() {
        return this.systemTime;
    }

    @Override
    public long getFrameStartTimeMs() {
        return this.frameStartTimeMs;
    }

    public void setFrameStartTimeMs(long l) {
        this.frameStartTimeMs = l;
    }

    @Override
    public long getFrameDurationMs() {
        return this.getSystemTime().getTimeMs() - this.getFrameStartTimeMs();
    }

    @NotNull
    public final MetricsService getMetricsService() {
        return this.metricsService;
    }

    public final long getTick() {
        return this.tick;
    }

    public final void setTick(long l) {
        this.tick = l;
    }

    public final void startFrame$livemap() {
        long l = this.tick;
        this.tick = l + 1L;
        this.setFrameStartTimeMs(this.getSystemTime().getTimeMs());
    }
}

