/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.ecs;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.livemap.core.MetricsService;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsContext;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsController;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "myComponentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "myContext", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsContext;", "mySystems", "", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsSystem;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsContext;Ljava/util/List;)V", "myDebugService", "Lorg/jetbrains/letsPlot/livemap/core/MetricsService;", "dispose", "", "update", "dt", "", "livemap"})
@SourceDebugExtension(value={"SMAP\nEcsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcsController.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1855#2,2:39\n1855#2,2:41\n*S KotlinDebug\n*F\n+ 1 EcsController.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsController\n*L\n19#1:39,2\n36#1:41,2\n*E\n"})
public final class EcsController
implements Disposable {
    @NotNull
    private final EcsComponentManager myComponentManager;
    @NotNull
    private final EcsContext myContext;
    @NotNull
    private final List<EcsSystem> mySystems;
    @NotNull
    private final MetricsService myDebugService;

    public EcsController(@NotNull EcsComponentManager myComponentManager, @NotNull EcsContext myContext, @NotNull List<? extends EcsSystem> mySystems) {
        Intrinsics.checkNotNullParameter((Object)myComponentManager, (String)"myComponentManager");
        Intrinsics.checkNotNullParameter((Object)myContext, (String)"myContext");
        Intrinsics.checkNotNullParameter(mySystems, (String)"mySystems");
        this.myComponentManager = myComponentManager;
        this.myContext = myContext;
        this.mySystems = mySystems;
        this.myDebugService = this.myContext.getMetricsService();
        Iterable $this$forEach$iv = this.mySystems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EcsSystem it = (EcsSystem)element$iv;
            boolean bl = false;
            it.init(this.myContext);
        }
    }

    public final void update(double dt) {
        this.myContext.startFrame$livemap();
        this.myDebugService.reset();
        for (EcsSystem system : this.mySystems) {
            this.myDebugService.beginMeasureUpdate();
            system.update(this.myContext, dt);
            this.myDebugService.endMeasureUpdate(system);
        }
        this.myComponentManager.doRemove$livemap();
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.mySystems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EcsSystem p0 = (EcsSystem)element$iv;
            boolean bl = false;
            p0.destroy();
        }
    }
}

