/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.graphics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.core.OpenLinkKt;
import org.jetbrains.letsPlot.livemap.core.graphics.RenderBox;
import org.jetbrains.letsPlot.livemap.core.graphics.Text;
import org.jetbrains.letsPlot.livemap.core.util.Geometries;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 82\u00020\u0001:\u00045678B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0018\u00102\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00103\u001a\u00020\u0001H\u0002J\b\u00104\u001a\u00020/H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R+\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010 \u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\r\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020(8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u00069"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution;", "Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;", "()V", "alignment", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment;", "<set-?>", "Lorg/jetbrains/letsPlot/commons/values/Color;", "background", "getBackground", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "setBackground", "(Lorg/jetbrains/letsPlot/commons/values/Color;)V", "background$delegate", "Lkotlin/properties/ReadWriteProperty;", "clickHandler", "", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "value", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$HorizontalAlignment;", "horizontalAlignment", "getHorizontalAlignment", "()Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$HorizontalAlignment;", "setHorizontalAlignment", "(Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$HorizontalAlignment;)V", "", "padding", "getPadding", "()D", "setPadding", "(D)V", "padding$delegate", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "text$delegate", "texts", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Text;", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$VerticalAlignment;", "verticalAlignment", "getVerticalAlignment", "()Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$VerticalAlignment;", "setVerticalAlignment", "(Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$VerticalAlignment;)V", "renderInternal", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "renderPrimitive", "primitive", "updateState", "Alignment", "AttributionParser", "AttributionParts", "Companion", "livemap"})
@SourceDebugExtension(value={"SMAP\nAttribution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Attribution.kt\norg/jetbrains/letsPlot/livemap/core/graphics/Attribution\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n2634#2:200\n1855#2,2:202\n1855#2,2:204\n1855#2,2:206\n1855#2,2:208\n1#3:201\n*S KotlinDebug\n*F\n+ 1 Attribution.kt\norg/jetbrains/letsPlot/livemap/core/graphics/Attribution\n*L\n42#1:200\n44#1:202,2\n67#1:204,2\n84#1:206,2\n102#1:208,2\n42#1:201\n*E\n"})
public final class Attribution
extends RenderBox {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final List<Text> texts = new ArrayList();
    @NotNull
    private final List<Registration> clickHandler = new ArrayList();
    @NotNull
    private final Alignment alignment = new Alignment();
    @NotNull
    private final ReadWriteProperty text$delegate = RenderBox.visualProp$default(this, this, "", null, 2, null);
    @NotNull
    private final ReadWriteProperty padding$delegate = RenderBox.visualProp$default(this, this, 0.0, null, 2, null);
    @NotNull
    private final ReadWriteProperty background$delegate = RenderBox.visualProp$default(this, this, Color.Companion.getTRANSPARENT(), null, 2, null);
    @NotNull
    private static final String CONTRIBUTORS_FONT_FAMILY = "-apple-system, BlinkMacSystemFont, \"Segoe UI\", Helvetica, Arial, sans-serif, \"Apple Color Emoji\", \"Segoe UI Emoji\", \"Segoe UI Symbol\"";

    @NotNull
    public final String getText() {
        return (String)this.text$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    public final double getPadding() {
        return ((Number)this.padding$delegate.getValue((Object)this, $$delegatedProperties[1])).doubleValue();
    }

    public final void setPadding(double d) {
        this.padding$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)d);
    }

    @NotNull
    public final Color getBackground() {
        return (Color)this.background$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.background$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)color);
    }

    @NotNull
    public final Alignment.HorizontalAlignment getHorizontalAlignment() {
        return this.alignment.getHorizontal();
    }

    public final void setHorizontalAlignment(@NotNull Alignment.HorizontalAlignment value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.alignment.setHorizontal(value);
        this.setDirty(true);
    }

    @NotNull
    public final Alignment.VerticalAlignment getVerticalAlignment() {
        return this.alignment.getVertical();
    }

    public final void setVerticalAlignment(@NotNull Alignment.VerticalAlignment value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.alignment.setVertical(value);
        this.setDirty(true);
    }

    @Override
    protected void updateState() {
        Iterable $this$onEach$iv = this.clickHandler;
        boolean $i$f$onEach = false;
        Iterator iterator = $this$onEach$iv;
        Iterable $this$onEach_u24lambda_u2416$iv = iterator;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Registration p0 = (Registration)element$iv;
            boolean bl2 = false;
            p0.remove();
        }
        ((List)((Object)iterator)).clear();
        Iterable $this$forEach$iv = AttributionParser.INSTANCE.parse(this.getText());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AttributionParts part = (AttributionParts)element$iv;
            boolean bl3 = false;
            Color c = part instanceof AttributionParts.SimpleLink ? new Color(26, 13, 171, 0, 8, null) : Color.Companion.getBLACK();
            Text attributionText = new Text();
            attributionText.attach(this.getGraphics());
            this.setState((RenderBox)attributionText, (Function1)new Function1<Text, Unit>(c, part){
                final /* synthetic */ Color $c;
                final /* synthetic */ AttributionParts $part;
                {
                    this.$c = $c;
                    this.$part = $part;
                    super(1);
                }

                public final void invoke(@NotNull Text $this$setState) {
                    Intrinsics.checkNotNullParameter((Object)$this$setState, (String)"$this$setState");
                    $this$setState.setColor(this.$c);
                    $this$setState.setFontFamily("-apple-system, BlinkMacSystemFont, \"Segoe UI\", Helvetica, Arial, sans-serif, \"Apple Color Emoji\", \"Segoe UI Emoji\", \"Segoe UI Symbol\"");
                    $this$setState.setFontSize(11.0);
                    $this$setState.setText(CollectionsKt.listOf((Object)this.$part.getText()));
                }
            });
            if (part instanceof AttributionParts.SimpleLink) {
                ((Collection)this.clickHandler).add(this.getGraphics().onClick(attributionText, (Function0<Unit>)((Function0)new Function0<Unit>(part){
                    final /* synthetic */ AttributionParts $part;
                    {
                        this.$part = $part;
                        super(0);
                    }

                    public final void invoke() {
                        OpenLinkKt.openLink(((AttributionParts.SimpleLink)this.$part).getHref());
                    }
                })));
            }
            this.texts.add(attributionText);
        }
        $this$forEach$iv = this.texts;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Text it = (Text)element$iv;
            boolean bl4 = false;
            DoubleVector dim = it.getDimension();
            it.setOrigin(new DoubleVector(this.getDimension().getX() + this.getPadding(), this.getPadding()));
            this.setDimension(new DoubleVector(this.getDimension().getX() + dim.getX(), Math.max(this.getDimension().getY(), dim.getY())));
        }
        this.setDimension(this.getDimension().add(new DoubleVector(this.getPadding() * (double)2, this.getPadding() * (double)2)));
        this.setOrigin(this.alignment.calculatePosition(this.getOrigin(), this.getDimension()));
        $this$forEach$iv = this.texts;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Text it = (Text)element$iv;
            boolean bl5 = false;
            it.setOrigin(Geometries.INSTANCE.plus(it.getOrigin(), this.getOrigin()));
        }
    }

    @Override
    protected void renderInternal(@NotNull Context2d ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ctx.save();
        ctx.setFillStyle(this.getBackground());
        ctx.fillRect(this.getOrigin().getX(), this.getOrigin().getY(), this.getDimension().getX(), this.getDimension().getY());
        ctx.restore();
        Iterable $this$forEach$iv = this.texts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Text it = (Text)element$iv;
            boolean bl = false;
            this.renderPrimitive(ctx, it);
        }
    }

    private final void renderPrimitive(Context2d ctx, RenderBox primitive) {
        ctx.save();
        DoubleVector origin = primitive.getOrigin();
        ctx.setTransform(1.0, 0.0, 0.0, 1.0, origin.getX(), origin.getY());
        primitive.render(ctx);
        ctx.restore();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Attribution.class, "text", "getText()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Attribution.class, "padding", "getPadding()D", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Attribution.class, "background", "getBackground()Lorg/jetbrains/letsPlot/commons/values/Color;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment;", "", "()V", "horizontal", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$HorizontalAlignment;", "getHorizontal", "()Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$HorizontalAlignment;", "setHorizontal", "(Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$HorizontalAlignment;)V", "vertical", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$VerticalAlignment;", "getVertical", "()Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$VerticalAlignment;", "setVertical", "(Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$VerticalAlignment;)V", "calculatePosition", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "origin", "dimension", "HorizontalAlignment", "VerticalAlignment", "livemap"})
    public static final class Alignment {
        @NotNull
        private HorizontalAlignment horizontal = HorizontalAlignment.RIGHT;
        @NotNull
        private VerticalAlignment vertical = VerticalAlignment.TOP;

        @NotNull
        public final HorizontalAlignment getHorizontal() {
            return this.horizontal;
        }

        public final void setHorizontal(@NotNull HorizontalAlignment horizontalAlignment) {
            Intrinsics.checkNotNullParameter((Object)((Object)horizontalAlignment), (String)"<set-?>");
            this.horizontal = horizontalAlignment;
        }

        @NotNull
        public final VerticalAlignment getVertical() {
            return this.vertical;
        }

        public final void setVertical(@NotNull VerticalAlignment verticalAlignment) {
            Intrinsics.checkNotNullParameter((Object)((Object)verticalAlignment), (String)"<set-?>");
            this.vertical = verticalAlignment;
        }

        @NotNull
        public final DoubleVector calculatePosition(@NotNull DoubleVector origin, @NotNull DoubleVector dimension) {
            double d;
            double d2;
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            switch (WhenMappings.$EnumSwitchMapping$0[this.horizontal.ordinal()]) {
                case 1: {
                    d2 = -dimension.getX();
                    break;
                }
                case 2: {
                    d2 = -dimension.getX() / (double)2;
                    break;
                }
                case 3: {
                    d2 = 0.0;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double horizontalShift = d2;
            switch (WhenMappings.$EnumSwitchMapping$1[this.vertical.ordinal()]) {
                case 1: {
                    d = 0.0;
                    break;
                }
                case 2: {
                    d = -dimension.getY() / (double)2;
                    break;
                }
                case 3: {
                    d = -dimension.getY();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double verticalShift = d;
            return Geometries.INSTANCE.plus(origin, new DoubleVector(horizontalShift, verticalShift));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$HorizontalAlignment;", "", "(Ljava/lang/String;I)V", "RIGHT", "CENTER", "LEFT", "livemap"})
        public static final class HorizontalAlignment
        extends Enum<HorizontalAlignment> {
            public static final /* enum */ HorizontalAlignment RIGHT = new HorizontalAlignment();
            public static final /* enum */ HorizontalAlignment CENTER = new HorizontalAlignment();
            public static final /* enum */ HorizontalAlignment LEFT = new HorizontalAlignment();
            private static final /* synthetic */ HorizontalAlignment[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static HorizontalAlignment[] values() {
                return (HorizontalAlignment[])$VALUES.clone();
            }

            public static HorizontalAlignment valueOf(String value) {
                return Enum.valueOf(HorizontalAlignment.class, value);
            }

            @NotNull
            public static EnumEntries<HorizontalAlignment> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = horizontalAlignmentArray = new HorizontalAlignment[]{HorizontalAlignment.RIGHT, HorizontalAlignment.CENTER, HorizontalAlignment.LEFT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Alignment$VerticalAlignment;", "", "(Ljava/lang/String;I)V", "TOP", "CENTER", "BOTTOM", "livemap"})
        public static final class VerticalAlignment
        extends Enum<VerticalAlignment> {
            public static final /* enum */ VerticalAlignment TOP = new VerticalAlignment();
            public static final /* enum */ VerticalAlignment CENTER = new VerticalAlignment();
            public static final /* enum */ VerticalAlignment BOTTOM = new VerticalAlignment();
            private static final /* synthetic */ VerticalAlignment[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static VerticalAlignment[] values() {
                return (VerticalAlignment[])$VALUES.clone();
            }

            public static VerticalAlignment valueOf(String value) {
                return Enum.valueOf(VerticalAlignment.class, value);
            }

            @NotNull
            public static EnumEntries<VerticalAlignment> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = verticalAlignmentArray = new VerticalAlignment[]{VerticalAlignment.TOP, VerticalAlignment.CENTER, VerticalAlignment.BOTTOM};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[HorizontalAlignment.values().length];
                try {
                    nArray[HorizontalAlignment.LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HorizontalAlignment.CENTER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HorizontalAlignment.RIGHT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[VerticalAlignment.values().length];
                try {
                    nArray[VerticalAlignment.TOP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerticalAlignment.CENTER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerticalAlignment.BOTTOM.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$AttributionParser;", "", "()V", "linkRegex", "Lkotlin/text/Regex;", "regex", "parse", "", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$AttributionParts;", "rawAttribution", "", "parseLink", "link", "livemap"})
    public static final class AttributionParser {
        @NotNull
        public static final AttributionParser INSTANCE = new AttributionParser();
        @NotNull
        private static final Regex regex = new Regex("(<a[^>]*>[^<]*<\\/a>|[^<]*)");
        @NotNull
        private static final Regex linkRegex = new Regex("href=\"([^\"]*)\"[^>]*>([^<]*)<\\/a>");

        private AttributionParser() {
        }

        @NotNull
        public final List<AttributionParts> parse(@NotNull String rawAttribution) {
            ArrayList<AttributionParts> arrayList;
            Intrinsics.checkNotNullParameter((Object)rawAttribution, (String)"rawAttribution");
            ArrayList<AttributionParts> $this$parse_u24lambda_u240 = arrayList = new ArrayList<AttributionParts>();
            boolean bl = false;
            for (MatchResult result = Regex.find$default((Regex)regex, (CharSequence)rawAttribution, (int)0, (int)2, null); result != null; result = result.next()) {
                if (!(((CharSequence)result.getValue()).length() > 0)) continue;
                AttributionParts part = StringsKt.startsWith$default((String)result.getValue(), (String)"<a", (boolean)false, (int)2, null) ? INSTANCE.parseLink(result.getValue()) : (AttributionParts)new AttributionParts.SimpleText(result.getValue());
                $this$parse_u24lambda_u240.add(part);
            }
            return arrayList;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final AttributionParts parseLink(String link) {
            AttributionParts attributionParts;
            MatchResult result = Regex.find$default((Regex)linkRegex, (CharSequence)link, (int)0, (int)2, null);
            Object object = result;
            if (object != null && (object = object.getDestructured()) != null) {
                MatchResult it = object;
                boolean bl = false;
                String href = (String)it.getMatch().getGroupValues().get(1);
                String text = (String)it.getMatch().getGroupValues().get(2);
                AttributionParts.SimpleLink simpleLink = ((CharSequence)href).length() == 0 ? null : new AttributionParts.SimpleLink(href, text);
                object = simpleLink;
                if (simpleLink != null) {
                    attributionParts = (AttributionParts)object;
                    return attributionParts;
                }
            }
            attributionParts = new AttributionParts.SimpleText(link);
            return attributionParts;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$AttributionParts;", "", "text", "", "getText", "()Ljava/lang/String;", "SimpleLink", "SimpleText", "livemap"})
    public static interface AttributionParts {
        @NotNull
        public String getText();

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$AttributionParts$SimpleLink;", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$AttributionParts;", "href", "", "text", "(Ljava/lang/String;Ljava/lang/String;)V", "getHref", "()Ljava/lang/String;", "getText", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "livemap"})
        public static final class SimpleLink
        implements AttributionParts {
            @NotNull
            private final String href;
            @NotNull
            private final String text;

            public SimpleLink(@NotNull String href, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)href, (String)"href");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.href = href;
                this.text = text;
            }

            @NotNull
            public final String getHref() {
                return this.href;
            }

            @Override
            @NotNull
            public String getText() {
                return this.text;
            }

            @NotNull
            public final String component1() {
                return this.href;
            }

            @NotNull
            public final String component2() {
                return this.text;
            }

            @NotNull
            public final SimpleLink copy(@NotNull String href, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)href, (String)"href");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return new SimpleLink(href, text);
            }

            public static /* synthetic */ SimpleLink copy$default(SimpleLink simpleLink, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = simpleLink.href;
                }
                if ((n & 2) != 0) {
                    string2 = simpleLink.text;
                }
                return simpleLink.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "SimpleLink(href=" + this.href + ", text=" + this.text + ')';
            }

            public int hashCode() {
                int result = this.href.hashCode();
                result = result * 31 + this.text.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SimpleLink)) {
                    return false;
                }
                SimpleLink simpleLink = (SimpleLink)other;
                if (!Intrinsics.areEqual((Object)this.href, (Object)simpleLink.href)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.text, (Object)simpleLink.text);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$AttributionParts$SimpleText;", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$AttributionParts;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "livemap"})
        public static final class SimpleText
        implements AttributionParts {
            @NotNull
            private final String text;

            public SimpleText(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.text = text;
            }

            @Override
            @NotNull
            public String getText() {
                return this.text;
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final SimpleText copy(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return new SimpleText(text);
            }

            public static /* synthetic */ SimpleText copy$default(SimpleText simpleText, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = simpleText.text;
                }
                return simpleText.copy(string);
            }

            @NotNull
            public String toString() {
                return "SimpleText(text=" + this.text + ')';
            }

            public int hashCode() {
                return this.text.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SimpleText)) {
                    return false;
                }
                SimpleText simpleText = (SimpleText)other;
                return Intrinsics.areEqual((Object)this.text, (Object)simpleText.text);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution$Companion;", "", "()V", "CONTRIBUTORS_FONT_FAMILY", "", "livemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

