/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.graphics;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.core.graphics.Frame;
import org.jetbrains.letsPlot.livemap.core.graphics.Rectangle;
import org.jetbrains.letsPlot.livemap.core.graphics.RenderBox;
import org.jetbrains.letsPlot.livemap.core.input.CursorStyle;
import org.jetbrains.letsPlot.livemap.core.input.InputMouseEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001eJ\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001eJ\b\u0010*\u001a\u00020\u001fH\u0014J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u00020\u001fH\u0014R/\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R/\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\f\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R(\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Button;", "Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;", "name", "", "(Ljava/lang/String;)V", "<set-?>", "disabledVisual", "getDisabledVisual", "()Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;", "setDisabledVisual", "(Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;)V", "disabledVisual$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "enabled$delegate", "enabledVisual", "getEnabledVisual", "setEnabledVisual", "enabledVisual$delegate", "frame", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Frame;", "getName", "()Ljava/lang/String;", "onClick", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/livemap/core/input/InputMouseEvent;", "", "getOnClick", "()Lkotlin/jvm/functions/Function1;", "setOnClick", "(Lkotlin/jvm/functions/Function1;)V", "onDoubleClick", "getOnDoubleClick", "setOnDoubleClick", "dispatchClick", "e", "dispatchDoubleClick", "onAttach", "renderInternal", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "updateState", "livemap"})
public final class Button
extends RenderBox {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String name;
    @NotNull
    private final Frame frame;
    @NotNull
    private final ReadWriteProperty enabledVisual$delegate;
    @NotNull
    private final ReadWriteProperty disabledVisual$delegate;
    @NotNull
    private final ReadWriteProperty enabled$delegate;
    @Nullable
    private Function1<? super InputMouseEvent, Unit> onClick;
    @Nullable
    private Function1<? super InputMouseEvent, Unit> onDoubleClick;

    public Button(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.frame = new Frame();
        this.enabledVisual$delegate = RenderBox.visualProp$default(this, this, null, null, 2, null);
        this.disabledVisual$delegate = RenderBox.visualProp$default(this, this, null, null, 2, null);
        this.enabled$delegate = this.visualProp(this, true, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ Button this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean newValue) {
                if (newValue) {
                    this.this$0.getGraphics().setCursor(this.this$0, CursorStyle.POINTER);
                } else {
                    this.this$0.getGraphics().defaultCursor(this.this$0);
                }
            }
        });
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final RenderBox getEnabledVisual() {
        return (RenderBox)this.enabledVisual$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setEnabledVisual(@Nullable RenderBox renderBox) {
        this.enabledVisual$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)renderBox);
    }

    @Nullable
    public final RenderBox getDisabledVisual() {
        return (RenderBox)this.disabledVisual$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setDisabledVisual(@Nullable RenderBox renderBox) {
        this.disabledVisual$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)renderBox);
    }

    public final boolean getEnabled() {
        return (Boolean)this.enabled$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setEnabled(boolean bl) {
        this.enabled$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
    }

    @Nullable
    public final Function1<InputMouseEvent, Unit> getOnClick() {
        return this.onClick;
    }

    public final void setOnClick(@Nullable Function1<? super InputMouseEvent, Unit> function1) {
        this.onClick = function1;
    }

    @Nullable
    public final Function1<InputMouseEvent, Unit> getOnDoubleClick() {
        return this.onDoubleClick;
    }

    public final void setOnDoubleClick(@Nullable Function1<? super InputMouseEvent, Unit> function1) {
        this.onDoubleClick = function1;
    }

    public final void dispatchClick(@NotNull InputMouseEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.getEnabled()) break block1;
            Function1<? super InputMouseEvent, Unit> function1 = this.onClick;
            if (function1 != null) {
                function1.invoke((Object)e);
            }
        }
    }

    public final void dispatchDoubleClick(@NotNull InputMouseEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.getEnabled()) break block1;
            Function1<? super InputMouseEvent, Unit> function1 = this.onDoubleClick;
            if (function1 != null) {
                function1.invoke((Object)e);
            }
        }
    }

    @Override
    protected void onAttach() {
        this.frame.attach(this.getGraphics());
    }

    @Override
    protected void updateState() {
        RenderBox renderBox;
        this.frame.setOrigin(this.getOrigin());
        boolean bl = this.getEnabled();
        if (bl) {
            renderBox = this.getEnabledVisual();
            if (renderBox == null) {
                renderBox = Button.updateState$blankRect(Color.Companion.getLIGHT_GRAY());
            }
        } else if (!bl) {
            renderBox = this.getDisabledVisual();
            if (renderBox == null) {
                renderBox = Button.updateState$blankRect(Color.Companion.getGRAY());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.frame.setChildren(CollectionsKt.listOf((Object)renderBox));
    }

    @Override
    protected void renderInternal(@NotNull Context2d ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.frame.render(ctx);
    }

    private static final Rectangle updateState$blankRect(Color fill) {
        Rectangle rectangle;
        Rectangle $this$updateState_u24blankRect_u24lambda_u240 = rectangle = new Rectangle();
        boolean bl = false;
        $this$updateState_u24blankRect_u24lambda_u240.setOrigin(DoubleVector.Companion.getZERO());
        $this$updateState_u24blankRect_u24lambda_u240.setDimension($this$updateState_u24blankRect_u24lambda_u240.getDimension());
        $this$updateState_u24blankRect_u24lambda_u240.setColor(fill);
        return rectangle;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Button.class, "enabledVisual", "getEnabledVisual()Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Button.class, "disabledVisual", "getDisabledVisual()Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Button.class, "enabled", "getEnabled()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

