/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.graphics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.core.graphics.RenderBox;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R7\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/Frame;", "Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;", "()V", "<set-?>", "", "children", "getChildren", "()Ljava/util/List;", "setChildren", "(Ljava/util/List;)V", "children$delegate", "Lkotlin/properties/ReadWriteProperty;", "<anonymous parameter 0>", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "dimension", "getDimension", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "setDimension", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "calculateDimension", "getBottom", "", "renderObject", "getRight", "renderInternal", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "livemap"})
@SourceDebugExtension(value={"SMAP\nFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Frame.kt\norg/jetbrains/letsPlot/livemap/core/graphics/Frame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1855#2,2:52\n*S KotlinDebug\n*F\n+ 1 Frame.kt\norg/jetbrains/letsPlot/livemap/core/graphics/Frame\n*L\n22#1:52,2\n*E\n"})
public final class Frame
extends RenderBox {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadWriteProperty children$delegate = RenderBox.visualProp$default(this, this, CollectionsKt.emptyList(), null, 2, null);

    @NotNull
    public final List<RenderBox> getChildren() {
        return (List)this.children$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setChildren(@NotNull List<? extends RenderBox> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.children$delegate.setValue((Object)this, $$delegatedProperties[0], list);
    }

    @Override
    @NotNull
    public DoubleVector getDimension() {
        return this.calculateDimension();
    }

    @Override
    public void setDimension(@NotNull DoubleVector doubleVector) {
        Intrinsics.checkNotNullParameter((Object)doubleVector, (String)"<anonymous parameter 0>");
        throw new IllegalStateException("Frame calculates size automatically");
    }

    @Override
    protected void renderInternal(@NotNull Context2d ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$forEach$iv = this.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderBox primitive = (RenderBox)element$iv;
            boolean bl = false;
            ctx.save();
            DoubleVector origin = primitive.getOrigin();
            ctx.translate(origin.getX(), origin.getY());
            primitive.render(ctx);
            ctx.restore();
        }
    }

    private final DoubleVector calculateDimension() {
        double right = this.getRight(this.getChildren().get(0));
        double bottom = this.getBottom(this.getChildren().get(0));
        for (RenderBox renderBox : this.getChildren()) {
            right = Math.max(right, this.getRight(renderBox));
            bottom = Math.max(bottom, this.getBottom(renderBox));
        }
        return new DoubleVector(right, bottom);
    }

    private final double getRight(RenderBox renderObject) {
        return renderObject.getOrigin().getX() + this.getChildren().get(0).getDimension().getX();
    }

    private final double getBottom(RenderBox renderObject) {
        return renderObject.getOrigin().getY() + this.getChildren().get(0).getDimension().getY();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Frame.class, "children", "getChildren()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

