/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.graphics;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ$\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/graphics/TextMeasurer;", "", "myContext2d", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "(Lorg/jetbrains/letsPlot/core/canvas/Context2d;)V", "measure", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "label", "", "font", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "", "lineHeight", "", "livemap"})
@SourceDebugExtension(value={"SMAP\nTextMeasurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMeasurer.kt\norg/jetbrains/letsPlot/livemap/core/graphics/TextMeasurer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public final class TextMeasurer {
    @NotNull
    private final Context2d myContext2d;

    public TextMeasurer(@NotNull Context2d myContext2d) {
        Intrinsics.checkNotNullParameter((Object)myContext2d, (String)"myContext2d");
        this.myContext2d = myContext2d;
    }

    @NotNull
    public final DoubleVector measure(@NotNull String label, @NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.myContext2d.save();
        this.myContext2d.setFont(font);
        double width = this.myContext2d.measureTextWidth(label);
        this.myContext2d.restore();
        return new DoubleVector(width, font.getFontSize());
    }

    @NotNull
    public final DoubleVector measure(@NotNull List<String> label, @NotNull Font font, double lineHeight) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.myContext2d.save();
        this.myContext2d.setFont(font);
        Iterable iterable = label;
        Context2d context2d = this.myContext2d;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String p0 = (String)iterator.next();
        boolean bl = false;
        double d = context2d.measureTextWidth(p0);
        while (iterator.hasNext()) {
            String p02 = (String)iterator.next();
            $i$a$-maxOf-TextMeasurer$measure$width$1 = false;
            double d2 = context2d.measureTextWidth(p02);
            d = Math.max(d, d2);
        }
        double width = d;
        this.myContext2d.restore();
        double height = lineHeight * (double)(label.size() - 1) + font.getFontSize();
        return new DoubleVector(width, height);
    }
}

