/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsContext;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.input.ClickableComponent;
import org.jetbrains.letsPlot.livemap.core.input.ClickableComponentKt;
import org.jetbrains.letsPlot.livemap.core.input.EventListenerComponent;
import org.jetbrains.letsPlot.livemap.core.input.InputMouseEvent;
import org.jetbrains.letsPlot.livemap.core.input.MouseEventType;
import org.jetbrains.letsPlot.livemap.core.input.MouseInputComponent;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayer;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayerComponent;
import org.jetbrains.letsPlot.livemap.core.layers.LayerManager;
import org.jetbrains.letsPlot.livemap.core.layers.ParentLayerComponent;
import org.jetbrains.letsPlot.livemap.mapengine.camera.CameraComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputDetectionSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "layerManager", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;)V", "myInteractiveEntityView", "Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputDetectionSystem$InteractiveEntityView;", "acceptListeners", "", "eventType", "Lorg/jetbrains/letsPlot/livemap/core/input/MouseEventType;", "entities", "Ljava/util/ArrayList;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "Lkotlin/collections/ArrayList;", "getZIndex", "", "entity", "canvasLayers", "", "Lorg/jetbrains/letsPlot/livemap/core/layers/CanvasLayer;", "updateImpl", "context", "dt", "", "Companion", "InteractiveEntityView", "livemap"})
@SourceDebugExtension(value={"SMAP\nMouseInputDetectionSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseInputDetectionSystem.kt\norg/jetbrains/letsPlot/livemap/core/input/MouseInputDetectionSystem\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,115:1\n1313#2:116\n1314#2:126\n13309#3:117\n13310#3:125\n372#4,7:118\n1#5:127\n1855#6:128\n1856#6:135\n68#7:129\n24#7,2:130\n68#7:132\n24#7,2:133\n69#7:136\n24#7,2:137\n24#7,2:139\n*S KotlinDebug\n*F\n+ 1 MouseInputDetectionSystem.kt\norg/jetbrains/letsPlot/livemap/core/input/MouseInputDetectionSystem\n*L\n29#1:116\n29#1:126\n32#1:117\n32#1:125\n36#1:118,7\n53#1:128\n53#1:135\n54#1:129\n54#1:130,2\n55#1:132\n55#1:133,2\n68#1:136\n71#1:137,2\n72#1:139,2\n*E\n"})
public final class MouseInputDetectionSystem
extends AbstractSystem<EcsContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LayerManager layerManager;
    @NotNull
    private final InteractiveEntityView myInteractiveEntityView;
    @NotNull
    private static final List<KClass<? extends EcsComponent>> COMPONENTS;

    public MouseInputDetectionSystem(@NotNull EcsComponentManager componentManager, @NotNull LayerManager layerManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)layerManager, (String)"layerManager");
        super(componentManager);
        this.layerManager = layerManager;
        this.myInteractiveEntityView = new InteractiveEntityView();
    }

    @Override
    protected void updateImpl(@NotNull EcsContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HashMap entitiesByEventTypeAndZIndex = new HashMap();
        List<CanvasLayer> canvasLayers = this.layerManager.getLayers();
        Sequence<EcsEntity> $this$forEach$iv = this.getEntities(COMPONENTS);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EcsEntity entity2 = (EcsEntity)element$iv;
            boolean bl = false;
            this.myInteractiveEntityView.setEntity$livemap(entity2);
            MouseEventType[] $this$forEach$iv2 = MouseEventType.values();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                MouseEventType element$iv2;
                MouseEventType type = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (!this.myInteractiveEntityView.needToAdd(type)) continue;
                InteractiveEntityView interactiveEntityView = this.myInteractiveEntityView;
                Map $this$getOrPut$iv = entitiesByEventTypeAndZIndex;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get((Object)type);
                if (value$iv == null) {
                    InteractiveEntityView interactiveEntityView2 = interactiveEntityView;
                    boolean bl3 = false;
                    interactiveEntityView = interactiveEntityView2;
                    HashMap answer$iv = new HashMap();
                    $this$getOrPut$iv.put(type, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                interactiveEntityView.addTo((HashMap)object, this.getZIndex(entity2, canvasLayers));
            }
        }
        for (MouseEventType type : MouseEventType.values()) {
            if ((HashMap)entitiesByEventTypeAndZIndex.get((Object)type) == null) continue;
            for (int i = canvasLayers.size(); -1 < i; --i) {
                ArrayList it;
                HashMap entitiesByZIndex;
                if ((ArrayList)entitiesByZIndex.get(i) == null) continue;
                boolean bl = false;
                this.acceptListeners(type, it);
            }
        }
    }

    private final void acceptListeners(MouseEventType eventType, ArrayList<EcsEntity> entities) {
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InputMouseEvent it;
            EcsEntity entity2 = (EcsEntity)element$iv;
            boolean bl = false;
            EcsEntity this_$iv = entity2;
            boolean $i$f$getComponent = false;
            EcsEntity this_$iv$iv = this_$iv;
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (MouseInputComponent)this_$iv$iv.getComponentManager().getComponents(this_$iv$iv).get(Reflection.getOrCreateKotlinClass(MouseInputComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(MouseInputComponent.class).getSimpleName() + " is not found");
            }
            MouseInputComponent input = (MouseInputComponent)ecsComponent;
            EcsEntity this_$iv2 = entity2;
            boolean $i$f$getComponent2 = false;
            EcsEntity this_$iv$iv2 = this_$iv2;
            boolean $i$f$get2 = false;
            EcsComponent ecsComponent2 = (EventListenerComponent)this_$iv$iv2.getComponentManager().getComponents(this_$iv$iv2).get(Reflection.getOrCreateKotlinClass(EventListenerComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(EventListenerComponent.class).getSimpleName() + " is not found");
            }
            EventListenerComponent listeners = (EventListenerComponent)ecsComponent2;
            if (input.getEvent(eventType) == null) continue;
            boolean bl2 = false;
            if (it.isStopped()) continue;
            for (Function1<InputMouseEvent, Unit> listener : listeners.getListeners$livemap(eventType)) {
                listener.invoke((Object)it);
            }
        }
    }

    private final int getZIndex(EcsEntity entity2, List<CanvasLayer> canvasLayers) {
        int n;
        EcsEntity this_$iv = entity2;
        boolean $i$f$contains = false;
        if (this_$iv.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(CameraComponent.class))) {
            n = 0;
        } else {
            EcsEntity this_$iv2 = entity2;
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (ParentLayerComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(ParentLayerComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ParentLayerComponent.class).getSimpleName() + " is not found");
            }
            this_$iv2 = entity2.getComponentManager().getEntityById(((ParentLayerComponent)ecsComponent).getLayerId());
            $i$f$get = false;
            EcsComponent ecsComponent2 = (CanvasLayerComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class).getSimpleName() + " is not found");
            }
            CanvasLayer canvasLayer = ((CanvasLayerComponent)ecsComponent2).getCanvasLayer();
            n = canvasLayers.indexOf(canvasLayer) + 1;
        }
        return n;
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(MouseInputComponent.class), Reflection.getOrCreateKotlinClass(ClickableComponent.class), Reflection.getOrCreateKotlinClass(EventListenerComponent.class)};
        COMPONENTS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputDetectionSystem$Companion;", "", "()V", "COMPONENTS", "", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponent;", "livemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u000b\u001a\u00020\f28\u0010\r\u001a4\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00100\u000ej\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0010j\b\u0012\u0004\u0012\u00020\u0006`\u0012`\u00112\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0015\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputDetectionSystem$InteractiveEntityView;", "", "()V", "myClickable", "Lorg/jetbrains/letsPlot/livemap/core/input/ClickableComponent;", "myEntity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "myInput", "Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputComponent;", "myListeners", "Lorg/jetbrains/letsPlot/livemap/core/input/EventListenerComponent;", "addTo", "", "map", "Ljava/util/HashMap;", "", "Ljava/util/ArrayList;", "Lkotlin/collections/HashMap;", "Lkotlin/collections/ArrayList;", "zIndex", "needToAdd", "", "type", "Lorg/jetbrains/letsPlot/livemap/core/input/MouseEventType;", "setEntity", "entity", "setEntity$livemap", "livemap"})
    @SourceDebugExtension(value={"SMAP\nMouseInputDetectionSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseInputDetectionSystem.kt\norg/jetbrains/letsPlot/livemap/core/input/MouseInputDetectionSystem$InteractiveEntityView\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,115:1\n24#2,2:116\n24#2,2:118\n24#2,2:120\n372#3,7:122\n*S KotlinDebug\n*F\n+ 1 MouseInputDetectionSystem.kt\norg/jetbrains/letsPlot/livemap/core/input/MouseInputDetectionSystem$InteractiveEntityView\n*L\n88#1:116,2\n89#1:118,2\n90#1:120,2\n104#1:122,7\n*E\n"})
    private static final class InteractiveEntityView {
        private MouseInputComponent myInput;
        private ClickableComponent myClickable;
        private EventListenerComponent myListeners;
        private EcsEntity myEntity;

        public final void setEntity$livemap(@NotNull EcsEntity entity2) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            this.myEntity = entity2;
            EcsEntity this_$iv = entity2;
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (MouseInputComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(MouseInputComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(MouseInputComponent.class).getSimpleName() + " is not found");
            }
            this.myInput = (MouseInputComponent)ecsComponent;
            this_$iv = entity2;
            $i$f$get = false;
            EcsComponent ecsComponent2 = (ClickableComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(ClickableComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ClickableComponent.class).getSimpleName() + " is not found");
            }
            this.myClickable = (ClickableComponent)ecsComponent2;
            this_$iv = entity2;
            $i$f$get = false;
            EcsComponent ecsComponent3 = (EventListenerComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(EventListenerComponent.class));
            if (ecsComponent3 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(EventListenerComponent.class).getSimpleName() + " is not found");
            }
            this.myListeners = (EventListenerComponent)ecsComponent3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean needToAdd(@NotNull MouseEventType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            MouseInputComponent mouseInputComponent = this.myInput;
            if (mouseInputComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myInput");
                mouseInputComponent = null;
            }
            InputMouseEvent it = mouseInputComponent.getEvent(type);
            boolean bl = false;
            if (it == null) return false;
            EventListenerComponent eventListenerComponent = this.myListeners;
            if (eventListenerComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myListeners");
                eventListenerComponent = null;
            }
            if (!eventListenerComponent.contains(type)) return false;
            Vector vector2 = it.getLocation();
            ClickableComponent clickableComponent = this.myClickable;
            if (clickableComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myClickable");
                clickableComponent = null;
            }
            if (!ClickableComponentKt.inside(vector2, clickableComponent)) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final void addTo(@NotNull HashMap<Integer, ArrayList<EcsEntity>> map2, int zIndex) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            Map map3 = map2;
            Integer key$iv = zIndex;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ArrayList answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ArrayList arrayList = (ArrayList)object;
            EcsEntity ecsEntity = this.myEntity;
            if (ecsEntity == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myEntity");
                ecsEntity = null;
            }
            arrayList.add(ecsEntity);
        }
    }
}

