/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.input;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.Button;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.concurrent.Lock;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsContext;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.input.DragState;
import org.jetbrains.letsPlot.livemap.core.input.InputMouseEvent;
import org.jetbrains.letsPlot.livemap.core.input.MouseInputComponent;
import org.jetbrains.letsPlot.livemap.core.input.MouseInputSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0016J$\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "myDragState", "Lorg/jetbrains/letsPlot/livemap/core/input/DragState;", "myRegs", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "rawMouseEventsQueue", "", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSpec;", "Lorg/jetbrains/letsPlot/commons/event/MouseEvent;", "rawMouseEventsQueueLock", "Lorg/jetbrains/letsPlot/commons/intern/concurrent/Lock;", "destroy", "", "enqueue", "org/jetbrains/letsPlot/livemap/core/input/MouseInputSystem$enqueue$1", "mouseEventSpec", "(Lorg/jetbrains/letsPlot/commons/event/MouseEventSpec;)Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputSystem$enqueue$1;", "handleEvent", "Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputSystem$InputEvent;", "events", "", "init", "context", "update", "dt", "", "updateDragState", "location", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "isStopEvent", "", "InputEvent", "livemap"})
@SourceDebugExtension(value={"SMAP\nMouseInputSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseInputSystem.kt\norg/jetbrains/letsPlot/livemap/core/input/MouseInputSystem\n+ 2 Lock.kt\norg/jetbrains/letsPlot/commons/intern/concurrent/LockKt\n+ 3 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n14#2,5:159\n68#3:164\n24#3,2:165\n1855#4,2:167\n*S KotlinDebug\n*F\n+ 1 MouseInputSystem.kt\norg/jetbrains/letsPlot/livemap/core/input/MouseInputSystem\n*L\n56#1:159,5\n77#1:164\n77#1:165,2\n101#1:167,2\n*E\n"})
public final class MouseInputSystem
extends AbstractSystem<EcsContext> {
    @NotNull
    private final CompositeRegistration myRegs;
    @Nullable
    private DragState myDragState;
    @NotNull
    private final Lock rawMouseEventsQueueLock;
    @NotNull
    private final List<Pair<MouseEventSpec, MouseEvent>> rawMouseEventsQueue;

    public MouseInputSystem(@NotNull EcsComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(componentManager);
        this.myRegs = new CompositeRegistration(new Registration[0]);
        this.rawMouseEventsQueueLock = new Lock();
        this.rawMouseEventsQueue = new ArrayList();
    }

    private final enqueue.1 enqueue(MouseEventSpec mouseEventSpec) {
        return new EventHandler<MouseEvent>(this, mouseEventSpec){
            final /* synthetic */ MouseInputSystem this$0;
            final /* synthetic */ MouseEventSpec $mouseEventSpec;
            {
                this.this$0 = $receiver;
                this.$mouseEventSpec = $mouseEventSpec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void onEvent(@NotNull MouseEvent event) {
                void $this$execute$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Lock lock = MouseInputSystem.access$getRawMouseEventsQueueLock$p(this.this$0);
                MouseInputSystem mouseInputSystem = this.this$0;
                MouseEventSpec mouseEventSpec = this.$mouseEventSpec;
                boolean $i$f$execute = false;
                try {
                    $this$execute$iv.lock();
                    boolean bl = false;
                    boolean bl2 = MouseInputSystem.access$getRawMouseEventsQueue$p(mouseInputSystem).add(TuplesKt.to((Object)mouseEventSpec, (Object)event));
                }
                finally {
                    $this$execute$iv.unlock();
                }
            }
        };
    }

    @Override
    public void init(@NotNull EcsContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.myRegs.add(context.getEventSource().addEventHandler(MouseEventSpec.MOUSE_DOUBLE_CLICKED, (EventHandler)this.enqueue(MouseEventSpec.MOUSE_DOUBLE_CLICKED)));
        this.myRegs.add(context.getEventSource().addEventHandler(MouseEventSpec.MOUSE_PRESSED, (EventHandler)this.enqueue(MouseEventSpec.MOUSE_PRESSED)));
        this.myRegs.add(context.getEventSource().addEventHandler(MouseEventSpec.MOUSE_RELEASED, (EventHandler)this.enqueue(MouseEventSpec.MOUSE_RELEASED)));
        this.myRegs.add(context.getEventSource().addEventHandler(MouseEventSpec.MOUSE_DRAGGED, (EventHandler)this.enqueue(MouseEventSpec.MOUSE_DRAGGED)));
        this.myRegs.add(context.getEventSource().addEventHandler(MouseEventSpec.MOUSE_MOVED, (EventHandler)this.enqueue(MouseEventSpec.MOUSE_MOVED)));
        this.myRegs.add(context.getEventSource().addEventHandler(MouseEventSpec.MOUSE_CLICKED, (EventHandler)this.enqueue(MouseEventSpec.MOUSE_CLICKED)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull EcsContext context, double dt) {
        InputEvent inputEvent;
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Lock $this$execute$iv = this.rawMouseEventsQueueLock;
        boolean $i$f$execute = false;
        try {
            $this$execute$iv.lock();
            boolean bl = false;
            List copy = CollectionsKt.toList((Iterable)this.rawMouseEventsQueue);
            this.rawMouseEventsQueue.clear();
            list = copy;
        }
        finally {
            $this$execute$iv.unlock();
        }
        List events = list;
        DragState dragState = this.myDragState;
        boolean bl = dragState != null ? dragState.getStarted() : false;
        if (bl) {
            DragState dragState2 = this.myDragState;
            this.myDragState = dragState2 != null ? DragState.copy$default(dragState2, null, null, false, true, false, 19, null) : null;
        }
        DragState dragState3 = this.myDragState;
        boolean bl2 = dragState3 != null ? dragState3.getStopped() : false;
        if (bl2) {
            this.myDragState = null;
        }
        if ((inputEvent = this.handleEvent(events)) == null) {
            inputEvent = new InputEvent(null, null, null, null, this.myDragState, 15, null);
        }
        InputEvent inputEvent2 = inputEvent;
        Iterator iterator = this.getEntities((KClass<EcsComponent>)Reflection.getOrCreateKotlinClass(MouseInputComponent.class)).iterator();
        while (iterator.hasNext()) {
            EcsComponent ecsComponent;
            EcsEntity entity2;
            EcsEntity this_$iv = entity2 = (EcsEntity)iterator.next();
            boolean $i$f$getComponent = false;
            EcsEntity this_$iv$iv = this_$iv;
            boolean $i$f$get = false;
            if ((EcsComponent)((MouseInputComponent)this_$iv$iv.getComponentManager().getComponents(this_$iv$iv).get(Reflection.getOrCreateKotlinClass(MouseInputComponent.class))) == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(MouseInputComponent.class).getSimpleName() + " is not found");
            }
            MouseInputComponent $this$update_u24lambda_u241 = (MouseInputComponent)ecsComponent;
            boolean bl3 = false;
            $this$update_u24lambda_u241.setMoveEvent(inputEvent2.getMoveEvent());
            $this$update_u24lambda_u241.setPressEvent(inputEvent2.getPressEvent());
            $this$update_u24lambda_u241.setClickEvent(inputEvent2.getClickEvent());
            $this$update_u24lambda_u241.setDoubleClickEvent(inputEvent2.getDoubleClickEvent());
            $this$update_u24lambda_u241.setDragState(inputEvent2.getDragState());
        }
    }

    @Override
    public void destroy() {
        this.myRegs.dispose();
    }

    private final InputEvent handleEvent(List<? extends Pair<? extends MouseEventSpec, ? extends MouseEvent>> events) {
        if (events.isEmpty()) {
            return null;
        }
        InputMouseEvent pressEvent = null;
        InputMouseEvent moveEvent = null;
        InputMouseEvent clickEvent = null;
        InputMouseEvent doubleClickEvent = null;
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            MouseEventSpec mouseEventSpec = (MouseEventSpec)pair.component1();
            MouseEvent event = (MouseEvent)pair.component2();
            switch (WhenMappings.$EnumSwitchMapping$0[mouseEventSpec.ordinal()]) {
                case 1: {
                    moveEvent = new InputMouseEvent(event.getLocation());
                    break;
                }
                case 2: {
                    this.updateDragState(event.getLocation(), false);
                    break;
                }
                case 3: {
                    if (event.getButton() != Button.LEFT) break;
                    this.updateDragState(event.getLocation(), true);
                    break;
                }
            }
            if (event.getButton() != Button.LEFT) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[mouseEventSpec.ordinal()]) {
                case 4: {
                    clickEvent = new InputMouseEvent(event.getLocation());
                    break;
                }
                case 5: {
                    doubleClickEvent = new InputMouseEvent(event.getLocation());
                    break;
                }
                case 6: {
                    pressEvent = new InputMouseEvent(event.getLocation());
                    break;
                }
            }
        }
        return new InputEvent(moveEvent, pressEvent, clickEvent, doubleClickEvent, this.myDragState);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void updateDragState(Vector location, boolean isStopEvent) {
        MouseInputSystem mouseInputSystem;
        DragState dragState;
        DragState dragState2 = this.myDragState;
        if (dragState2 == null || (dragState2 = dragState2.getOrigin()) == null) {
            dragState2 = location;
        }
        DragState newOrigin = dragState2;
        MouseInputSystem mouseInputSystem2 = this;
        DragState dragState3 = this.myDragState;
        if (dragState3 != null) {
            DragState dragState4;
            void it;
            DragState dragState5 = dragState3;
            MouseInputSystem mouseInputSystem3 = mouseInputSystem2;
            boolean bl = false;
            if (it.getStarted()) {
                if (!isStopEvent) {
                    dragState4 = new DragState((Vector)newOrigin, location, true, false, false, 24, null);
                } else {
                    if (!isStopEvent) throw new IllegalStateException();
                    dragState4 = new DragState((Vector)newOrigin, location, true, false, true, 8, null);
                }
            } else if (it.getDragging()) {
                if (!isStopEvent) {
                    dragState4 = new DragState((Vector)newOrigin, location, false, true, false, 20, null);
                } else {
                    if (!isStopEvent) throw new IllegalStateException();
                    dragState4 = new DragState((Vector)newOrigin, location, false, false, true, 12, null);
                }
            } else {
                if (!it.getStopped()) throw new IllegalStateException();
                if (!isStopEvent) {
                    dragState4 = new DragState((Vector)newOrigin, location, false, false, true, 12, null);
                } else {
                    if (!isStopEvent) throw new IllegalStateException();
                    dragState4 = new DragState((Vector)newOrigin, location, false, false, true, 12, null);
                }
            }
            dragState = dragState4;
            mouseInputSystem = mouseInputSystem3;
        } else {
            MouseInputSystem it = this;
            MouseInputSystem mouseInputSystem4 = mouseInputSystem2;
            boolean bl = false;
            dragState = isStopEvent ? null : (!isStopEvent ? new DragState(location, location, true, false, false, 24, null) : null);
            mouseInputSystem = mouseInputSystem4;
        }
        mouseInputSystem.myDragState = dragState;
    }

    public static final /* synthetic */ Lock access$getRawMouseEventsQueueLock$p(MouseInputSystem $this) {
        return $this.rawMouseEventsQueueLock;
    }

    public static final /* synthetic */ List access$getRawMouseEventsQueue$p(MouseInputSystem $this) {
        return $this.rawMouseEventsQueue;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003JE\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/input/MouseInputSystem$InputEvent;", "", "moveEvent", "Lorg/jetbrains/letsPlot/livemap/core/input/InputMouseEvent;", "pressEvent", "clickEvent", "doubleClickEvent", "dragState", "Lorg/jetbrains/letsPlot/livemap/core/input/DragState;", "(Lorg/jetbrains/letsPlot/livemap/core/input/InputMouseEvent;Lorg/jetbrains/letsPlot/livemap/core/input/InputMouseEvent;Lorg/jetbrains/letsPlot/livemap/core/input/InputMouseEvent;Lorg/jetbrains/letsPlot/livemap/core/input/InputMouseEvent;Lorg/jetbrains/letsPlot/livemap/core/input/DragState;)V", "getClickEvent", "()Lorg/jetbrains/letsPlot/livemap/core/input/InputMouseEvent;", "getDoubleClickEvent", "getDragState", "()Lorg/jetbrains/letsPlot/livemap/core/input/DragState;", "getMoveEvent", "getPressEvent", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "livemap"})
    private static final class InputEvent {
        @Nullable
        private final InputMouseEvent moveEvent;
        @Nullable
        private final InputMouseEvent pressEvent;
        @Nullable
        private final InputMouseEvent clickEvent;
        @Nullable
        private final InputMouseEvent doubleClickEvent;
        @Nullable
        private final DragState dragState;

        public InputEvent(@Nullable InputMouseEvent moveEvent, @Nullable InputMouseEvent pressEvent, @Nullable InputMouseEvent clickEvent, @Nullable InputMouseEvent doubleClickEvent, @Nullable DragState dragState) {
            this.moveEvent = moveEvent;
            this.pressEvent = pressEvent;
            this.clickEvent = clickEvent;
            this.doubleClickEvent = doubleClickEvent;
            this.dragState = dragState;
        }

        public /* synthetic */ InputEvent(InputMouseEvent inputMouseEvent, InputMouseEvent inputMouseEvent2, InputMouseEvent inputMouseEvent3, InputMouseEvent inputMouseEvent4, DragState dragState, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                inputMouseEvent = null;
            }
            if ((n & 2) != 0) {
                inputMouseEvent2 = null;
            }
            if ((n & 4) != 0) {
                inputMouseEvent3 = null;
            }
            if ((n & 8) != 0) {
                inputMouseEvent4 = null;
            }
            if ((n & 0x10) != 0) {
                dragState = null;
            }
            this(inputMouseEvent, inputMouseEvent2, inputMouseEvent3, inputMouseEvent4, dragState);
        }

        @Nullable
        public final InputMouseEvent getMoveEvent() {
            return this.moveEvent;
        }

        @Nullable
        public final InputMouseEvent getPressEvent() {
            return this.pressEvent;
        }

        @Nullable
        public final InputMouseEvent getClickEvent() {
            return this.clickEvent;
        }

        @Nullable
        public final InputMouseEvent getDoubleClickEvent() {
            return this.doubleClickEvent;
        }

        @Nullable
        public final DragState getDragState() {
            return this.dragState;
        }

        @Nullable
        public final InputMouseEvent component1() {
            return this.moveEvent;
        }

        @Nullable
        public final InputMouseEvent component2() {
            return this.pressEvent;
        }

        @Nullable
        public final InputMouseEvent component3() {
            return this.clickEvent;
        }

        @Nullable
        public final InputMouseEvent component4() {
            return this.doubleClickEvent;
        }

        @Nullable
        public final DragState component5() {
            return this.dragState;
        }

        @NotNull
        public final InputEvent copy(@Nullable InputMouseEvent moveEvent, @Nullable InputMouseEvent pressEvent, @Nullable InputMouseEvent clickEvent, @Nullable InputMouseEvent doubleClickEvent, @Nullable DragState dragState) {
            return new InputEvent(moveEvent, pressEvent, clickEvent, doubleClickEvent, dragState);
        }

        public static /* synthetic */ InputEvent copy$default(InputEvent inputEvent, InputMouseEvent inputMouseEvent, InputMouseEvent inputMouseEvent2, InputMouseEvent inputMouseEvent3, InputMouseEvent inputMouseEvent4, DragState dragState, int n, Object object) {
            if ((n & 1) != 0) {
                inputMouseEvent = inputEvent.moveEvent;
            }
            if ((n & 2) != 0) {
                inputMouseEvent2 = inputEvent.pressEvent;
            }
            if ((n & 4) != 0) {
                inputMouseEvent3 = inputEvent.clickEvent;
            }
            if ((n & 8) != 0) {
                inputMouseEvent4 = inputEvent.doubleClickEvent;
            }
            if ((n & 0x10) != 0) {
                dragState = inputEvent.dragState;
            }
            return inputEvent.copy(inputMouseEvent, inputMouseEvent2, inputMouseEvent3, inputMouseEvent4, dragState);
        }

        @NotNull
        public String toString() {
            return "InputEvent(moveEvent=" + this.moveEvent + ", pressEvent=" + this.pressEvent + ", clickEvent=" + this.clickEvent + ", doubleClickEvent=" + this.doubleClickEvent + ", dragState=" + this.dragState + ')';
        }

        public int hashCode() {
            int result = this.moveEvent == null ? 0 : this.moveEvent.hashCode();
            result = result * 31 + (this.pressEvent == null ? 0 : this.pressEvent.hashCode());
            result = result * 31 + (this.clickEvent == null ? 0 : this.clickEvent.hashCode());
            result = result * 31 + (this.doubleClickEvent == null ? 0 : this.doubleClickEvent.hashCode());
            result = result * 31 + (this.dragState == null ? 0 : this.dragState.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputEvent)) {
                return false;
            }
            InputEvent inputEvent = (InputEvent)other;
            if (!Intrinsics.areEqual((Object)this.moveEvent, (Object)inputEvent.moveEvent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pressEvent, (Object)inputEvent.pressEvent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clickEvent, (Object)inputEvent.clickEvent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.doubleClickEvent, (Object)inputEvent.doubleClickEvent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dragState, (Object)inputEvent.dragState);
        }

        public InputEvent() {
            this(null, null, null, null, null, 31, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MouseEventSpec.values().length];
            try {
                nArray[MouseEventSpec.MOUSE_MOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseEventSpec.MOUSE_DRAGGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseEventSpec.MOUSE_RELEASED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseEventSpec.MOUSE_CLICKED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseEventSpec.MOUSE_DOUBLE_CLICKED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseEventSpec.MOUSE_PRESSED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

