/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.layers;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.CanvasControl;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.core.layers.LayerKind;
import org.jetbrains.letsPlot.livemap.core.layers.PanningPolicy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010!\u001a\u00020\u00132\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J\u0006\u0010#\u001a\u00020\u0013J\u0006\u0010$\u001a\u00020\u0013J\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0013J\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000f\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006."}, d2={"Lorg/jetbrains/letsPlot/livemap/core/layers/CanvasLayer;", "", "canvas", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "name", "", "kind", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerKind;", "(Lorg/jetbrains/letsPlot/core/canvas/Canvas;Ljava/lang/String;Lorg/jetbrains/letsPlot/livemap/core/layers/LayerKind;)V", "getCanvas", "()Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "getKind", "()Lorg/jetbrains/letsPlot/livemap/core/layers/LayerKind;", "myRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "myRenderTaskList", "Ljava/util/ArrayList;", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "", "Lkotlin/collections/ArrayList;", "getName", "()Ljava/lang/String;", "panningPolicy", "Lorg/jetbrains/letsPlot/livemap/core/layers/PanningPolicy;", "getPanningPolicy", "()Lorg/jetbrains/letsPlot/livemap/core/layers/PanningPolicy;", "setPanningPolicy", "(Lorg/jetbrains/letsPlot/livemap/core/layers/PanningPolicy;)V", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "addRenderTask", "func", "clear", "clearRenderTaskss", "containsRenderTasks", "", "removeFrom", "canvasControl", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "render", "snapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "toString", "livemap"})
@SourceDebugExtension(value={"SMAP\nCanvasLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasLayer.kt\norg/jetbrains/letsPlot/livemap/core/layers/CanvasLayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1855#2,2:70\n*S KotlinDebug\n*F\n+ 1 CanvasLayer.kt\norg/jetbrains/letsPlot/livemap/core/layers/CanvasLayer\n*L\n38#1:70,2\n*E\n"})
public final class CanvasLayer {
    @NotNull
    private final Canvas canvas;
    @NotNull
    private final String name;
    @NotNull
    private final LayerKind kind;
    @NotNull
    private final DoubleRectangle myRect;
    @NotNull
    private final ArrayList<Function1<Context2d, Unit>> myRenderTaskList;
    @NotNull
    private PanningPolicy panningPolicy;

    public CanvasLayer(@NotNull Canvas canvas, @NotNull String name, @NotNull LayerKind kind) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.canvas = canvas;
        this.name = name;
        this.kind = kind;
        this.myRect = new DoubleRectangle(0.0, 0.0, (double)this.canvas.getSize().getX(), (double)this.canvas.getSize().getY());
        this.myRenderTaskList = new ArrayList();
        this.panningPolicy = PanningPolicy.REPAINT;
    }

    @NotNull
    public final Canvas getCanvas() {
        return this.canvas;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final LayerKind getKind() {
        return this.kind;
    }

    @NotNull
    public final Vector getSize() {
        return this.canvas.getSize();
    }

    @NotNull
    public final PanningPolicy getPanningPolicy() {
        return this.panningPolicy;
    }

    public final void setPanningPolicy(@NotNull PanningPolicy panningPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)panningPolicy), (String)"<set-?>");
        this.panningPolicy = panningPolicy;
    }

    public final void addRenderTask(@NotNull Function1<? super Context2d, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        this.myRenderTaskList.add(func);
    }

    public final void clearRenderTaskss() {
        this.myRenderTaskList.clear();
    }

    public final void render() {
        Context2d context2d = this.canvas.getContext2d();
        Iterable $this$forEach$iv = this.myRenderTaskList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)context2d);
        }
        this.myRenderTaskList.clear();
    }

    @NotNull
    public final Canvas.Snapshot snapshot() {
        return this.canvas.takeSnapshot();
    }

    public final void clear() {
        this.canvas.getContext2d().clearRect(this.myRect);
    }

    public final void removeFrom(@NotNull CanvasControl canvasControl) {
        Intrinsics.checkNotNullParameter((Object)canvasControl, (String)"canvasControl");
        canvasControl.removeChild(this.canvas);
    }

    @NotNull
    public String toString() {
        return "layer_" + this.name;
    }

    public final boolean containsRenderTasks() {
        return !((Collection)this.myRenderTaskList).isEmpty();
    }
}

