/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.layers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayerComponent;
import org.jetbrains.letsPlot.livemap.core.layers.DirtyCanvasLayerComponent;
import org.jetbrains.letsPlot.livemap.core.layers.LayerManager;
import org.jetbrains.letsPlot.livemap.core.layers.PanningPolicy;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapLayerComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/layers/LayersRenderingSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "myLayerManager", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;)V", "dirtyLayers", "", "", "getDirtyLayers", "()Ljava/util/List;", "myDirtyLayers", "<set-?>", "", "updated", "getUpdated", "()Z", "updateImpl", "", "context", "dt", "", "livemap"})
@SourceDebugExtension(value={"SMAP\nLayersRenderingSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayersRenderingSystem.kt\norg/jetbrains/letsPlot/livemap/core/layers/LayersRenderingSystem\n+ 2 AbstractSystem.kt\norg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,68:1\n34#2:69\n34#2:70\n34#2:86\n1549#3:71\n1620#3,2:72\n1622#3:76\n1549#3:77\n1620#3,3:78\n1855#3:81\n1856#3:85\n1549#3:87\n1620#3,3:88\n1855#3:91\n1856#3:93\n1549#3:94\n1620#3,2:95\n1622#3:99\n24#4,2:74\n24#4,2:82\n73#4:84\n73#4:92\n24#4,2:97\n*S KotlinDebug\n*F\n+ 1 LayersRenderingSystem.kt\norg/jetbrains/letsPlot/livemap/core/layers/LayersRenderingSystem\n*L\n31#1:69\n39#1:70\n54#1:86\n42#1:71\n42#1:72,2\n42#1:76\n43#1:77\n43#1:78,3\n44#1:81\n44#1:85\n55#1:87\n55#1:88,3\n58#1:91\n58#1:93\n63#1:94\n63#1:95,2\n63#1:99\n42#1:74,2\n45#1:82,2\n46#1:84\n59#1:92\n63#1:97,2\n*E\n"})
public final class LayersRenderingSystem
extends AbstractSystem<LiveMapContext> {
    @NotNull
    private final LayerManager myLayerManager;
    @NotNull
    private List<Integer> myDirtyLayers;
    private boolean updated;

    public LayersRenderingSystem(@NotNull EcsComponentManager componentManager, @NotNull LayerManager myLayerManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)myLayerManager, (String)"myLayerManager");
        super(componentManager);
        this.myLayerManager = myLayerManager;
        this.myDirtyLayers = CollectionsKt.emptyList();
        this.updated = true;
    }

    @NotNull
    public final List<Integer> getDirtyLayers() {
        return this.myDirtyLayers;
    }

    public final boolean getUpdated() {
        return this.updated;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateImpl(@NotNull LiveMapContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.updated = false;
        if (context.getCamera().getPanFrameDistance() != null) {
            EcsEntity it;
            Object object;
            Object item$iv$iv;
            Iterable $this$mapTo$iv$iv;
            AbstractSystem this_$iv = this;
            boolean $i$f$getEntities = false;
            List dirtyLayerEntities = SequencesKt.toList(this_$iv.getComponentManager().getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DirtyCanvasLayerComponent.class)));
            if (Intrinsics.areEqual(context.getCamera().getPanFrameDistance(), Client.Companion.getZERO_VEC()) && dirtyLayerEntities.isEmpty()) {
                return;
            }
            AbstractSystem this_$iv2 = this;
            boolean $i$f$getEntities2 = false;
            Sequence<EcsEntity> basemapLayers = this_$iv2.getComponentManager().getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(BasemapLayerComponent.class));
            Set layersToPan = SequencesKt.toSet((Sequence)SequencesKt.plus(basemapLayers, (Iterable)dirtyLayerEntities));
            Iterable $this$map$iv = layersToPan;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                EcsEntity ecsEntity = (EcsEntity)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                void this_$iv3 = it;
                boolean $i$f$get = false;
                EcsComponent ecsComponent = (CanvasLayerComponent)this_$iv3.getComponentManager().getComponents((EcsEntity)this_$iv3).get(Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class));
                if (ecsComponent == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class).getSimpleName() + " is not found");
                }
                object.add(((CanvasLayerComponent)ecsComponent).getCanvasLayer());
            }
            List dirtyLayers2 = (List)destination$iv$iv;
            $this$map$iv = layersToPan;
            object = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p0;
                item$iv$iv = iterator.next();
                it = (EcsEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getId$livemap());
            }
            ((LayersRenderingSystem)object).myDirtyLayers = (List)destination$iv$iv;
            Iterable $this$forEach$iv = layersToPan;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EcsEntity it2 = (EcsEntity)element$iv;
                boolean bl = false;
                EcsEntity this_$iv4 = it2;
                boolean $i$f$get = false;
                EcsComponent ecsComponent = (CanvasLayerComponent)this_$iv4.getComponentManager().getComponents(this_$iv4).get(Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class));
                if (ecsComponent == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class).getSimpleName() + " is not found");
                }
                if (((CanvasLayerComponent)ecsComponent).getCanvasLayer().getPanningPolicy() != PanningPolicy.REPAINT) continue;
                this_$iv4 = it2;
                boolean $i$f$untag = false;
                this_$iv4.removeComponent((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DirtyCanvasLayerComponent.class));
            }
            Vec<Client> vec = context.getCamera().getPanDistance();
            Intrinsics.checkNotNull(vec);
            this.myLayerManager.pan(vec, dirtyLayers2);
            this.updated = true;
        } else {
            Collection collection;
            Object item$iv$iv;
            Iterator $this$mapTo$iv$iv;
            void $this$map$iv;
            Object this_$iv = this;
            boolean $i$f$getEntities = false;
            List dirtyEntities = SequencesKt.toList(((AbstractSystem)this_$iv).getComponentManager().getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DirtyCanvasLayerComponent.class)));
            this_$iv = dirtyEntities;
            Object object = this;
            boolean $i$f$map = false;
            void dirtyLayers2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator $this$mapTo$iv$iv2 = $this$mapTo$iv$iv.iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                void p0;
                item$iv$iv = $this$mapTo$iv$iv2.next();
                EcsEntity it2 = (EcsEntity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getId$livemap());
            }
            ((LayersRenderingSystem)object).myDirtyLayers = (List)destination$iv$iv;
            this.updated = !((Collection)dirtyEntities).isEmpty();
            Iterable $this$forEach$iv = dirtyEntities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EcsEntity it = (EcsEntity)element$iv;
                boolean bl = false;
                EcsEntity this_$iv5 = it;
                boolean $i$f$untag = false;
                this_$iv5.removeComponent((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DirtyCanvasLayerComponent.class));
            }
            $this$forEach$iv = dirtyEntities;
            object = this.myLayerManager;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                item$iv$iv = iterator.next();
                EcsEntity $i$f$untag = (EcsEntity)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void this_$iv6 = it;
                boolean $i$f$get = false;
                EcsComponent ecsComponent = (CanvasLayerComponent)this_$iv6.getComponentManager().getComponents((EcsEntity)this_$iv6).get(Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class));
                if (ecsComponent == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class).getSimpleName() + " is not found");
                }
                collection.add(((CanvasLayerComponent)ecsComponent).getCanvasLayer());
            }
            ((LayerManager)object).repaint((List)destination$iv$iv);
        }
    }
}

