/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.layers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.CanvasControl;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Context2dKt;
import org.jetbrains.letsPlot.core.canvas.SingleCanvasControl;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayer;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayerComponent;
import org.jetbrains.letsPlot.livemap.core.layers.LayerKind;
import org.jetbrains.letsPlot.livemap.core.layers.LayerManager;
import org.jetbrains.letsPlot.livemap.core.layers.PanningPolicy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\u0016\u0010\u001f\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0016J\u001e\u0010 \u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/layers/OffscreenLayerManager;", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "canvasControl", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "(Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;)V", "myBackingStore", "", "Lorg/jetbrains/letsPlot/livemap/core/layers/CanvasLayer;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "myPanningOffsets", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "singleCanvasControl", "Lorg/jetbrains/letsPlot/core/canvas/SingleCanvasControl;", "addLayer", "Lorg/jetbrains/letsPlot/livemap/core/layers/CanvasLayerComponent;", "name", "", "layerKind", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerKind;", "pan", "", "offset", "dirtyLayers", "", "panLayer", "layer", "removeLayer", "canvasLayer", "repaint", "repaintLayer", "livemap"})
@SourceDebugExtension(value={"SMAP\nLayerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerManager.kt\norg/jetbrains/letsPlot/livemap/core/layers/OffscreenLayerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1855#2,2:173\n1855#2,2:175\n1855#2:177\n1856#2:179\n1#3:178\n*S KotlinDebug\n*F\n+ 1 LayerManager.kt\norg/jetbrains/letsPlot/livemap/core/layers/OffscreenLayerManager\n*L\n51#1:173,2\n67#1:175,2\n70#1:177\n70#1:179\n*E\n"})
public final class OffscreenLayerManager
extends LayerManager {
    @NotNull
    private final SingleCanvasControl singleCanvasControl;
    @NotNull
    private final DoubleRectangle rect;
    @NotNull
    private final Map<CanvasLayer, Canvas.Snapshot> myBackingStore;
    @NotNull
    private final Map<CanvasLayer, Vec<Client>> myPanningOffsets;

    public OffscreenLayerManager(@NotNull CanvasControl canvasControl) {
        Intrinsics.checkNotNullParameter((Object)canvasControl, (String)"canvasControl");
        this.singleCanvasControl = new SingleCanvasControl(canvasControl);
        this.rect = new DoubleRectangle(DoubleVector.Companion.getZERO(), canvasControl.getSize().toDoubleVector());
        this.myBackingStore = new LinkedHashMap();
        this.myPanningOffsets = new LinkedHashMap();
    }

    @Override
    public void pan(@NotNull Vec<? extends Client> offset2, @NotNull List<CanvasLayer> dirtyLayers2) {
        Intrinsics.checkNotNullParameter(offset2, (String)"offset");
        Intrinsics.checkNotNullParameter(dirtyLayers2, (String)"dirtyLayers");
        this.singleCanvasControl.getContext().clearRect(this.rect);
        Iterable $this$forEach$iv = this.getLayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CanvasLayer layer = (CanvasLayer)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[layer.getPanningPolicy().ordinal()]) {
                case 1: {
                    this.panLayer(layer, offset2);
                    break;
                }
                case 2: {
                    if (dirtyLayers2.contains(layer)) {
                        this.repaintLayer(layer, offset2);
                    }
                    this.panLayer(layer, offset2);
                }
            }
        }
    }

    @Override
    public void repaint(@NotNull List<CanvasLayer> dirtyLayers2) {
        Intrinsics.checkNotNullParameter(dirtyLayers2, (String)"dirtyLayers");
        if (dirtyLayers2.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = dirtyLayers2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CanvasLayer p0 = (CanvasLayer)element$iv;
            boolean bl = false;
            LayerManager.repaintLayer$default(this, p0, null, 2, null);
        }
        this.singleCanvasControl.getContext().clearRect(this.rect);
        $this$forEach$iv = this.getLayers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Canvas.Snapshot snapshot;
            CanvasLayer it = (CanvasLayer)element$iv;
            boolean bl = false;
            if (this.myBackingStore.get(it) == null) continue;
            Context2d context2d = this.singleCanvasControl.getContext();
            Canvas.Snapshot p0 = snapshot;
            boolean bl2 = false;
            context2d.drawImage(p0);
        }
    }

    private final void panLayer(CanvasLayer layer, Vec<? extends Client> offset2) {
        block3: {
            Vec vec;
            if (WhenMappings.$EnumSwitchMapping$1[layer.getKind().ordinal()] == 1) {
                vec = Client.Companion.getZERO_VEC();
            } else {
                Vec<Client> vec2 = this.myPanningOffsets.get(layer);
                if (vec2 == null) {
                    vec2 = Client.Companion.getZERO_VEC();
                }
                vec = VecKt.minus(offset2, vec2);
            }
            Vec p = vec;
            boolean bl = false;
            Canvas.Snapshot snapshot = this.myBackingStore.get(layer);
            if (snapshot == null) break block3;
            Canvas.Snapshot snapshot2 = snapshot;
            boolean bl2 = false;
            Context2dKt.drawImage((Context2d)this.singleCanvasControl.getContext(), (Canvas.Snapshot)snapshot2, (Vec)p);
        }
    }

    @Override
    protected void repaintLayer(@NotNull CanvasLayer layer, @NotNull Vec<? extends Client> offset2) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(offset2, (String)"offset");
        layer.clear();
        layer.render();
        this.myBackingStore.put(layer, layer.snapshot());
        this.myPanningOffsets.put(layer, offset2);
    }

    @Override
    @NotNull
    public CanvasLayerComponent addLayer(@NotNull String name, @NotNull LayerKind layerKind) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)layerKind), (String)"layerKind");
        CanvasLayer canvasLayer = new CanvasLayer(this.singleCanvasControl.createCanvas(), name, layerKind);
        this.add(layerKind, canvasLayer);
        return new CanvasLayerComponent(canvasLayer);
    }

    @Override
    public void removeLayer(@NotNull CanvasLayer canvasLayer) {
        Intrinsics.checkNotNullParameter((Object)canvasLayer, (String)"canvasLayer");
        this.remove(canvasLayer);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PanningPolicy.values().length];
            try {
                nArray[PanningPolicy.COPY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PanningPolicy.REPAINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LayerKind.values().length];
            try {
                nArray[LayerKind.UI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

