/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.layers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.CanvasControl;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Context2dKt;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayer;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayerComponent;
import org.jetbrains.letsPlot.livemap.core.layers.LayerKind;
import org.jetbrains.letsPlot.livemap.core.layers.LayerManager;
import org.jetbrains.letsPlot.livemap.core.layers.PanningPolicy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0016J\u001e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0016\u0010\u001b\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0016J\u001e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/layers/ScreenLayerManager;", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "canvasControl", "Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;", "(Lorg/jetbrains/letsPlot/core/canvas/CanvasControl;)V", "myBackingStore", "", "Lorg/jetbrains/letsPlot/livemap/core/layers/CanvasLayer;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "myPanningOffsets", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "addLayer", "Lorg/jetbrains/letsPlot/livemap/core/layers/CanvasLayerComponent;", "name", "", "layerKind", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerKind;", "pan", "", "offset", "dirtyLayers", "", "panLayer", "layer", "removeLayer", "canvasLayer", "repaint", "repaintLayer", "livemap"})
@SourceDebugExtension(value={"SMAP\nLayerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerManager.kt\norg/jetbrains/letsPlot/livemap/core/layers/ScreenLayerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,172:1\n1855#2,2:173\n1855#2,2:175\n372#3,7:177\n*S KotlinDebug\n*F\n+ 1 LayerManager.kt\norg/jetbrains/letsPlot/livemap/core/layers/ScreenLayerManager\n*L\n111#1:173,2\n133#1:175,2\n158#1:177,7\n*E\n"})
public final class ScreenLayerManager
extends LayerManager {
    @NotNull
    private final CanvasControl canvasControl;
    @NotNull
    private final Map<CanvasLayer, Canvas.Snapshot> myBackingStore;
    @NotNull
    private final Map<CanvasLayer, Vec<Client>> myPanningOffsets;

    public ScreenLayerManager(@NotNull CanvasControl canvasControl) {
        Intrinsics.checkNotNullParameter((Object)canvasControl, (String)"canvasControl");
        this.canvasControl = canvasControl;
        this.myBackingStore = new LinkedHashMap();
        this.myPanningOffsets = new LinkedHashMap();
    }

    @Override
    public void pan(@NotNull Vec<? extends Client> offset2, @NotNull List<CanvasLayer> dirtyLayers2) {
        Intrinsics.checkNotNullParameter(offset2, (String)"offset");
        Intrinsics.checkNotNullParameter(dirtyLayers2, (String)"dirtyLayers");
        Iterable $this$forEach$iv = this.getLayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CanvasLayer layer = (CanvasLayer)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[layer.getPanningPolicy().ordinal()]) {
                case 1: {
                    this.panLayer(layer, offset2);
                    break;
                }
                case 2: {
                    if (dirtyLayers2.contains(layer)) {
                        this.repaintLayer(layer, offset2);
                        this.myBackingStore.put(layer, layer.snapshot());
                        this.myPanningOffsets.put(layer, offset2);
                    }
                    if (!this.myBackingStore.containsKey(layer)) {
                        this.myBackingStore.put(layer, layer.snapshot());
                        this.myPanningOffsets.put(layer, offset2);
                    }
                    this.panLayer(layer, offset2);
                }
            }
        }
    }

    @Override
    public void repaint(@NotNull List<CanvasLayer> dirtyLayers2) {
        Intrinsics.checkNotNullParameter(dirtyLayers2, (String)"dirtyLayers");
        if (dirtyLayers2.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = dirtyLayers2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CanvasLayer it = (CanvasLayer)element$iv;
            boolean bl = false;
            this.myBackingStore.remove(it);
            this.myPanningOffsets.remove(it);
            LayerManager.repaintLayer$default(this, it, null, 2, null);
        }
    }

    @Override
    @NotNull
    public CanvasLayerComponent addLayer(@NotNull String name, @NotNull LayerKind layerKind) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)layerKind), (String)"layerKind");
        Canvas canvas = this.canvasControl.createCanvas(this.canvasControl.getSize());
        CanvasLayer canvasLayer = new CanvasLayer(canvas, name, layerKind);
        this.add(layerKind, canvasLayer);
        this.canvasControl.addChild(this.getLayers().indexOf(canvasLayer), canvas);
        return new CanvasLayerComponent(canvasLayer);
    }

    @Override
    public void removeLayer(@NotNull CanvasLayer canvasLayer) {
        Intrinsics.checkNotNullParameter((Object)canvasLayer, (String)"canvasLayer");
        canvasLayer.removeFrom(this.canvasControl);
        this.remove(canvasLayer);
    }

    private final void panLayer(CanvasLayer layer, Vec<? extends Client> offset2) {
        if (WhenMappings.$EnumSwitchMapping$1[layer.getKind().ordinal()] != 1) {
            Canvas.Snapshot snapshot;
            Map<CanvasLayer, Canvas.Snapshot> $this$getOrPut$iv = this.myBackingStore;
            boolean $i$f$getOrPut = false;
            Canvas.Snapshot value$iv = $this$getOrPut$iv.get(layer);
            if (value$iv == null) {
                boolean bl = false;
                Canvas.Snapshot answer$iv = layer.snapshot();
                $this$getOrPut$iv.put(layer, answer$iv);
                snapshot = answer$iv;
            } else {
                snapshot = value$iv;
            }
            Canvas.Snapshot snapshot2 = snapshot;
            boolean bl = false;
            layer.clear();
            Context2d context2d = layer.getCanvas().getContext2d();
            Vec<Client> vec = this.myPanningOffsets.get(layer);
            if (vec == null) {
                vec = Client.Companion.getZERO_VEC();
            }
            Context2dKt.drawImage((Context2d)context2d, (Canvas.Snapshot)snapshot2, (Vec)VecKt.minus(offset2, vec));
        }
    }

    @Override
    protected void repaintLayer(@NotNull CanvasLayer layer, @NotNull Vec<? extends Client> offset2) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(offset2, (String)"offset");
        layer.clear();
        layer.render();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PanningPolicy.values().length];
            try {
                nArray[PanningPolicy.COPY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PanningPolicy.REPAINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LayerKind.values().length];
            try {
                nArray[LayerKind.UI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

