/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.multitasking;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.SystemTime;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.intern.observable.event.SimpleEventSource;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTask;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\r\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\tH\u0016R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/multitasking/DebugMicroTask;", "ItemT", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "mySystemTime", "Lorg/jetbrains/letsPlot/commons/SystemTime;", "myMicroTask", "(Lorg/jetbrains/letsPlot/commons/SystemTime;Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;)V", "finishEventSource", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/SimpleEventSource;", "", "<set-?>", "", "maxResumeTime", "getMaxResumeTime", "()J", "processTime", "getProcessTime", "addFinishHandler", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "handler", "Lkotlin/Function0;", "alive", "", "getResult", "()Ljava/lang/Object;", "resume", "livemap"})
public final class DebugMicroTask<ItemT>
implements MicroTask<ItemT> {
    @NotNull
    private final SystemTime mySystemTime;
    @NotNull
    private final MicroTask<ItemT> myMicroTask;
    @NotNull
    private final SimpleEventSource<Unit> finishEventSource;
    private long processTime;
    private long maxResumeTime;

    public DebugMicroTask(@NotNull SystemTime mySystemTime, @NotNull MicroTask<ItemT> myMicroTask) {
        Intrinsics.checkNotNullParameter((Object)mySystemTime, (String)"mySystemTime");
        Intrinsics.checkNotNullParameter(myMicroTask, (String)"myMicroTask");
        this.mySystemTime = mySystemTime;
        this.myMicroTask = myMicroTask;
        this.finishEventSource = new SimpleEventSource();
    }

    public final long getProcessTime() {
        return this.processTime;
    }

    public final long getMaxResumeTime() {
        return this.maxResumeTime;
    }

    @Override
    public void resume() {
        long start = this.mySystemTime.getTimeMs();
        this.myMicroTask.resume();
        long resumeTime = this.mySystemTime.getTimeMs() - start;
        this.processTime += resumeTime;
        this.maxResumeTime = Math.max(resumeTime, this.maxResumeTime);
        if (!this.myMicroTask.alive()) {
            this.finishEventSource.fire(null);
        }
    }

    @NotNull
    public final Registration addFinishHandler(@NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.finishEventSource.addHandler((EventHandler)new EventHandler<Unit>(handler){
            final /* synthetic */ Function0<Unit> $handler;
            {
                this.$handler = $handler;
            }

            public void onEvent(@Nullable Unit event) {
                this.$handler.invoke();
            }
        });
    }

    @Override
    public boolean alive() {
        return this.myMicroTask.alive();
    }

    @Override
    public ItemT getResult() {
        return this.myMicroTask.getResult();
    }
}

