/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.multitasking;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsClock;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskExecutor;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroThreadComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTaskCooperativeExecutor;", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTaskExecutor;", "myClock", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsClock;", "myFrameDurationLimit", "", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsClock;J)V", "start", "", "stop", "updateAndGetFinished", "", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroThreadComponent;", "tasks", "", "livemap"})
public final class MicroTaskCooperativeExecutor
implements MicroTaskExecutor {
    @NotNull
    private final EcsClock myClock;
    private final long myFrameDurationLimit;

    public MicroTaskCooperativeExecutor(@NotNull EcsClock myClock, long myFrameDurationLimit) {
        Intrinsics.checkNotNullParameter((Object)myClock, (String)"myClock");
        this.myClock = myClock;
        this.myFrameDurationLimit = myFrameDurationLimit;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    @NotNull
    public Set<MicroThreadComponent> updateAndGetFinished(@NotNull Set<MicroThreadComponent> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        HashSet<MicroThreadComponent> finishedTasks2 = new HashSet<MicroThreadComponent>();
        boolean enoughTime = true;
        block0: while (enoughTime && !((Collection)tasks).isEmpty()) {
            Iterator<MicroThreadComponent> taskIterator = tasks.iterator();
            while (taskIterator.hasNext()) {
                if (this.myClock.getFrameDurationMs() > this.myFrameDurationLimit) {
                    enoughTime = false;
                    continue block0;
                }
                MicroThreadComponent $this$updateAndGetFinished_u24lambda_u240 = taskIterator.next();
                boolean bl = false;
                int resumesCountdown = $this$updateAndGetFinished_u24lambda_u240.getResumesBeforeTimeCheck$livemap();
                while (resumesCountdown-- > 0 && $this$updateAndGetFinished_u24lambda_u240.getMicroTask().alive()) {
                    $this$updateAndGetFinished_u24lambda_u240.getMicroTask().resume();
                }
                if ($this$updateAndGetFinished_u24lambda_u240.getMicroTask().alive()) continue;
                finishedTasks2.add($this$updateAndGetFinished_u24lambda_u240);
                taskIterator.remove();
            }
        }
        return finishedTasks2;
    }
}

