/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.multitasking;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTask;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\nJG\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u00042\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\r\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u00040\u0010H\u0000\u00a2\u0006\u0002\b\u0011J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\nJA\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\f0\u0010H\u0000\u00a2\u0006\u0002\b\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTaskUtil;", "", "()V", "EMPTY_MICRO_THREAD", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "", "create", "task", "Lkotlin/Function0;", "tasks", "", "flatMap", "ResultT", "ItemT", "microTask", "mapFunction", "Lkotlin/Function1;", "flatMap$livemap", "join", "map", "map$livemap", "CompositeMicroThread", "MultiMicroThread", "livemap"})
public final class MicroTaskUtil {
    @NotNull
    public static final MicroTaskUtil INSTANCE = new MicroTaskUtil();
    @NotNull
    private static final MicroTask<Unit> EMPTY_MICRO_THREAD = new MicroTask<Unit>(){

        public void getResult() {
        }

        public void resume() {
        }

        public boolean alive() {
            return false;
        }
    };

    private MicroTaskUtil() {
    }

    @NotNull
    public final <ItemT, ResultT> MicroTask<ResultT> map$livemap(@NotNull MicroTask<ItemT> microTask, @NotNull Function1<? super ItemT, ? extends ResultT> mapFunction) {
        Intrinsics.checkNotNullParameter(microTask, (String)"microTask");
        Intrinsics.checkNotNullParameter(mapFunction, (String)"mapFunction");
        return new MicroTask<ResultT>(microTask, mapFunction){
            @Nullable
            private ResultT result;
            private boolean transformed;
            final /* synthetic */ MicroTask<ItemT> $microTask;
            final /* synthetic */ Function1<ItemT, ResultT> $mapFunction;
            {
                this.$microTask = $microTask;
                this.$mapFunction = $mapFunction;
            }

            public void resume() {
                if (this.$microTask.alive()) {
                    this.$microTask.resume();
                } else if (!this.transformed) {
                    this.result = this.$mapFunction.invoke(this.$microTask.getResult());
                    this.transformed = true;
                }
            }

            public boolean alive() {
                return this.$microTask.alive() || !this.transformed;
            }

            public ResultT getResult() {
                ResultT ResultT = this.result;
                if (ResultT == null) {
                    throw new IllegalStateException("".toString());
                }
                return ResultT;
            }
        };
    }

    @NotNull
    public final <ItemT, ResultT> MicroTask<ResultT> flatMap$livemap(@NotNull MicroTask<ItemT> microTask, @NotNull Function1<? super ItemT, ? extends MicroTask<ResultT>> mapFunction) {
        Intrinsics.checkNotNullParameter(microTask, (String)"microTask");
        Intrinsics.checkNotNullParameter(mapFunction, (String)"mapFunction");
        return new MicroTask<ResultT>(microTask, mapFunction){
            private boolean transformed;
            @Nullable
            private MicroTask<ResultT> result;
            final /* synthetic */ MicroTask<ItemT> $microTask;
            final /* synthetic */ Function1<ItemT, MicroTask<ResultT>> $mapFunction;
            {
                this.$microTask = $microTask;
                this.$mapFunction = $mapFunction;
            }

            public void resume() {
                if (this.$microTask.alive()) {
                    this.$microTask.resume();
                } else if (!this.transformed) {
                    this.result = (MicroTask)this.$mapFunction.invoke(this.$microTask.getResult());
                    this.transformed = true;
                } else {
                    MicroTask<ResultT> microTask = this.result;
                    Intrinsics.checkNotNull(microTask);
                    if (microTask.alive()) {
                        MicroTask<ResultT> microTask2 = this.result;
                        Intrinsics.checkNotNull(microTask2);
                        microTask2.resume();
                    }
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean alive() {
                if (this.$microTask.alive()) return true;
                if (!this.transformed) return true;
                MicroTask<ResultT> microTask = this.result;
                Intrinsics.checkNotNull(microTask);
                if (!microTask.alive()) return false;
                return true;
            }

            public ResultT getResult() {
                MicroTask<ResultT> microTask = this.result;
                Intrinsics.checkNotNull(microTask);
                return microTask.getResult();
            }
        };
    }

    @NotNull
    public final MicroTask<Unit> create(@NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return new CompositeMicroThread(CollectionsKt.listOf(task));
    }

    @NotNull
    public final MicroTask<Unit> create(@NotNull Iterable<? extends Function0<Unit>> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        return new CompositeMicroThread(tasks);
    }

    @NotNull
    public final MicroTask<Unit> join(@NotNull Iterable<? extends MicroTask<Unit>> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        return new MultiMicroThread(tasks);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\b\u0000\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTaskUtil$CompositeMicroThread;", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "", "tasks", "", "Lkotlin/Function0;", "(Ljava/lang/Iterable;)V", "myTasks", "", "alive", "", "getResult", "resume", "livemap"})
    private static final class CompositeMicroThread
    implements MicroTask<Unit> {
        @NotNull
        private final Iterator<Function0<Unit>> myTasks;

        public CompositeMicroThread(@NotNull Iterable<? extends Function0<Unit>> tasks) {
            Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
            this.myTasks = tasks.iterator();
        }

        @Override
        public void resume() {
            this.myTasks.next().invoke();
        }

        @Override
        public boolean alive() {
            return this.myTasks.hasNext();
        }

        @Override
        public void getResult() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\b\u0000\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\u0002H\u0002J\b\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTaskUtil$MultiMicroThread;", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "", "microThreads", "", "(Ljava/lang/Iterable;)V", "currentMicroThread", "threads", "", "alive", "", "getResult", "goToNextAliveMicroThread", "resume", "livemap"})
    private static final class MultiMicroThread
    implements MicroTask<Unit> {
        @NotNull
        private final Iterator<MicroTask<Unit>> threads;
        @NotNull
        private MicroTask<Unit> currentMicroThread;

        public MultiMicroThread(@NotNull Iterable<? extends MicroTask<Unit>> microThreads2) {
            Intrinsics.checkNotNullParameter(microThreads2, (String)"microThreads");
            this.threads = microThreads2.iterator();
            this.currentMicroThread = EMPTY_MICRO_THREAD;
            this.goToNextAliveMicroThread();
        }

        @Override
        public void resume() {
            this.currentMicroThread.resume();
            this.goToNextAliveMicroThread();
        }

        @Override
        public boolean alive() {
            return this.currentMicroThread.alive();
        }

        @Override
        public void getResult() {
        }

        private final void goToNextAliveMicroThread() {
            while (!this.currentMicroThread.alive()) {
                if (this.threads.hasNext()) {
                    this.currentMicroThread = this.threads.next();
                    continue;
                }
                return;
            }
        }
    }
}

