/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.multitasking;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTask;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskExecutor;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroThreadComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/multitasking/MultiAsyncMicroTaskExecutor;", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTaskExecutor;", "()V", "myExecutorService", "Ljava/util/concurrent/ExecutorService;", "myRunningTasks", "Ljava/util/HashMap;", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroThreadComponent;", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MultiAsyncMicroTaskExecutor$Task;", "Lkotlin/collections/HashMap;", "start", "", "stop", "updateAndGetFinished", "", "tasks", "", "Task", "livemap"})
@SourceDebugExtension(value={"SMAP\nMultiAsyncMicroTaskExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiAsyncMicroTaskExecutor.kt\norg/jetbrains/letsPlot/livemap/core/multitasking/MultiAsyncMicroTaskExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1855#2,2:75\n*S KotlinDebug\n*F\n+ 1 MultiAsyncMicroTaskExecutor.kt\norg/jetbrains/letsPlot/livemap/core/multitasking/MultiAsyncMicroTaskExecutor\n*L\n39#1:75,2\n*E\n"})
public final class MultiAsyncMicroTaskExecutor
implements MicroTaskExecutor {
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final HashMap<MicroThreadComponent, Task> myRunningTasks = new HashMap();

    public MultiAsyncMicroTaskExecutor() {
        int processors = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(processors);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
        this.myExecutorService = executorService;
    }

    @Override
    public void start() {
    }

    @Override
    @NotNull
    public Set<MicroThreadComponent> updateAndGetFinished(@NotNull Set<MicroThreadComponent> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        HashSet<MicroThreadComponent> finishedMicroThreads = new HashSet<MicroThreadComponent>();
        this.myRunningTasks.entrySet().removeIf(arg_0 -> MultiAsyncMicroTaskExecutor.updateAndGetFinished$lambda$0((Function1)new Function1<Map.Entry<MicroThreadComponent, Task>, Boolean>(tasks, finishedMicroThreads){
            final /* synthetic */ Set<MicroThreadComponent> $tasks;
            final /* synthetic */ HashSet<MicroThreadComponent> $finishedMicroThreads;
            {
                this.$tasks = $tasks;
                this.$finishedMicroThreads = $finishedMicroThreads;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<MicroThreadComponent, Task> entry) {
                boolean bl;
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                MicroThreadComponent microThread = entry.getKey();
                Task microTask = entry.getValue();
                if (microTask.isDone$livemap()) {
                    boolean bl2 = true;
                    HashSet<MicroThreadComponent> hashSet = this.$finishedMicroThreads;
                    boolean it = bl2;
                    boolean bl3 = false;
                    ((Collection)hashSet).add(microThread);
                    bl = bl2;
                } else if (!this.$tasks.contains(microThread)) {
                    boolean bl4;
                    boolean it = bl4 = true;
                    boolean bl5 = false;
                    microTask.cancel$livemap();
                    bl = bl4;
                } else {
                    bl = false;
                }
                return bl;
            }
        }, arg_0));
        Set<MicroThreadComponent> set = this.myRunningTasks.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        tasks.removeAll((Collection)set);
        if (!this.myExecutorService.isShutdown() && !this.myExecutorService.isTerminated()) {
            Iterable $this$forEach$iv = tasks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MicroThreadComponent microThreadComponent = (MicroThreadComponent)element$iv;
                boolean bl = false;
                Task task = new Task(microThreadComponent.getMicroTask());
                this.myExecutorService.submit(task);
                ((Map)this.myRunningTasks).put(microThreadComponent, task);
            }
        }
        return finishedMicroThreads;
    }

    @Override
    public void stop() {
        this.myExecutorService.shutdown();
    }

    private static final boolean updateAndGetFinished$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\r\u0010\r\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000eR\u0014\u0010\u0007\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/multitasking/MultiAsyncMicroTaskExecutor$Task;", "Ljava/util/concurrent/Callable;", "Ljava/lang/Void;", "myMicroTask", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "", "(Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;)V", "isDone", "", "isDone$livemap", "()Z", "myIsCancelled", "call", "cancel", "cancel$livemap", "livemap"})
    private static final class Task
    implements Callable<Void> {
        @NotNull
        private final MicroTask<Unit> myMicroTask;
        private volatile boolean myIsCancelled;

        public Task(@NotNull MicroTask<Unit> myMicroTask) {
            Intrinsics.checkNotNullParameter(myMicroTask, (String)"myMicroTask");
            this.myMicroTask = myMicroTask;
        }

        public final boolean isDone$livemap() {
            return !this.myMicroTask.alive();
        }

        @Override
        @Nullable
        public Void call() {
            while (this.myMicroTask.alive() && !this.myIsCancelled) {
                this.myMicroTask.resume();
            }
            return null;
        }

        public final void cancel$livemap() {
            if (this.myMicroTask.alive()) {
                this.myIsCancelled = true;
            }
        }
    }
}

