/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.core.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0015\u0010\u000f\u001a\u00020\r*\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0086\u0002J\u0015\u0010\u0011\u001a\u00020\r*\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0086\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/livemap/core/util/Geometries;", "", "()V", "floor", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "T", "p", "inside", "", "x", "", "y", "rectOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "rectDimension", "minus", "doubleVector", "plus", "livemap"})
public final class Geometries {
    @NotNull
    public static final Geometries INSTANCE = new Geometries();

    private Geometries() {
    }

    @NotNull
    public final DoubleVector minus(@NotNull DoubleVector $this$minus, @NotNull DoubleVector doubleVector) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)doubleVector, (String)"doubleVector");
        return $this$minus.subtract(doubleVector);
    }

    @NotNull
    public final DoubleVector plus(@NotNull DoubleVector $this$plus, @NotNull DoubleVector doubleVector) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)doubleVector, (String)"doubleVector");
        return $this$plus.add(doubleVector);
    }

    public final boolean inside(@NotNull Number x, @NotNull Number y, @NotNull DoubleVector rectOrigin, @NotNull DoubleVector rectDimension) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)rectOrigin, (String)"rectOrigin");
        Intrinsics.checkNotNullParameter((Object)rectDimension, (String)"rectDimension");
        if (x.doubleValue() < rectOrigin.getX()) {
            return false;
        }
        if (y.doubleValue() < rectOrigin.getY()) {
            return false;
        }
        if (x.doubleValue() > rectOrigin.getX() + rectDimension.getX()) {
            return false;
        }
        return !(y.doubleValue() > rectOrigin.getY() + rectDimension.getY());
    }

    @NotNull
    public final <T> Vec<T> floor(@NotNull Vec<? extends T> p) {
        Intrinsics.checkNotNullParameter(p, (String)"p");
        return new Vec(Math.floor(p.getX()), Math.floor(p.getY()));
    }
}

