/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.geocoding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoRectangle;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.FunctionsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Transforms;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.gis.geoprotocol.GeoRequest;
import org.jetbrains.letsPlot.gis.geoprotocol.GeoRequestBuilder;
import org.jetbrains.letsPlot.gis.geoprotocol.GeoResponse;
import org.jetbrains.letsPlot.gis.geoprotocol.GeocodingService;
import org.jetbrains.letsPlot.gis.geoprotocol.MapRegion;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.MapRuler;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002J>\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002J:\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010\"\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u000bj\u0002`$0#2\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/livemap/geocoding/MapLocationGeocoder;", "", "myGeocodingService", "Lorg/jetbrains/letsPlot/gis/geoprotocol/GeocodingService;", "myMapRuler", "Lorg/jetbrains/letsPlot/livemap/core/MapRuler;", "Lorg/jetbrains/letsPlot/livemap/World;", "myMapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "(Lorg/jetbrains/letsPlot/gis/geoprotocol/GeocodingService;Lorg/jetbrains/letsPlot/livemap/core/MapRuler;Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;)V", "calculateBBoxOfGeoRect", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "geoRect", "Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle;", "calculateBBoxOfGeoRect$livemap", "calculateBBoxOfGeoRects", "geoRects", "", "calculateExtendedRectangleWithCenter", "TypeT", "mapRuler", "rect", "center", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "calculateRadius", "", "left", "width", "distance", "Lkotlin/Function2;", "createRequestBuilder", "Lorg/jetbrains/letsPlot/gis/geoprotocol/GeoRequestBuilder$ExplicitRequestBuilder;", "mapRegion", "Lorg/jetbrains/letsPlot/gis/geoprotocol/MapRegion;", "geocodeMapRegion", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "Lorg/jetbrains/letsPlot/livemap/WorldRectangle;", "Companion", "livemap"})
@SourceDebugExtension(value={"SMAP\nMapLocationGeocoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapLocationGeocoder.kt\norg/jetbrains/letsPlot/livemap/geocoding/MapLocationGeocoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1#2:119\n1855#3,2:120\n*S KotlinDebug\n*F\n+ 1 MapLocationGeocoder.kt\norg/jetbrains/letsPlot/livemap/geocoding/MapLocationGeocoder\n*L\n65#1:120,2\n*E\n"})
public final class MapLocationGeocoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeocodingService myGeocodingService;
    @NotNull
    private final MapRuler<World> myMapRuler;
    @NotNull
    private final MapProjection myMapProjection;

    public MapLocationGeocoder(@NotNull GeocodingService myGeocodingService, @NotNull MapRuler<World> myMapRuler, @NotNull MapProjection myMapProjection) {
        Intrinsics.checkNotNullParameter((Object)myGeocodingService, (String)"myGeocodingService");
        Intrinsics.checkNotNullParameter(myMapRuler, (String)"myMapRuler");
        Intrinsics.checkNotNullParameter((Object)myMapProjection, (String)"myMapProjection");
        this.myGeocodingService = myGeocodingService;
        this.myMapRuler = myMapRuler;
        this.myMapProjection = myMapProjection;
    }

    @NotNull
    public final Async<Rect<World>> geocodeMapRegion(@NotNull MapRegion mapRegion) {
        Intrinsics.checkNotNullParameter((Object)mapRegion, (String)"mapRegion");
        GeoRequest.ExplicitSearchRequest explicitSearchRequest = ((GeoRequestBuilder.ExplicitRequestBuilder)((GeoRequestBuilder.ExplicitRequestBuilder)this.createRequestBuilder(mapRegion).addFeature(GeoRequest.FeatureOption.CENTROID)).addFeature(GeoRequest.FeatureOption.POSITION)).build();
        GeocodingService geocodingService = this.myGeocodingService;
        GeoRequest p0 = (GeoRequest)explicitSearchRequest;
        boolean bl = false;
        return geocodingService.execute(p0).map((Function1)new Function1<List<? extends GeoResponse.SuccessGeoResponse.GeocodedFeature>, Rect<World>>(this){
            final /* synthetic */ MapLocationGeocoder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Rect<World> invoke(@NotNull List<GeoResponse.SuccessGeoResponse.GeocodedFeature> features) {
                Rect rect2;
                Intrinsics.checkNotNullParameter(features, (String)"features");
                if (features.isEmpty()) {
                    throw new RuntimeException("There is no geocoded feature for location.");
                }
                if (features.size() == 1) {
                    GeoResponse.SuccessGeoResponse.GeocodedFeature feature = (GeoResponse.SuccessGeoResponse.GeocodedFeature)CollectionsKt.single(features);
                    MapRuler mapRuler = MapLocationGeocoder.access$getMyMapRuler$p(this.this$0);
                    GeoRectangle geoRectangle = feature.getPosition();
                    Intrinsics.checkNotNull((Object)geoRectangle);
                    Rect<World> rect3 = this.this$0.calculateBBoxOfGeoRect$livemap(geoRectangle);
                    MapProjection mapProjection = MapLocationGeocoder.access$getMyMapProjection$p(this.this$0);
                    Vec vec = feature.getCentroid();
                    Intrinsics.checkNotNull((Object)vec);
                    Vec vec2 = (Vec)mapProjection.apply(FunctionsKt.reinterpret((Vec)vec));
                    if (vec2 == null) {
                        vec2 = new Vec((Number)0, (Number)0);
                    }
                    rect2 = MapLocationGeocoder.access$calculateExtendedRectangleWithCenter(this.this$0, mapRuler, rect3, vec2);
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = features;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        GeoResponse.SuccessGeoResponse.GeocodedFeature geocodedFeature = (GeoResponse.SuccessGeoResponse.GeocodedFeature)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        GeoRectangle geoRectangle = it.getPosition();
                        Intrinsics.checkNotNull((Object)geoRectangle);
                        collection.add(geoRectangle);
                    }
                    List list = (List)destination$iv$iv;
                    MapLocationGeocoder mapLocationGeocoder = this.this$0;
                    List p0 = list;
                    boolean bl = false;
                    rect2 = MapLocationGeocoder.access$calculateBBoxOfGeoRects(mapLocationGeocoder, p0);
                }
                return rect2;
            }
        });
    }

    private final GeoRequestBuilder.ExplicitRequestBuilder createRequestBuilder(MapRegion mapRegion) {
        if (!mapRegion.containsId()) {
            boolean bl = false;
            String string = "location should contain geocode";
            throw new IllegalArgumentException(string.toString());
        }
        return new GeoRequestBuilder.ExplicitRequestBuilder().setIds(mapRegion.getIdList());
    }

    @NotNull
    public final Rect<World> calculateBBoxOfGeoRect$livemap(@NotNull GeoRectangle geoRect2) {
        Intrinsics.checkNotNullParameter((Object)geoRect2, (String)"geoRect");
        return this.myMapRuler.calculateBoundingBox(Companion.convertToWorldRects(geoRect2, this.myMapProjection));
    }

    private final Rect<World> calculateBBoxOfGeoRects(List<GeoRectangle> geoRects) {
        ArrayList xyRects = new ArrayList();
        Iterable $this$forEach$iv = geoRects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GeoRectangle geoRect2 = (GeoRectangle)element$iv;
            boolean bl = false;
            xyRects.addAll(Companion.convertToWorldRects(geoRect2, this.myMapProjection));
        }
        return this.myMapRuler.calculateBoundingBox(xyRects);
    }

    private final <TypeT> Rect<TypeT> calculateExtendedRectangleWithCenter(MapRuler<TypeT> mapRuler, Rect<TypeT> rect2, Vec<? extends TypeT> center) {
        double radiusX2 = this.calculateRadius(center.getX(), RectKt.getLeft(rect2), RectKt.getWidth(rect2), (Function2<? super Double, ? super Double, Double>)((Function2)new Function2<Double, Double, Double>(mapRuler){

            @NotNull
            public final Double invoke(double p0, double p1) {
                return ((MapRuler)this.receiver).distanceX(p0, p1);
            }
        }));
        double radiusY2 = this.calculateRadius(center.getY(), RectKt.getTop(rect2), RectKt.getHeight(rect2), (Function2<? super Double, ? super Double, Double>)((Function2)new Function2<Double, Double, Double>(mapRuler){

            @NotNull
            public final Double invoke(double p0, double p1) {
                return ((MapRuler)this.receiver).distanceY(p0, p1);
            }
        }));
        return Rect.Companion.XYWH(center.getX() - radiusX2, center.getY() - radiusY2, radiusX2 * (double)2, radiusY2 * (double)2);
    }

    private final double calculateRadius(double center, double left, double width, Function2<? super Double, ? super Double, Double> distance) {
        double right = left + width;
        double minEdgeDistance = Math.min(((Number)distance.invoke((Object)center, (Object)left)).doubleValue(), ((Number)distance.invoke((Object)center, (Object)right)).doubleValue());
        double d = center;
        return (left <= d ? d <= right : false) ? width - minEdgeDistance : width + minEdgeDistance;
    }

    public static final /* synthetic */ Rect access$calculateExtendedRectangleWithCenter(MapLocationGeocoder $this, MapRuler mapRuler, Rect rect2, Vec center) {
        return $this.calculateExtendedRectangleWithCenter(mapRuler, rect2, center);
    }

    public static final /* synthetic */ MapRuler access$getMyMapRuler$p(MapLocationGeocoder $this) {
        return $this.myMapRuler;
    }

    public static final /* synthetic */ MapProjection access$getMyMapProjection$p(MapLocationGeocoder $this) {
        return $this.myMapProjection;
    }

    public static final /* synthetic */ Rect access$calculateBBoxOfGeoRects(MapLocationGeocoder $this, List geoRects) {
        return $this.calculateBBoxOfGeoRects(geoRects);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/livemap/geocoding/MapLocationGeocoder$Companion;", "", "()V", "convertToWorldRects", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/GeoRectangle;", "mapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "livemap"})
    @SourceDebugExtension(value={"SMAP\nMapLocationGeocoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapLocationGeocoder.kt\norg/jetbrains/letsPlot/livemap/geocoding/MapLocationGeocoder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1603#2,9:119\n1855#2:128\n1856#2:130\n1612#2:131\n1#3:129\n*S KotlinDebug\n*F\n+ 1 MapLocationGeocoder.kt\norg/jetbrains/letsPlot/livemap/geocoding/MapLocationGeocoder$Companion\n*L\n114#1:119,9\n114#1:128\n114#1:130\n114#1:131\n114#1:129\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Rect<World>> convertToWorldRects(@NotNull GeoRectangle $this$convertToWorldRects, @NotNull MapProjection mapProjection) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$convertToWorldRects, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)mapProjection, (String)"mapProjection");
            Iterable $this$mapNotNull$iv = $this$convertToWorldRects.splitByAntiMeridian();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Rect it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Rect rect2 = (Rect)element$iv$iv;
                boolean bl2 = false;
                if (Transforms.transform$default((Transforms)Transforms.INSTANCE, (Rect)rect2, (Function1)((Function1)new Function1<Vec<? extends LonLat>, Vec<? extends World>>((Object)mapProjection){

                    @Nullable
                    public final Vec<World> invoke(@NotNull Vec<? extends LonLat> p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        return (Vec)((MapProjection)this.receiver).apply(p0);
                    }
                }), null, (int)4, null) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

