/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.geocoding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.config.DefaultsKt;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.geocoding.LocationComponent;
import org.jetbrains.letsPlot.livemap.geocoding.MapLocationGeocoder;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.Viewport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J$\u0010\u0015\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0014J&\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0006H\u0014JP\u0010%\u001a\u00020\u001d*\b\u0012\u0004\u0012\u00020\n0\t2<\u0010&\u001a8\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(!\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\u0019\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001d0'H\u0002R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006*"}, d2={"Lorg/jetbrains/letsPlot/livemap/geocoding/MapLocationInitializationSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "myZoom", "", "myLocationRect", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/livemap/World;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;Ljava/lang/Double;Lorg/jetbrains/letsPlot/commons/intern/async/Async;)V", "myDefaultLocation", "", "myLocation", "Lorg/jetbrains/letsPlot/livemap/geocoding/LocationComponent;", "myNeedLocation", "", "myViewport", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;", "Ljava/lang/Double;", "calculateMaxZoom", "regionLength", "containerLength", "rectSize", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "containerSize", "Lorg/jetbrains/letsPlot/livemap/Client;", "initImpl", "", "context", "initMapPoisition", "ctx", "zoom", "coordinates", "updateImpl", "dt", "calculatePosition", "positionConsumer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "livemap"})
@SourceDebugExtension(value={"SMAP\nMapLocationInitializationSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapLocationInitializationSystem.kt\norg/jetbrains/letsPlot/livemap/geocoding/MapLocationInitializationSystem\n+ 2 AbstractSystem.kt\norg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem\n+ 3 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 4 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n70#2:104\n141#3:105\n68#4:106\n24#4,2:107\n1#5:109\n*S KotlinDebug\n*F\n+ 1 MapLocationInitializationSystem.kt\norg/jetbrains/letsPlot/livemap/geocoding/MapLocationInitializationSystem\n*L\n36#1:104\n36#1:105\n36#1:106\n36#1:107,2\n*E\n"})
public final class MapLocationInitializationSystem
extends AbstractSystem<LiveMapContext> {
    @Nullable
    private final Double myZoom;
    @Nullable
    private final Async<Rect<World>> myLocationRect;
    private LocationComponent myLocation;
    private Viewport myViewport;
    private List<Rect<World>> myDefaultLocation;
    private boolean myNeedLocation;

    public MapLocationInitializationSystem(@NotNull EcsComponentManager componentManager, @Nullable Double myZoom, @Nullable Async<Rect<World>> myLocationRect) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(componentManager);
        this.myZoom = myZoom;
        this.myLocationRect = myLocationRect;
        this.myNeedLocation = true;
    }

    @Override
    protected void initImpl(@NotNull LiveMapContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AbstractSystem this_$iv = this;
        boolean $i$f$getSingleton = false;
        EcsComponentManager this_$iv$iv = this_$iv.getComponentManager();
        boolean $i$f$getSingleton2 = false;
        EcsEntity this_$iv$iv$iv = this_$iv$iv.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(LocationComponent.class));
        boolean $i$f$getComponent = false;
        EcsEntity this_$iv$iv$iv$iv = this_$iv$iv$iv;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (LocationComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(LocationComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(LocationComponent.class).getSimpleName() + " is not found");
        }
        this.myLocation = (LocationComponent)ecsComponent;
        this.myViewport = context.getMapRenderContext().getViewport();
        this.myDefaultLocation = MapLocationGeocoder.Companion.convertToWorldRects(DefaultsKt.getDEFAULT_LOCATION(), context.getMapProjection());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateImpl(@NotNull LiveMapContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.myNeedLocation) {
            return;
        }
        if (this.myLocationRect != null) {
            this.myLocationRect.map((Function1)new Function1<Rect<World>, Unit>(this, context){
                final /* synthetic */ MapLocationInitializationSystem this$0;
                final /* synthetic */ LiveMapContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Rect<World> it) {
                    void p0;
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    MapLocationInitializationSystem.access$setMyNeedLocation$p(this.this$0, false);
                    List list = CollectionsKt.listOf(it);
                    Viewport viewport = MapLocationInitializationSystem.access$getMyViewport$p(this.this$0);
                    if (viewport == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                        viewport = null;
                    }
                    Viewport viewport2 = viewport;
                    List list2 = list;
                    MapLocationInitializationSystem mapLocationInitializationSystem = this.this$0;
                    boolean bl = false;
                    MapLocationInitializationSystem.access$calculatePosition(mapLocationInitializationSystem, viewport2.calculateBoundingBox((List<Rect<World>>)p0), (Function2)new Function2<Double, Vec<? extends World>, Unit>(this.this$0, this.$context){
                        final /* synthetic */ MapLocationInitializationSystem this$0;
                        final /* synthetic */ LiveMapContext $context;
                        {
                            this.this$0 = $receiver;
                            this.$context = $context;
                            super(2);
                        }

                        public final void invoke(double zoom, @NotNull Vec<? extends World> coordinates) {
                            Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
                            MapLocationInitializationSystem.access$initMapPoisition(this.this$0, this.$context, zoom, coordinates);
                        }
                    });
                }
            });
        } else {
            LocationComponent locationComponent = this.myLocation;
            if (locationComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myLocation");
                locationComponent = null;
            }
            if (locationComponent.isReady()) {
                void p0;
                Viewport viewport;
                List<Rect<World>> list;
                List<Rect<World>> list2;
                List<Rect<World>> it;
                this.myNeedLocation = false;
                LocationComponent locationComponent2 = this.myLocation;
                if (locationComponent2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myLocation");
                    locationComponent2 = null;
                }
                Object object = locationComponent2.getLocations();
                ArrayList<Rect<World>> arrayList = object;
                MapLocationInitializationSystem mapLocationInitializationSystem = this;
                boolean bl = false;
                boolean bl2 = !((Collection)it).isEmpty();
                Object object2 = bl2 ? object : null;
                if (object2 != null) {
                    list2 = (List<Rect<World>>)object2;
                } else {
                    list2 = this.myDefaultLocation;
                    if (list2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myDefaultLocation");
                        list2 = list = null;
                    }
                }
                if ((viewport = this.myViewport) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                    viewport = null;
                }
                object = viewport;
                it = list;
                boolean bl3 = false;
                mapLocationInitializationSystem.calculatePosition(((Viewport)object).calculateBoundingBox((List<Rect<World>>)p0), (Function2<? super Double, ? super Vec<? extends World>, Unit>)((Function2)new Function2<Double, Vec<? extends World>, Unit>(this, context){
                    final /* synthetic */ MapLocationInitializationSystem this$0;
                    final /* synthetic */ LiveMapContext $context;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        super(2);
                    }

                    public final void invoke(double zoom, @NotNull Vec<? extends World> coordinates) {
                        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
                        MapLocationInitializationSystem.access$initMapPoisition(this.this$0, this.$context, zoom, coordinates);
                    }
                }));
            }
        }
    }

    private final void calculatePosition(Rect<World> $this$calculatePosition, Function2<? super Double, ? super Vec<? extends World>, Unit> positionConsumer) {
        double d;
        Double d2 = this.myZoom;
        if (d2 != null) {
            d = d2;
        } else if (!($this$calculatePosition.getDimension().getX() == 0.0) || !($this$calculatePosition.getDimension().getY() == 0.0)) {
            Vec vec = $this$calculatePosition.getDimension();
            Viewport viewport = this.myViewport;
            if (viewport == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                viewport = null;
            }
            d = this.calculateMaxZoom((Vec<? extends World>)vec, viewport.getSize());
        } else {
            List<Rect<World>> list;
            Viewport viewport = this.myViewport;
            if (viewport == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                viewport = null;
            }
            if ((list = this.myDefaultLocation) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myDefaultLocation");
                list = null;
            }
            Vec vec = viewport.calculateBoundingBox(list).getDimension();
            Viewport viewport2 = this.myViewport;
            if (viewport2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                viewport2 = null;
            }
            d = this.calculateMaxZoom((Vec<? extends World>)vec, viewport2.getSize());
        }
        double zoom = d;
        positionConsumer.invoke((Object)zoom, (Object)RectKt.getCenter($this$calculatePosition));
    }

    private final void initMapPoisition(LiveMapContext ctx, double zoom, Vec<? extends World> coordinates) {
        double integerZoom = Math.floor(zoom);
        ctx.getCamera().requestZoom(integerZoom);
        ctx.getCamera().requestPosition(coordinates);
        ctx.setInitialPosition(coordinates);
        ctx.setInitialZoom((int)integerZoom);
    }

    private final double calculateMaxZoom(Vec<? extends World> rectSize, Vec<? extends Client> containerSize) {
        double xZoom = this.calculateMaxZoom(rectSize.getX(), containerSize.getX());
        double yZoom = this.calculateMaxZoom(rectSize.getY(), containerSize.getY());
        double zoom = Math.min(xZoom, yZoom);
        Viewport viewport = this.myViewport;
        if (viewport == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
            viewport = null;
        }
        double d = viewport.getMinZoom();
        Viewport viewport2 = this.myViewport;
        if (viewport2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
            viewport2 = null;
        }
        double d2 = viewport2.getMaxZoom();
        d2 = Math.min(zoom, d2);
        return Math.max(d, d2);
    }

    private final double calculateMaxZoom(double regionLength, double containerLength) {
        double d;
        if (regionLength == 0.0) {
            Viewport viewport = this.myViewport;
            if (viewport == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                viewport = null;
            }
            d = viewport.getMaxZoom();
        } else if (containerLength == 0.0) {
            Viewport viewport = this.myViewport;
            if (viewport == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                viewport = null;
            }
            d = viewport.getMinZoom();
        } else {
            d = Math.log(containerLength / regionLength) / Math.log(2.0);
        }
        return d;
    }

    public static final /* synthetic */ void access$setMyNeedLocation$p(MapLocationInitializationSystem $this, boolean bl) {
        $this.myNeedLocation = bl;
    }

    public static final /* synthetic */ void access$calculatePosition(MapLocationInitializationSystem $this, Rect $receiver, Function2 positionConsumer) {
        $this.calculatePosition((Rect<World>)$receiver, (Function2<? super Double, ? super Vec<? extends World>, Unit>)positionConsumer);
    }

    public static final /* synthetic */ Viewport access$getMyViewport$p(MapLocationInitializationSystem $this) {
        return $this.myViewport;
    }

    public static final /* synthetic */ void access$initMapPoisition(MapLocationInitializationSystem $this, LiveMapContext ctx, double zoom, Vec coordinates) {
        $this.initMapPoisition(ctx, zoom, (Vec<? extends World>)coordinates);
    }
}

