/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.geometry;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Geometry;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.GeometryType;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPoint;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.util.VecUtil;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTask;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskKt;
import org.jetbrains.letsPlot.livemap.geometry.MultiLineStringTransform;
import org.jetbrains.letsPlot.livemap.geometry.MultiPointTransform;
import org.jetbrains.letsPlot.livemap.geometry.MultiPolygonTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JZ\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00070\u0006\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00072*\u0010\u000b\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\u000e\u0012\u0004\u0012\u00020\u000f0\fH\u0002JZ\u0010\u0010\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\u000e\u0012\u0004\u0012\u00020\u000f0\f\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b2 \u0010\u000b\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\r0\u0011H\u0002JN\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00070\u0006\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00072 \u0010\u000b\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\r0\u0011JN\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00120\u0006\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00122 \u0010\u000b\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\r0\u0011JZ\u0010\u000b\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\u000e\u0012\u0004\u0012\u00020\u000f0\f\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b2 \u0010\u000b\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\r0\u0011H\u0002JN\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00070\u0006\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00072 \u0010\u000b\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\r0\u0011JN\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00120\u0006\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u00122 \u0010\u000b\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\r\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\r0\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/livemap/geometry/MicroTasks;", "", "()V", "RESAMPLING_PRECISION", "", "createTransformer", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Geometry;", "OutT", "InT", "geometry", "transform", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "", "", "resample", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "IterativeResampler", "livemap"})
public final class MicroTasks {
    @NotNull
    public static final MicroTasks INSTANCE = new MicroTasks();
    public static final double RESAMPLING_PRECISION = 0.004;

    private MicroTasks() {
    }

    @NotNull
    public final <InT, OutT> MicroTask<Geometry<OutT>> resample(@NotNull Geometry<InT> geometry, @NotNull Function1<? super Vec<? extends InT>, ? extends Vec<? extends OutT>> transform2) {
        Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        return this.createTransformer(geometry, this.resample(transform2));
    }

    @NotNull
    public final <InT, OutT> MicroTask<Geometry<OutT>> transform(@NotNull Geometry<InT> geometry, @NotNull Function1<? super Vec<? extends InT>, ? extends Vec<? extends OutT>> transform2) {
        Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        return this.createTransformer(geometry, this.transform(transform2));
    }

    @NotNull
    public final <InT, OutT> MicroTask<MultiPolygon<OutT>> transform(@NotNull MultiPolygon<InT> geometry, @NotNull Function1<? super Vec<? extends InT>, ? extends Vec<? extends OutT>> transform2) {
        Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        return new MultiPolygonTransform<InT, OutT>(geometry, this.transform(transform2));
    }

    @NotNull
    public final <InT, OutT> MicroTask<MultiPolygon<OutT>> resample(@NotNull MultiPolygon<InT> geometry, @NotNull Function1<? super Vec<? extends InT>, ? extends Vec<? extends OutT>> transform2) {
        Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        return new MultiPolygonTransform<InT, OutT>(geometry, this.resample(transform2));
    }

    private final <InT, OutT> Function2<Vec<? extends InT>, Collection<Vec<? extends OutT>>, Unit> transform(Function1<? super Vec<? extends InT>, ? extends Vec<? extends OutT>> transform2) {
        return new Function2<Vec<? extends InT>, Collection<Vec<? extends OutT>>, Unit>(transform2){
            final /* synthetic */ Function1<Vec<? extends InT>, Vec<OutT>> $transform;
            {
                this.$transform = $transform;
                super(2);
            }

            public final void invoke(@NotNull Vec<? extends InT> p, @NotNull Collection<Vec<OutT>> ring) {
                block0: {
                    Intrinsics.checkNotNullParameter(p, (String)"p");
                    Intrinsics.checkNotNullParameter(ring, (String)"ring");
                    Vec vec = (Vec)this.$transform.invoke(p);
                    if (vec == null) break block0;
                    Vec p0 = vec;
                    boolean bl = false;
                    ring.add(p0);
                }
            }
        };
    }

    private final <InT, OutT> Function2<Vec<? extends InT>, Collection<Vec<? extends OutT>>, Unit> resample(Function1<? super Vec<? extends InT>, ? extends Vec<? extends OutT>> transform2) {
        return new Function2<Vec<? extends InT>, Collection<Vec<? extends OutT>>, Unit>(new IterativeResampler(transform2)){

            public final void invoke(@NotNull Vec<? extends InT> p0, @NotNull Collection<Vec<OutT>> p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((IterativeResampler)this.receiver).next(p0, p1);
            }
        };
    }

    private final <InT, OutT> MicroTask<Geometry<OutT>> createTransformer(Geometry<InT> geometry, Function2<? super Vec<? extends InT>, ? super Collection<Vec<OutT>>, Unit> transform2) {
        MicroTask<Geometry<OutT>> microTask;
        switch (WhenMappings.$EnumSwitchMapping$0[geometry.getType().ordinal()]) {
            case 1: {
                microTask = MicroTaskKt.map(new MultiPolygonTransform(geometry.getMultiPolygon(), transform2), (Function1)new Function1<MultiPolygon<OutT>, Geometry<OutT>>(Geometry.Companion){

                    @NotNull
                    public final Geometry<OutT> invoke(@NotNull MultiPolygon<OutT> p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        return ((Geometry.Companion)this.receiver).of(p0);
                    }
                });
                break;
            }
            case 2: {
                microTask = MicroTaskKt.map(new MultiLineStringTransform(geometry.getMultiLineString(), transform2), (Function1)new Function1<MultiLineString<OutT>, Geometry<OutT>>(Geometry.Companion){

                    @NotNull
                    public final Geometry<OutT> invoke(@NotNull MultiLineString<OutT> p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        return ((Geometry.Companion)this.receiver).of(p0);
                    }
                });
                break;
            }
            case 3: {
                microTask = MicroTaskKt.map(new MultiPointTransform(geometry.getMultiPoint(), transform2), (Function1)new Function1<MultiPoint<OutT>, Geometry<OutT>>(Geometry.Companion){

                    @NotNull
                    public final Geometry<OutT> invoke(@NotNull MultiPoint<OutT> p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        return ((Geometry.Companion)this.receiver).of(p0);
                    }
                });
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return microTask;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B'\u0012 \u0010\u0004\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J(\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\nR\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0006\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0004\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/livemap/geometry/MicroTasks$IterativeResampler;", "InT", "OutT", "", "myTransform", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "(Lkotlin/jvm/functions/Function1;)V", "myPrevPoint", "myRing", "", "next", "", "p", "ring", "livemap"})
    @SourceDebugExtension(value={"SMAP\nMicroTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicroTasks.kt\norg/jetbrains/letsPlot/livemap/geometry/MicroTasks$IterativeResampler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
    public static final class IterativeResampler<InT, OutT> {
        @NotNull
        private final Function1<Vec<? extends InT>, Vec<OutT>> myTransform;
        @Nullable
        private Vec<? extends InT> myPrevPoint;
        @Nullable
        private Collection<Vec<OutT>> myRing;

        public IterativeResampler(@NotNull Function1<? super Vec<? extends InT>, ? extends Vec<? extends OutT>> myTransform) {
            Intrinsics.checkNotNullParameter(myTransform, (String)"myTransform");
            this.myTransform = myTransform;
        }

        public final void next(@NotNull Vec<? extends InT> p, @NotNull Collection<Vec<OutT>> ring) {
            Intrinsics.checkNotNullParameter(p, (String)"p");
            Intrinsics.checkNotNullParameter(ring, (String)"ring");
            if (this.myRing == null || ring != this.myRing) {
                this.myRing = ring;
                this.myPrevPoint = null;
            }
            Vec<? extends InT> prev = this.myPrevPoint;
            this.myPrevPoint = p;
            if (prev == null) {
                Vec vec = (Vec)this.myTransform.invoke(p);
                if (vec != null) {
                    Vec vec2 = vec;
                    Collection<Vec<OutT>> collection = this.myRing;
                    Intrinsics.checkNotNull(collection);
                    Collection<Vec<OutT>> collection2 = collection;
                    Vec p0 = vec2;
                    boolean bl = false;
                    collection2.add(p0);
                }
            } else {
                Collection<Vec<OutT>> collection = this.myRing;
                Intrinsics.checkNotNull(collection);
                CollectionsKt.addAll(collection, (Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)VecUtil.INSTANCE.resample(prev, p, 0.004, this.myTransform)), (int)1));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GeometryType.values().length];
            try {
                nArray[GeometryType.MULTI_POLYGON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeometryType.MULTI_LINESTRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GeometryType.MULTI_POINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

