/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.MouseEventSource;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsContext;
import org.jetbrains.letsPlot.livemap.core.layers.LayerManager;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;
import org.jetbrains.letsPlot.livemap.mapengine.MapRenderContext;
import org.jetbrains.letsPlot.livemap.mapengine.camera.Camera;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\nR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsContext;", "mapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "mouseEventSource", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;", "mapRenderContext", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapRenderContext;", "errorHandler", "Lkotlin/Function1;", "", "", "camera", "Lorg/jetbrains/letsPlot/livemap/mapengine/camera/Camera;", "layerManager", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "(Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;Lorg/jetbrains/letsPlot/livemap/mapengine/MapRenderContext;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/livemap/mapengine/camera/Camera;Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;)V", "getCamera", "()Lorg/jetbrains/letsPlot/livemap/mapengine/camera/Camera;", "initialPosition", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/World;", "getInitialPosition", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "setInitialPosition", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;)V", "initialZoom", "", "getInitialZoom", "()Ljava/lang/Integer;", "setInitialZoom", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getLayerManager", "()Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "getMapProjection", "()Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "getMapRenderContext", "()Lorg/jetbrains/letsPlot/livemap/mapengine/MapRenderContext;", "raiseError", "error", "livemap"})
public class LiveMapContext
extends EcsContext {
    @NotNull
    private final MapProjection mapProjection;
    @NotNull
    private final MapRenderContext mapRenderContext;
    @NotNull
    private final Function1<Throwable, Unit> errorHandler;
    @NotNull
    private final Camera camera;
    @NotNull
    private final LayerManager layerManager;
    @Nullable
    private Vec<? extends World> initialPosition;
    @Nullable
    private Integer initialZoom;

    public LiveMapContext(@NotNull MapProjection mapProjection, @NotNull MouseEventSource mouseEventSource, @NotNull MapRenderContext mapRenderContext, @NotNull Function1<? super Throwable, Unit> errorHandler, @NotNull Camera camera2, @NotNull LayerManager layerManager) {
        Intrinsics.checkNotNullParameter((Object)mapProjection, (String)"mapProjection");
        Intrinsics.checkNotNullParameter((Object)mouseEventSource, (String)"mouseEventSource");
        Intrinsics.checkNotNullParameter((Object)mapRenderContext, (String)"mapRenderContext");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)camera2, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)layerManager, (String)"layerManager");
        super(mouseEventSource);
        this.mapProjection = mapProjection;
        this.mapRenderContext = mapRenderContext;
        this.errorHandler = errorHandler;
        this.camera = camera2;
        this.layerManager = layerManager;
    }

    @NotNull
    public MapProjection getMapProjection() {
        return this.mapProjection;
    }

    @NotNull
    public MapRenderContext getMapRenderContext() {
        return this.mapRenderContext;
    }

    @NotNull
    public Camera getCamera() {
        return this.camera;
    }

    @NotNull
    public final LayerManager getLayerManager() {
        return this.layerManager;
    }

    @Nullable
    public final Vec<World> getInitialPosition() {
        return this.initialPosition;
    }

    public final void setInitialPosition(@Nullable Vec<? extends World> vec) {
        this.initialPosition = vec;
    }

    @Nullable
    public final Integer getInitialZoom() {
        return this.initialZoom;
    }

    public final void setInitialZoom(@Nullable Integer n) {
        this.initialZoom = n;
    }

    public final void raiseError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.errorHandler.invoke((Object)error);
    }
}

