/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.canvas.CanvasProvider;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.core.graphics.RenderObject;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.Viewport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/MapRenderContext;", "", "viewport", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;", "canvasProvider", "Lorg/jetbrains/letsPlot/core/canvas/CanvasProvider;", "(Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;Lorg/jetbrains/letsPlot/core/canvas/CanvasProvider;)V", "getCanvasProvider", "()Lorg/jetbrains/letsPlot/core/canvas/CanvasProvider;", "getViewport", "()Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;", "draw", "", "context", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "x", "", "y", "renderObject", "Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderObject;", "origin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "livemap"})
public class MapRenderContext {
    @NotNull
    private final Viewport viewport;
    @NotNull
    private final CanvasProvider canvasProvider;

    public MapRenderContext(@NotNull Viewport viewport, @NotNull CanvasProvider canvasProvider) {
        Intrinsics.checkNotNullParameter((Object)viewport, (String)"viewport");
        Intrinsics.checkNotNullParameter((Object)canvasProvider, (String)"canvasProvider");
        this.viewport = viewport;
        this.canvasProvider = canvasProvider;
    }

    @NotNull
    public Viewport getViewport() {
        return this.viewport;
    }

    @NotNull
    public final CanvasProvider getCanvasProvider() {
        return this.canvasProvider;
    }

    public final void draw(@NotNull Context2d context, @NotNull DoubleVector origin, @NotNull RenderObject renderObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)renderObject, (String)"renderObject");
        this.draw(context, origin.getX(), origin.getY(), renderObject);
    }

    private final void draw(Context2d context, double x, double y, RenderObject renderObject) {
        context.save();
        context.translate(x, y);
        renderObject.render(context);
        context.restore();
    }
}

