/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKeyKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.api.BuilderKt;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntityKt;
import org.jetbrains.letsPlot.livemap.core.layers.ParentLayerComponent;
import org.jetbrains.letsPlot.livemap.mapengine.LayerEntitiesComponent;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.RenderableComponent;
import org.jetbrains.letsPlot.livemap.mapengine.Renderer;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapCellComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapCellLoadingSystem;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapCellRenderer;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapCellRendererComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapLayerComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapLayerKind;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapTileComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.DebugCellLayerComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.DebugDataComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.DonorTileCalculator;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.KindComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.RequestTilesComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.Tile;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileLoadingSystem;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.debug.DebugCellRenderer;
import org.jetbrains.letsPlot.livemap.mapengine.placement.ScreenDimensionComponent;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.Viewport;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.ViewportGridStateComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\f0\u0012j\u0002`\u0013H\u0002J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\f0\u0012j\u0002`\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapCellLoadingSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "myDonorTileCalculators", "", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapLayerKind;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/DonorTileCalculator;", "myMapRect", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/WorldRectangle;", "calculateDonorTile", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/Tile;", "layerKind", "cellKey", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "createDonorTileCalculators", "createTileLayerEntities", "", "initImpl", "context", "updateImpl", "dt", "", "livemap"})
@SourceDebugExtension(value={"SMAP\nBasemapCellLoadingSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasemapCellLoadingSystem.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapCellLoadingSystem\n+ 2 AbstractSystem.kt\norg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem\n+ 3 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 4 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,120:1\n70#2:121\n70#2:132\n34#2:158\n141#3:122\n141#3:133\n68#4:123\n24#4,2:124\n24#4,2:127\n68#4:134\n24#4,2:135\n24#4,2:137\n24#4,2:139\n24#4,2:141\n24#4,2:150\n24#4,2:159\n24#4,2:161\n1313#5:126\n1314#5:129\n1855#6,2:130\n1238#6,4:154\n372#7,7:143\n453#7:152\n403#7:153\n*S KotlinDebug\n*F\n+ 1 BasemapCellLoadingSystem.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapCellLoadingSystem\n*L\n43#1:121\n54#1:132\n78#1:158\n43#1:122\n54#1:133\n43#1:123\n43#1:124,2\n48#1:127,2\n54#1:134\n54#1:135,2\n61#1:137,2\n64#1:139,2\n66#1:141,2\n68#1:150,2\n79#1:159,2\n112#1:161,2\n46#1:126\n46#1:129\n52#1:130,2\n71#1:154,4\n68#1:143,7\n71#1:152\n71#1:153\n*E\n"})
public final class BasemapCellLoadingSystem
extends AbstractSystem<LiveMapContext> {
    private Rect<World> myMapRect;
    private Map<BasemapLayerKind, DonorTileCalculator> myDonorTileCalculators;

    public BasemapCellLoadingSystem(@NotNull EcsComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(componentManager);
    }

    @Override
    protected void initImpl(@NotNull LiveMapContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.myMapRect = context.getMapProjection().getMapRect();
        EcsEntityKt.addComponents(this.createEntity("tile_for_request"), (Function1<? super ComponentsList, Unit>)((Function1)initImpl.1.INSTANCE));
    }

    @Override
    protected void updateImpl(@NotNull LiveMapContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.myDonorTileCalculators = this.createDonorTileCalculators();
        AbstractSystem this_$iv = this;
        boolean $i$f$getSingleton = false;
        Object this_$iv$iv = this_$iv.getComponentManager();
        boolean $i$f$getSingleton2 = false;
        EcsEntity this_$iv$iv$iv = ((EcsComponentManager)this_$iv$iv).getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(ViewportGridStateComponent.class));
        boolean $i$f$getComponent = false;
        EcsEntity this_$iv$iv$iv$iv = this_$iv$iv$iv;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (ViewportGridStateComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(ViewportGridStateComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ViewportGridStateComponent.class).getSimpleName() + " is not found");
        }
        HashSet<QuadKey<World>> requestTiles = new HashSet<QuadKey<World>>((Collection)((ViewportGridStateComponent)ecsComponent).getCellsToLoad());
        Object $this$forEach$iv = this.getEntities((KClass<EcsComponent>)Reflection.getOrCreateKotlinClass(BasemapCellComponent.class));
        boolean $i$f$forEach = false;
        this_$iv$iv = $this$forEach$iv.iterator();
        while (this_$iv$iv.hasNext()) {
            Object element$iv = this_$iv$iv.next();
            EcsEntity cellEntity = (EcsEntity)element$iv;
            boolean bl = false;
            EcsEntity this_$iv2 = cellEntity;
            $i$f$get = false;
            EcsComponent ecsComponent2 = (BasemapCellComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(BasemapCellComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapCellComponent.class).getSimpleName() + " is not found");
            }
            requestTiles.remove(((BasemapCellComponent)ecsComponent2).getCellKey());
        }
        $this$forEach$iv = requestTiles;
        $i$f$forEach = false;
        this_$iv$iv = $this$forEach$iv.iterator();
        while (this_$iv$iv.hasNext()) {
            Object element$iv = this_$iv$iv.next();
            QuadKey p0 = (QuadKey)element$iv;
            boolean bl = false;
            this.createTileLayerEntities((QuadKey<World>)p0);
        }
        this_$iv = this;
        $i$f$getSingleton = false;
        this_$iv$iv = this_$iv.getComponentManager();
        $i$f$getSingleton2 = false;
        this_$iv$iv$iv = ((EcsComponentManager)this_$iv$iv).getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(RequestTilesComponent.class));
        $i$f$getComponent = false;
        this_$iv$iv$iv$iv = this_$iv$iv$iv;
        $i$f$get = false;
        EcsComponent ecsComponent3 = (RequestTilesComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(RequestTilesComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(RequestTilesComponent.class).getSimpleName() + " is not found");
        }
        ((RequestTilesComponent)ecsComponent3).setRequestTiles(requestTiles);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<BasemapLayerKind, DonorTileCalculator> createDonorTileCalculators() {
        void $this$mapValuesTo$iv$iv;
        Map tile;
        HashMap layerTileMap = new HashMap();
        Iterator iterator = this.getEntities(TileLoadingSystem.Companion.getTILE_COMPONENT_LIST()).iterator();
        while (iterator.hasNext()) {
            Object object;
            EcsEntity entity2;
            EcsEntity this_$iv = entity2 = (EcsEntity)iterator.next();
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (BasemapTileComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(BasemapTileComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapTileComponent.class).getSimpleName() + " is not found");
            }
            if (((BasemapTileComponent)ecsComponent).getNonCacheable()) continue;
            EcsEntity this_$iv2 = entity2;
            boolean $i$f$get2 = false;
            EcsComponent ecsComponent2 = (BasemapTileComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(BasemapTileComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapTileComponent.class).getSimpleName() + " is not found");
            }
            if (((BasemapTileComponent)ecsComponent2).getTile() == null) continue;
            this_$iv2 = entity2;
            $i$f$get2 = false;
            EcsComponent ecsComponent3 = (KindComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(KindComponent.class));
            if (ecsComponent3 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(KindComponent.class).getSimpleName() + " is not found");
            }
            BasemapLayerKind layerKind = ((KindComponent)ecsComponent3).getLayerKind();
            Map $this$getOrPut$iv = layerTileMap;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)layerKind);
            if (value$iv == null) {
                boolean bl = false;
                HashMap answer$iv = new HashMap();
                $this$getOrPut$iv.put(layerKind, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            $this$getOrPut$iv = (Map)object;
            EcsEntity this_$iv3 = entity2;
            boolean $i$f$get3 = false;
            EcsComponent ecsComponent4 = (BasemapCellComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(BasemapCellComponent.class));
            if (ecsComponent4 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapCellComponent.class).getSimpleName() + " is not found");
            }
            $this$getOrPut$iv.put(((BasemapCellComponent)ecsComponent4).getCellKey(), tile);
        }
        Map $this$mapValues$iv = layerTileMap;
        boolean $i$f$mapValues = false;
        tile = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Map tilesMap = (Map)entry2.getValue();
            DonorTileCalculator donorTileCalculator = new DonorTileCalculator(tilesMap);
            map3.put(k, donorTileCalculator);
        }
        return destination$iv$iv;
    }

    private final void createTileLayerEntities(QuadKey<World> cellKey) {
        int zoom = cellKey.getLength();
        Rect<World> rect2 = this.myMapRect;
        if (rect2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myMapRect");
            rect2 = null;
        }
        Rect tileRect = QuadKeyKt.computeRect(cellKey, rect2);
        AbstractSystem this_$iv = this;
        boolean $i$f$getEntities = false;
        Iterator iterator = this_$iv.getComponentManager().getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(BasemapLayerComponent.class)).iterator();
        while (iterator.hasNext()) {
            EcsEntity layer;
            EcsEntity this_$iv2 = layer = (EcsEntity)iterator.next();
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (BasemapLayerComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(BasemapLayerComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapLayerComponent.class).getSimpleName() + " is not found");
            }
            BasemapLayerKind layerKind = ((BasemapLayerComponent)ecsComponent).getLayerKind();
            EcsEntity tileLayerEntity2 = EcsEntityKt.addComponents(BuilderKt.mapEntity(this.getComponentManager(), new ParentLayerComponent(layer.getId$livemap()), "tile_" + (Object)((Object)layerKind) + '_' + cellKey), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>((Rect<World>)tileRect, cellKey, layerKind, layer, zoom, this){
                final /* synthetic */ Rect<World> $tileRect;
                final /* synthetic */ QuadKey<World> $cellKey;
                final /* synthetic */ BasemapLayerKind $layerKind;
                final /* synthetic */ EcsEntity $layer;
                final /* synthetic */ int $zoom;
                final /* synthetic */ BasemapCellLoadingSystem this$0;
                {
                    this.$tileRect = $tileRect;
                    this.$cellKey = $cellKey;
                    this.$layerKind = $layerKind;
                    this.$layer = $layer;
                    this.$zoom = $zoom;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull ComponentsList $this$addComponents) {
                    EcsComponent ecsComponent;
                    void $this$invoke_u24lambda_u242;
                    Renderer renderer;
                    void $this$invoke_u24lambda_u241;
                    Object $this$invoke_u24lambda_u240;
                    EcsComponent ecsComponent2;
                    Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                    $this$addComponents.unaryPlus(new WorldOriginComponent((Vec<? extends World>)this.$tileRect.getOrigin()));
                    EcsComponent ecsComponent3 = ecsComponent2 = new RenderableComponent();
                    ComponentsList componentsList = $this$addComponents;
                    int $i$a$-apply-BasemapCellLoadingSystem$createTileLayerEntities$tileLayerEntity$1$52 = 0;
                    ((RenderableComponent)$this$invoke_u24lambda_u240).setRenderer(BasemapCellRendererComponent.Companion.getNULL_RENDERER());
                    ((RenderableComponent)$this$invoke_u24lambda_u240).setNeedIntegerCoordinates(true);
                    componentsList.unaryPlus(ecsComponent2);
                    ecsComponent2 = new ScreenDimensionComponent();
                    $this$invoke_u24lambda_u240 = this.$tileRect;
                    $i$a$-apply-BasemapCellLoadingSystem$createTileLayerEntities$tileLayerEntity$1$52 = this.$zoom;
                    EcsComponent ecsComponent4 = ecsComponent2;
                    componentsList = $this$addComponents;
                    boolean bl = false;
                    $this$invoke_u24lambda_u241.setDimension(Viewport.Companion.toClientDimension((Vec<? extends World>)$this$invoke_u24lambda_u240.getDimension(), $i$a$-apply-BasemapCellLoadingSystem$createTileLayerEntities$tileLayerEntity$1$52));
                    componentsList.unaryPlus(ecsComponent2);
                    $this$addComponents.unaryPlus(new BasemapCellComponent(this.$cellKey));
                    $this$addComponents.unaryPlus(new KindComponent(this.$layerKind));
                    ecsComponent2 = new BasemapCellRendererComponent();
                    $this$invoke_u24lambda_u240 = this.$layer;
                    EcsComponent $i$a$-apply-BasemapCellLoadingSystem$createTileLayerEntities$tileLayerEntity$1$52 = ecsComponent2;
                    componentsList = $this$addComponents;
                    boolean bl2 = false;
                    Object this_$iv = $this$invoke_u24lambda_u240;
                    boolean $i$f$contains3 = false;
                    boolean bl3 = ((EcsEntity)this_$iv).contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DebugCellLayerComponent.class));
                    if (bl3) {
                        renderer = new DebugCellRenderer();
                    } else if (!bl3) {
                        renderer = new BasemapCellRenderer();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    $this$invoke_u24lambda_u242.setRenderer(renderer);
                    componentsList.unaryPlus(ecsComponent2);
                    ComponentsList componentsList2 = $this$addComponents;
                    EcsEntity this_$iv2 = this.$layer;
                    boolean $i$f$contains2 = false;
                    boolean bl4 = this_$iv2.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DebugCellLayerComponent.class));
                    if (bl4) {
                        ecsComponent = new DebugDataComponent();
                    } else if (!bl4) {
                        void $this$invoke_u24lambda_u243;
                        ecsComponent3 = new BasemapTileComponent();
                        BasemapCellLoadingSystem basemapCellLoadingSystem = this.this$0;
                        BasemapLayerKind basemapLayerKind = this.$layerKind;
                        QuadKey<World> quadKey = this.$cellKey;
                        EcsComponent $i$f$contains3 = ecsComponent3;
                        componentsList = componentsList2;
                        boolean bl5 = false;
                        $this$invoke_u24lambda_u243.setTile(BasemapCellLoadingSystem.access$calculateDonorTile(basemapCellLoadingSystem, basemapLayerKind, quadKey));
                        componentsList2 = componentsList;
                        ecsComponent = ecsComponent3;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    componentsList2.unaryPlus(ecsComponent);
                }
            }));
            EcsEntity this_$iv3 = layer;
            boolean $i$f$get2 = false;
            EcsComponent ecsComponent2 = (LayerEntitiesComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(LayerEntitiesComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(LayerEntitiesComponent.class).getSimpleName() + " is not found");
            }
            ((LayerEntitiesComponent)ecsComponent2).add(tileLayerEntity2.getId$livemap());
        }
    }

    private final Tile calculateDonorTile(BasemapLayerKind layerKind, QuadKey<World> cellKey) {
        Map<BasemapLayerKind, DonorTileCalculator> map2 = this.myDonorTileCalculators;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDonorTileCalculators");
            map2 = null;
        }
        DonorTileCalculator donorTileCalculator = map2.get((Object)layerKind);
        return donorTileCalculator != null ? donorTileCalculator.createDonorTile(cellKey) : null;
    }

    public static final /* synthetic */ Tile access$calculateDonorTile(BasemapCellLoadingSystem $this, BasemapLayerKind layerKind, QuadKey cellKey) {
        return $this.calculateDonorTile(layerKind, (QuadKey<World>)cellKey);
    }
}

