/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKeyKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.mapengine.Context2dExKt;
import org.jetbrains.letsPlot.livemap.mapengine.RenderHelper;
import org.jetbrains.letsPlot.livemap.mapengine.Renderer;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapTileComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.Tile;
import org.jetbrains.letsPlot.livemap.mapengine.placement.ScreenDimensionComponent;
import org.jetbrains.letsPlot.livemap.mapengine.placement.WorldOriginComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J+\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0012J4\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u00182\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018H\u0002J4\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u001b2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u00182\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018H\u0002J4\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u001d2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u00182\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018H\u0002J4\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u00182\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapCellRenderer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/Renderer;", "()V", "myCellRect", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/livemap/Client;", "myCtx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "render", "", "entity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "ctx", "renderHelper", "Lorg/jetbrains/letsPlot/livemap/mapengine/RenderHelper;", "tile", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/Tile;", "cellRect", "render$livemap", "renderCompositeTile", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/Tile$CompositeTile;", "srcCell", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "dstCell", "renderSnapshotTile", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/Tile$SnapshotTile;", "renderSubTile", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/Tile$SubTile;", "renderTile", "livemap"})
@SourceDebugExtension(value={"SMAP\nBasemapCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasemapCellRenderer.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapCellRenderer\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n24#2,2:80\n24#2,2:82\n24#2,2:84\n1#3:86\n1855#4,2:87\n*S KotlinDebug\n*F\n+ 1 BasemapCellRenderer.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapCellRenderer\n*L\n26#1:80,2\n27#1:82,2\n29#1:84,2\n60#1:87,2\n*E\n"})
public final class BasemapCellRenderer
implements Renderer {
    private Rect<Client> myCellRect;
    private Context2d myCtx;

    @Override
    public void render(@NotNull EcsEntity entity2, @NotNull Context2d ctx, @NotNull RenderHelper renderHelper) {
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)renderHelper, (String)"renderHelper");
        EcsEntity this_$iv = entity2;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (BasemapTileComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(BasemapTileComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapTileComponent.class).getSimpleName() + " is not found");
        }
        Tile tile = ((BasemapTileComponent)ecsComponent).getTile();
        if (tile == null) {
            return;
        }
        Tile tile2 = tile;
        EcsEntity this_$iv2 = entity2;
        boolean $i$f$get2 = false;
        EcsComponent ecsComponent2 = (WorldOriginComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(WorldOriginComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(WorldOriginComponent.class).getSimpleName() + " is not found");
        }
        Context2dExKt.translate(ctx, renderHelper.dimToScreen(((WorldOriginComponent)ecsComponent2).getOrigin()));
        this_$iv2 = entity2;
        $i$f$get2 = false;
        EcsComponent ecsComponent3 = (ScreenDimensionComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(ScreenDimensionComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(ScreenDimensionComponent.class).getSimpleName() + " is not found");
        }
        Vec<Client> $this$render_u24lambda_u240 = ((ScreenDimensionComponent)ecsComponent3).getDimension();
        boolean bl = false;
        Rect $this$render_u24lambda_u241 = Rect.Companion.XYWH(Client.Companion.getZERO_VEC(), $this$render_u24lambda_u240);
        boolean bl2 = false;
        this.render$livemap(tile2, (Rect<Client>)$this$render_u24lambda_u241, ctx);
    }

    public final void render$livemap(@NotNull Tile tile, @NotNull Rect<Client> cellRect, @NotNull Context2d ctx) {
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        Intrinsics.checkNotNullParameter(cellRect, (String)"cellRect");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.myCellRect = cellRect;
        this.myCtx = ctx;
        this.renderTile(tile, (QuadKey<World>)new QuadKey(""), (QuadKey<World>)new QuadKey(""));
    }

    private final void renderTile(Tile tile, QuadKey<World> srcCell, QuadKey<World> dstCell) {
        Tile tile2 = tile;
        if (tile2 instanceof Tile.SnapshotTile) {
            this.renderSnapshotTile((Tile.SnapshotTile)tile, srcCell, dstCell);
        } else if (tile2 instanceof Tile.SubTile) {
            this.renderSubTile((Tile.SubTile)tile, srcCell, dstCell);
        } else if (tile2 instanceof Tile.CompositeTile) {
            this.renderCompositeTile((Tile.CompositeTile)tile, srcCell, dstCell);
        } else if (!(tile2 instanceof Tile.EmptyTile)) {
            throw new IllegalStateException(("Unsupported Tile class: " + Reflection.getOrCreateKotlinClass(Tile.class)).toString());
        }
    }

    private final void renderSubTile(Tile.SubTile tile, QuadKey<World> srcCell, QuadKey<World> dstCell) {
        this.renderTile(tile.getTile(), (QuadKey<World>)tile.getSubKey().plus(srcCell), dstCell);
    }

    private final void renderCompositeTile(Tile.CompositeTile tile, QuadKey<World> srcCell, QuadKey<World> dstCell) {
        Iterable $this$forEach$iv = tile.getTiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Tile tile2 = (Tile)pair.component1();
            QuadKey cell = (QuadKey)pair.component2();
            this.renderTile(tile2, srcCell, (QuadKey<World>)dstCell.plus(cell));
        }
    }

    private final void renderSnapshotTile(Tile.SnapshotTile tile, QuadKey<World> srcCell, QuadKey<World> dstCell) {
        Rect<Client> rect2 = this.myCellRect;
        if (rect2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCellRect");
            rect2 = null;
        }
        Rect srcRect = QuadKeyKt.projectRect(srcCell, rect2);
        Rect<Client> rect3 = this.myCellRect;
        if (rect3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCellRect");
            rect3 = null;
        }
        Rect dstRect = QuadKeyKt.projectRect(dstCell, rect3);
        Context2d context2d = this.myCtx;
        if (context2d == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCtx");
            context2d = null;
        }
        context2d.drawImage(tile.getSnapshot(), RectKt.getLeft((Rect)srcRect), RectKt.getTop((Rect)srcRect), RectKt.getWidth((Rect)srcRect), RectKt.getHeight((Rect)srcRect), RectKt.getLeft((Rect)dstRect), RectKt.getTop((Rect)dstRect), RectKt.getWidth((Rect)dstRect), RectKt.getHeight((Rect)dstRect));
    }
}

