/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.containers.LinkedList;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.Tile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00072\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006J\u001a\u0010\u000b\u001a\u00020\u00072\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006H\u0002J\u001a\u0010\f\u001a\u00020\u00072\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006H\u0002J(\u0010\r\u001a\u00020\u000e*\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006H\u0002J2\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006*\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006H\u0002R$\u0010\u0002\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/DonorTileCalculator;", "", "myExistedTiles", "", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/Tile;", "(Ljava/util/Map;)V", "createDonorTile", "cellKey", "findDownDonorTile", "findUpDonorTile", "startsWith", "", "other", "subKey", "livemap"})
@SourceDebugExtension(value={"SMAP\nDonorTileCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DonorTileCalculator.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/DonorTileCalculator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n526#2:68\n511#2,6:69\n526#2:82\n511#2,6:83\n215#3:75\n216#3:79\n1747#4,3:76\n1855#4,2:80\n1#5:89\n*S KotlinDebug\n*F\n+ 1 DonorTileCalculator.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/DonorTileCalculator\n*L\n36#1:68\n36#1:69,6\n57#1:82\n57#1:83,6\n37#1:75\n37#1:79\n38#1:76,3\n46#1:80,2\n*E\n"})
public final class DonorTileCalculator {
    @NotNull
    private final Map<QuadKey<World>, Tile> myExistedTiles;

    public DonorTileCalculator(@NotNull Map<QuadKey<World>, ? extends Tile> myExistedTiles) {
        Intrinsics.checkNotNullParameter(myExistedTiles, (String)"myExistedTiles");
        this.myExistedTiles = myExistedTiles;
    }

    @NotNull
    public final Tile createDonorTile(@NotNull QuadKey<World> cellKey) {
        Tile tile;
        Intrinsics.checkNotNullParameter(cellKey, (String)"cellKey");
        Tile upDonor = this.findUpDonorTile(cellKey);
        Tile downDonor = this.findDownDonorTile(cellKey);
        if (upDonor != Tile.EmptyTile.Companion.getEMPTY_TILE() && downDonor != Tile.EmptyTile.Companion.getEMPTY_TILE()) {
            Tile.CompositeTile compositeTile;
            Tile.CompositeTile $this$createDonorTile_u24lambda_u240 = compositeTile = new Tile.CompositeTile();
            boolean bl = false;
            $this$createDonorTile_u24lambda_u240.add(upDonor, (QuadKey<World>)new QuadKey(""));
            $this$createDonorTile_u24lambda_u240.add(downDonor, (QuadKey<World>)new QuadKey(""));
            tile = compositeTile;
        } else {
            tile = upDonor != Tile.EmptyTile.Companion.getEMPTY_TILE() ? upDonor : (downDonor != Tile.EmptyTile.Companion.getEMPTY_TILE() ? downDonor : (Tile)Tile.EmptyTile.Companion.getEMPTY_TILE());
        }
        return tile;
    }

    private final Tile findDownDonorTile(QuadKey<World> cellKey) {
        Tile tile;
        Iterator $this$filterTo$iv$iv;
        LinkedList downDonors = new LinkedList();
        Map<QuadKey<World>, Tile> $this$filter$iv = this.myExistedTiles;
        boolean $i$f$filter = false;
        Map<QuadKey<World>, Tile> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!this.startsWith((QuadKey<World>)((QuadKey)it.getKey()), cellKey)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            boolean bl;
            Map.Entry entry;
            block8: {
                Map.Entry element$iv;
                entry = element$iv = $this$filterTo$iv$iv.next();
                boolean bl2 = false;
                Iterable $this$any$iv = downDonors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Map.Entry it = (Map.Entry)element$iv2;
                        boolean bl3 = false;
                        if (!this.startsWith((QuadKey<World>)((QuadKey)entry.getKey()), (QuadKey<World>)((QuadKey)it.getKey()))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            CollectionsKt.removeAll((Iterable)downDonors, (Function1)((Function1)new Function1<Map.Entry<? extends QuadKey<World>, ? extends Tile>, Boolean>(this, entry){
                final /* synthetic */ DonorTileCalculator this$0;
                final /* synthetic */ Map.Entry<QuadKey<World>, Tile> $entry;
                {
                    this.this$0 = $receiver;
                    this.$entry = $entry;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Map.Entry<QuadKey<World>, ? extends Tile> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return DonorTileCalculator.access$startsWith(this.this$0, it.getKey(), this.$entry.getKey());
                }
            }));
            downDonors.append(entry);
        }
        if (downDonors.isNotEmpty()) {
            Tile.CompositeTile compositeTile;
            Tile.CompositeTile $this$findDownDonorTile_u24lambda_u245 = compositeTile = new Tile.CompositeTile();
            boolean bl = false;
            Iterable $this$forEach$iv2 = downDonors;
            boolean $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl4 = false;
                QuadKey tileKey = (QuadKey)entry.getKey();
                Tile tile2 = (Tile)entry.getValue();
                $this$findDownDonorTile_u24lambda_u245.add(tile2, this.subKey((QuadKey<World>)tileKey, cellKey));
            }
            tile = compositeTile;
        } else {
            tile = Tile.EmptyTile.Companion.getEMPTY_TILE();
        }
        return tile;
    }

    private final Tile findUpDonorTile(QuadKey<World> cellKey) {
        Tile tile;
        Map map2;
        Iterator $this$filterTo$iv$iv;
        Map<QuadKey<World>, Tile> $this$filter$iv = this.myExistedTiles;
        boolean $i$f$filter = false;
        Map<QuadKey<World>, Tile> map3 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!this.startsWith(cellKey, (QuadKey<World>)((QuadKey)it.getKey()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable iterable = destination$iv$iv.entrySet();
        $this$filterTo$iv$iv = iterable.iterator();
        if (!$this$filterTo$iv$iv.hasNext()) {
            map2 = null;
        } else {
            destination$iv$iv = $this$filterTo$iv$iv.next();
            if (!$this$filterTo$iv$iv.hasNext()) {
                map2 = destination$iv$iv;
            } else {
                Map.Entry it = (Map.Entry)((Object)destination$iv$iv);
                boolean bl = false;
                int n = ((QuadKey)it.getKey()).getLength();
                do {
                    Object t = $this$filterTo$iv$iv.next();
                    Map.Entry it2 = (Map.Entry)t;
                    $i$a$-maxByOrNull-DonorTileCalculator$findUpDonorTile$2 = false;
                    int n2 = ((QuadKey)it2.getKey()).getLength();
                    if (n >= n2) continue;
                    destination$iv$iv = t;
                    n = n2;
                } while ($this$filterTo$iv$iv.hasNext());
                map2 = destination$iv$iv;
            }
        }
        Map.Entry entry = (Map.Entry)((Object)map2);
        if (entry != null) {
            Map.Entry it = entry;
            boolean bl = false;
            tile = new Tile.SubTile((Tile)it.getValue(), this.subKey(cellKey, (QuadKey<World>)((QuadKey)it.getKey())));
        } else {
            tile = Tile.EmptyTile.Companion.getEMPTY_TILE();
        }
        return tile;
    }

    private final boolean startsWith(QuadKey<World> $this$startsWith, QuadKey<World> other) {
        return StringsKt.startsWith$default((String)$this$startsWith.getKey(), (String)other.getKey(), (boolean)false, (int)2, null);
    }

    private final QuadKey<World> subKey(QuadKey<World> $this$subKey, QuadKey<World> other) {
        String string = $this$subKey.getKey().substring(other.getLength());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new QuadKey(string);
    }

    public static final /* synthetic */ boolean access$startsWith(DonorTileCalculator $this, QuadKey $receiver, QuadKey other) {
        return $this.startsWith((QuadKey<World>)$receiver, (QuadKey<World>)other);
    }
}

