/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.gis.tileprotocol.TileService;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapTileSystemProvider;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.raster.RasterTileLoadingSystem;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.solid.SolidColorTileSystem;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.solid.SolidColorTileSystemKt;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileLoadingSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/Tilesets;", "", "()V", "chessboard", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapTileSystemProvider;", "black", "Lorg/jetbrains/letsPlot/commons/values/Color;", "white", "letsPlot", "tileService", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService;", "quantumIterations", "", "raster", "domains", "", "", "solid", "color", "livemap"})
public final class Tilesets {
    @NotNull
    public static final Tilesets INSTANCE = new Tilesets();

    private Tilesets() {
    }

    @NotNull
    public final BasemapTileSystemProvider chessboard(@NotNull Color black, @NotNull Color white) {
        Intrinsics.checkNotNullParameter((Object)black, (String)"black");
        Intrinsics.checkNotNullParameter((Object)white, (String)"white");
        return new BasemapTileSystemProvider(black, white){
            private final boolean isVector;
            final /* synthetic */ Color $black;
            final /* synthetic */ Color $white;
            {
                this.$black = $black;
                this.$white = $white;
            }

            @NotNull
            public AbstractSystem<LiveMapContext> create(@NotNull EcsComponentManager componentManager) {
                Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
                return new SolidColorTileSystem(SolidColorTileSystemKt.chessBoard(this.$black, this.$white), componentManager);
            }

            public boolean isVector() {
                return this.isVector;
            }
        };
    }

    public static /* synthetic */ BasemapTileSystemProvider chessboard$default(Tilesets tilesets, Color color, Color color2, int n, Object object) {
        if ((n & 1) != 0) {
            color = Color.Companion.getGRAY();
        }
        if ((n & 2) != 0) {
            color2 = Color.Companion.getLIGHT_GRAY();
        }
        return tilesets.chessboard(color, color2);
    }

    @NotNull
    public final BasemapTileSystemProvider solid(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return new BasemapTileSystemProvider(color){
            private final boolean isVector;
            final /* synthetic */ Color $color;
            {
                this.$color = $color;
            }

            @NotNull
            public AbstractSystem<LiveMapContext> create(@NotNull EcsComponentManager componentManager) {
                Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
                return new SolidColorTileSystem(SolidColorTileSystemKt.fixed(this.$color), componentManager);
            }

            public boolean isVector() {
                return this.isVector;
            }
        };
    }

    @NotNull
    public final BasemapTileSystemProvider raster(@NotNull List<String> domains) {
        Intrinsics.checkNotNullParameter(domains, (String)"domains");
        return new BasemapTileSystemProvider(domains){
            private final boolean isVector;
            final /* synthetic */ List<String> $domains;
            {
                this.$domains = $domains;
            }

            @NotNull
            public AbstractSystem<LiveMapContext> create(@NotNull EcsComponentManager componentManager) {
                Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
                return new RasterTileLoadingSystem(this.$domains, componentManager);
            }

            public boolean isVector() {
                return this.isVector;
            }
        };
    }

    @NotNull
    public final BasemapTileSystemProvider letsPlot(@NotNull TileService tileService, int quantumIterations) {
        Intrinsics.checkNotNullParameter((Object)tileService, (String)"tileService");
        return new BasemapTileSystemProvider(quantumIterations, tileService){
            private final boolean isVector;
            final /* synthetic */ int $quantumIterations;
            final /* synthetic */ TileService $tileService;
            {
                this.$quantumIterations = $quantumIterations;
                this.$tileService = $tileService;
                this.isVector = true;
            }

            @NotNull
            public AbstractSystem<LiveMapContext> create(@NotNull EcsComponentManager componentManager) {
                Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
                return new TileLoadingSystem(this.$quantumIterations, this.$tileService, componentManager);
            }

            public boolean isVector() {
                return this.isVector;
            }
        };
    }

    public static /* synthetic */ BasemapTileSystemProvider letsPlot$default(Tilesets tilesets, TileService tileService, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        return tilesets.letsPlot(tileService, n);
    }
}

