/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap.raster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.async.Asyncs;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKeyKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntityKt;
import org.jetbrains.letsPlot.livemap.core.layers.ParentLayerComponent;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskUtil;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroThreadComponentKt;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapCellComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapLayerKind;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapTileComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.KindComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.RequestTilesComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.Tile;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.raster.HttpTileTransport;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.raster.RasterTileLoadingSystem$getTileLayerEntities$;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\"#B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/raster/RasterTileLoadingSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "myDomains", "", "", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Ljava/util/List;Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "myIndex", "", "myTileTransport", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/raster/HttpTileTransport;", "drawErrorTile", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "errorCode", "", "context", "drawImageTile", "imageData", "", "getTileLayerEntities", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "cellKey", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "nextDomain", "updateImpl", "", "dt", "", "Companion", "HttpTileResponseComponent", "livemap"})
@SourceDebugExtension(value={"SMAP\nRasterTileLoadingSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasterTileLoadingSystem.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/raster/RasterTileLoadingSystem\n+ 2 AbstractSystem.kt\norg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem\n+ 3 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 4 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Extensions.kt\norg/jetbrains/letsPlot/livemap/core/ecs/ExtensionsKt\n*L\n1#1,160:1\n70#2:161\n34#2:168\n141#3:162\n68#4:163\n24#4,2:164\n24#4,2:169\n24#4,2:171\n70#4:178\n1855#5,2:166\n1549#5:173\n1620#5,3:174\n1855#5:177\n1856#5:180\n1#6:179\n9#7:181\n*S KotlinDebug\n*F\n+ 1 RasterTileLoadingSystem.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/raster/RasterTileLoadingSystem\n*L\n41#1:161\n60#1:168\n41#1:162\n41#1:163\n41#1:164,2\n61#1:169,2\n64#1:171,2\n89#1:178\n41#1:166,2\n67#1:173\n67#1:174,3\n89#1:177\n89#1:180\n89#1:179\n132#1:181\n*E\n"})
public final class RasterTileLoadingSystem
extends AbstractSystem<LiveMapContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> myDomains;
    private int myIndex;
    @NotNull
    private final HttpTileTransport myTileTransport;
    @NotNull
    private static final Vector TILE_PIXEL_DIMENSION = new Vector(256, 256);

    public RasterTileLoadingSystem(@NotNull List<String> myDomains, @NotNull EcsComponentManager componentManager) {
        Intrinsics.checkNotNullParameter(myDomains, (String)"myDomains");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        super(componentManager);
        this.myDomains = myDomains;
        this.myTileTransport = new HttpTileTransport();
    }

    private final String nextDomain() {
        String string;
        int n = this.myIndex;
        this.myIndex = n + 1;
        String it = string = this.myDomains.get(n);
        boolean bl = false;
        this.myIndex %= this.myDomains.size();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void updateImpl(@NotNull LiveMapContext context, double dt) {
        EcsEntity ecsEntity;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AbstractSystem this_$iv = this;
        boolean $i$f$getSingleton = false;
        EcsComponentManager this_$iv$iv = this_$iv.getComponentManager();
        boolean $i$f$getSingleton2 = false;
        EcsEntity this_$iv$iv$iv = this_$iv$iv.getSingletonEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(RequestTilesComponent.class));
        boolean $i$f$getComponent = false;
        EcsEntity this_$iv$iv$iv$iv = this_$iv$iv$iv;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (RequestTilesComponent)this_$iv$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(RequestTilesComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(RequestTilesComponent.class).getSimpleName() + " is not found");
        }
        Iterable $this$forEach$iv = ((RequestTilesComponent)ecsComponent).getRequestTiles();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            QuadKey cellKey = (QuadKey)element$iv;
            boolean bl = false;
            HttpTileResponseComponent tileResponseComponent = new HttpTileResponseComponent();
            EcsEntityKt.addComponents(this.createEntity("http_tile_" + cellKey), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>((QuadKey<World>)cellKey, tileResponseComponent){
                final /* synthetic */ QuadKey<World> $cellKey;
                final /* synthetic */ HttpTileResponseComponent $tileResponseComponent;
                {
                    this.$cellKey = $cellKey;
                    this.$tileResponseComponent = $tileResponseComponent;
                    super(1);
                }

                public final void invoke(@NotNull ComponentsList $this$addComponents) {
                    Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                    $this$addComponents.unaryPlus(new BasemapCellComponent(this.$cellKey));
                    $this$addComponents.unaryPlus(this.$tileResponseComponent);
                }
            }));
            this.myTileTransport.get(Companion.replacePlaceholders((QuadKey<World>)cellKey, this.nextDomain())).onResult((Function1)new Function1<byte[], Unit>(tileResponseComponent){
                final /* synthetic */ HttpTileResponseComponent $tileResponseComponent;
                {
                    this.$tileResponseComponent = $tileResponseComponent;
                    super(1);
                }

                public final void invoke(@NotNull byte[] it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$tileResponseComponent.setImageData(it);
                }
            }, (Function1)new Function1<Throwable, Unit>(tileResponseComponent){
                final /* synthetic */ HttpTileResponseComponent $tileResponseComponent;
                {
                    this.$tileResponseComponent = $tileResponseComponent;
                    super(1);
                }

                public final void invoke(@NotNull Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$tileResponseComponent.setImageData(new byte[0]);
                    this.$tileResponseComponent.setErrorCode(it);
                }
            });
        }
        ArrayList<EcsEntity> downloadedEntities = new ArrayList<EcsEntity>();
        AbstractSystem this_$iv2 = this;
        boolean $i$f$getEntities = false;
        Iterator $i$f$forEach22 = this_$iv2.getComponentManager().getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(HttpTileResponseComponent.class)).iterator();
        while ($i$f$forEach22.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            EcsEntity entity2;
            EcsEntity this_$iv3 = entity2 = (EcsEntity)$i$f$forEach22.next();
            boolean $i$f$get2 = false;
            EcsComponent ecsComponent2 = (HttpTileResponseComponent)this_$iv3.getComponentManager().getComponents(this_$iv3).get(Reflection.getOrCreateKotlinClass(HttpTileResponseComponent.class));
            if (ecsComponent2 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(HttpTileResponseComponent.class).getSimpleName() + " is not found");
            }
            HttpTileResponseComponent response = (HttpTileResponseComponent)ecsComponent2;
            if (response.getImageData() == null) continue;
            downloadedEntities.add(entity2);
            EcsEntity this_$iv4 = entity2;
            $i$f$get = false;
            EcsComponent ecsComponent3 = (BasemapCellComponent)this_$iv4.getComponentManager().getComponents(this_$iv4).get(Reflection.getOrCreateKotlinClass(BasemapCellComponent.class));
            if (ecsComponent3 == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapCellComponent.class).getSimpleName() + " is not found");
            }
            QuadKey<World> cellKey = ((BasemapCellComponent)ecsComponent3).getCellKey();
            Iterable $i$f$get3 = SequencesKt.toList(this.getTileLayerEntities(cellKey));
            boolean $i$f$map = false;
            ecsEntity = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void httpTileEntity;
                byte[] imageData;
                EcsEntity ecsEntity2 = (EcsEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MicroTaskUtil.INSTANCE.create((Function0<Unit>)((Function0)new Function0<Unit>(response, this, imageData, context, (EcsEntity)httpTileEntity){
                    final /* synthetic */ HttpTileResponseComponent $response;
                    final /* synthetic */ RasterTileLoadingSystem this$0;
                    final /* synthetic */ byte[] $imageData;
                    final /* synthetic */ LiveMapContext $context;
                    final /* synthetic */ EcsEntity $httpTileEntity;
                    {
                        this.$response = $response;
                        this.this$0 = $receiver;
                        this.$imageData = $imageData;
                        this.$context = $context;
                        this.$httpTileEntity = $httpTileEntity;
                        super(0);
                    }

                    public final void invoke() {
                        (this.$response.getErrorCode() == null ? RasterTileLoadingSystem.access$drawImageTile(this.this$0, this.$imageData, this.$context) : RasterTileLoadingSystem.access$drawErrorTile(this.this$0, this.$response.getErrorCode(), this.$context)).onSuccess((Function1)new Function1<Canvas.Snapshot, Unit>(this.this$0, this.$httpTileEntity, this.$response){
                            final /* synthetic */ RasterTileLoadingSystem this$0;
                            final /* synthetic */ EcsEntity $httpTileEntity;
                            final /* synthetic */ HttpTileResponseComponent $response;
                            {
                                this.this$0 = $receiver;
                                this.$httpTileEntity = $httpTileEntity;
                                this.$response = $response;
                                super(1);
                            }

                            public final void invoke(@NotNull Canvas.Snapshot snapshot) {
                                Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
                                RasterTileLoadingSystem.access$runLaterBySystem(this.this$0, this.$httpTileEntity, (Function1)new Function1<EcsEntity, Unit>(this.$response, snapshot){
                                    final /* synthetic */ HttpTileResponseComponent $response;
                                    final /* synthetic */ Canvas.Snapshot $snapshot;
                                    {
                                        this.$response = $response;
                                        this.$snapshot = $snapshot;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull EcsEntity theEntity) {
                                        Intrinsics.checkNotNullParameter((Object)theEntity, (String)"theEntity");
                                        EcsEntity this_$iv = theEntity;
                                        boolean $i$f$get = false;
                                        EcsComponent ecsComponent = (BasemapTileComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(BasemapTileComponent.class));
                                        if (ecsComponent == null) {
                                            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapTileComponent.class).getSimpleName() + " is not found");
                                        }
                                        EcsComponent ecsComponent2 = ecsComponent;
                                        HttpTileResponseComponent httpTileResponseComponent = this.$response;
                                        Canvas.Snapshot snapshot = this.$snapshot;
                                        BasemapTileComponent $this$invoke_u24lambda_u240 = (BasemapTileComponent)ecsComponent2;
                                        boolean bl = false;
                                        $this$invoke_u24lambda_u240.setNonCacheable(httpTileResponseComponent.getErrorCode() != null);
                                        $this$invoke_u24lambda_u240.setTile(new Tile.SnapshotTile(snapshot));
                                        ParentLayerComponent.Companion.tagDirtyParentLayer(theEntity);
                                    }
                                });
                            }
                        });
                    }
                })));
            }
            List microThreads2 = (List)destination$iv$iv;
            MicroTaskUtil.INSTANCE.join(microThreads2);
            MicroThreadComponentKt.setMicroThread(entity2, 1, MicroTaskUtil.INSTANCE.join(microThreads2));
        }
        Iterable $this$forEach$iv2 = downloadedEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            EcsEntity it = (EcsEntity)element$iv;
            boolean bl = false;
            EcsEntity this_$iv5 = it;
            boolean $i$f$remove = false;
            EcsEntity $this$remove_u24lambda_u242$iv = ecsEntity = this_$iv5;
            boolean bl2 = false;
            $this$remove_u24lambda_u242$iv.removeComponent((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(HttpTileResponseComponent.class));
        }
    }

    private final Async<Canvas.Snapshot> drawImageTile(byte[] imageData, LiveMapContext context) {
        return context.getMapRenderContext().getCanvasProvider().decodePng(imageData).map((Function1)new Function1<Canvas.Snapshot, Canvas.Snapshot>(context){
            final /* synthetic */ LiveMapContext $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final Canvas.Snapshot invoke(@NotNull Canvas.Snapshot imageSnapshot) {
                Intrinsics.checkNotNullParameter((Object)imageSnapshot, (String)"imageSnapshot");
                Canvas tileCanvas = this.$context.getMapRenderContext().getCanvasProvider().createCanvas(RasterTileLoadingSystem.Companion.getTILE_PIXEL_DIMENSION());
                tileCanvas.getContext2d().drawImage(imageSnapshot, 0.0, 0.0, 256.0, 256.0);
                return tileCanvas.takeSnapshot();
            }
        });
    }

    private final Async<Canvas.Snapshot> drawErrorTile(Throwable errorCode, LiveMapContext context) {
        Throwable throwable = errorCode;
        Intrinsics.checkNotNull((Object)throwable);
        String string = throwable.getMessage();
        if (string == null) {
            string = "Unknown error";
        }
        String errorText = string;
        Canvas tileCanvas = context.getMapRenderContext().getCanvasProvider().createCanvas(TILE_PIXEL_DIMENSION);
        Context2d tileCtx = tileCanvas.getContext2d();
        double textDim = tileCtx.measureTextWidth(errorText);
        double x = textDim < 256.0 ? 128.0 - textDim / (double)2 : 4.0;
        tileCtx.setFont(new Font(null, null, 0.0, null, 15, null));
        tileCtx.fillText(errorText, x, 128.0);
        return Asyncs.INSTANCE.constant((Object)tileCanvas.takeSnapshot());
    }

    private final Sequence<EcsEntity> getTileLayerEntities(QuadKey<World> cellKey) {
        AbstractSystem $this$getEntities2$iv = this;
        boolean $i$f$getEntities2 = false;
        return SequencesKt.filter((Sequence)SequencesKt.filter($this$getEntities2$iv.getComponentManager().getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(BasemapCellComponent.class)), (Function1)getTileLayerEntities$$inlined$getEntities2$1.INSTANCE), (Function1)((Function1)new Function1<EcsEntity, Boolean>(cellKey){
            final /* synthetic */ QuadKey<World> $cellKey;
            {
                this.$cellKey = $cellKey;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull EcsEntity it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                EcsEntity this_$iv = it;
                boolean $i$f$get = false;
                EcsComponent ecsComponent = (BasemapCellComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(BasemapCellComponent.class));
                if (ecsComponent == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(BasemapCellComponent.class).getSimpleName() + " is not found");
                }
                if (Intrinsics.areEqual(((BasemapCellComponent)ecsComponent).getCellKey(), this.$cellKey)) {
                    this_$iv = it;
                    $i$f$get = false;
                    EcsComponent ecsComponent2 = (KindComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(KindComponent.class));
                    if (ecsComponent2 == null) {
                        throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(KindComponent.class).getSimpleName() + " is not found");
                    }
                    if (((KindComponent)ecsComponent2).getLayerKind() == BasemapLayerKind.RASTER) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    public static final /* synthetic */ Async access$drawImageTile(RasterTileLoadingSystem $this, byte[] imageData, LiveMapContext context) {
        return $this.drawImageTile(imageData, context);
    }

    public static final /* synthetic */ Async access$drawErrorTile(RasterTileLoadingSystem $this, Throwable errorCode, LiveMapContext context) {
        return $this.drawErrorTile(errorCode, context);
    }

    public static final /* synthetic */ void access$runLaterBySystem(RasterTileLoadingSystem $this, EcsEntity entity2, Function1 entityHandler) {
        $this.runLaterBySystem(entity2, (Function1<EcsEntity, Unit>)entityHandler);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\u0006\u0010\r\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/raster/RasterTileLoadingSystem$Companion;", "", "()V", "TILE_PIXEL_DIMENSION", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "getTILE_PIXEL_DIMENSION", "()Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "replacePlaceholders", "", "cellKey", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "domain", "livemap"})
    @SourceDebugExtension(value={"SMAP\nRasterTileLoadingSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasterTileLoadingSystem.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/raster/RasterTileLoadingSystem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String replacePlaceholders(@NotNull QuadKey<World> cellKey, @NotNull String domain) {
            Intrinsics.checkNotNullParameter(cellKey, (String)"cellKey");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            double it = Math.pow(2.0, cellKey.getLength());
            boolean bl = false;
            Rect p0 = Rect.Companion.XYWH(0.0, 0.0, it, it);
            boolean bl2 = false;
            Vec it2 = QuadKeyKt.projectOrigin(cellKey, (Rect)p0);
            boolean bl3 = false;
            return StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)domain, (String)"{z}", (String)String.valueOf(cellKey.getLength()), (boolean)true), (String)"{x}", (String)String.valueOf(MathKt.roundToInt((double)it2.getX())), (boolean)true), (String)"{y}", (String)String.valueOf(MathKt.roundToInt((double)it2.getY())), (boolean)true);
        }

        @NotNull
        public final Vector getTILE_PIXEL_DIMENSION() {
            return TILE_PIXEL_DIMENSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/raster/RasterTileLoadingSystem$HttpTileResponseComponent;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponent;", "()V", "errorCode", "", "getErrorCode", "()Ljava/lang/Throwable;", "setErrorCode", "(Ljava/lang/Throwable;)V", "imageData", "", "getImageData", "()[B", "setImageData", "([B)V", "livemap"})
    public static final class HttpTileResponseComponent
    implements EcsComponent {
        @Nullable
        private byte[] imageData;
        @Nullable
        private Throwable errorCode;

        @Nullable
        public final byte[] getImageData() {
            return this.imageData;
        }

        public final void setImageData(@Nullable byte[] byArray) {
            this.imageData = byArray;
        }

        @Nullable
        public final Throwable getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(@Nullable Throwable throwable) {
            this.errorCode = throwable;
        }
    }
}

